/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CBUtil;
import com.datastax.driver.core.Frame;
import com.datastax.driver.core.exceptions.DriverInternalError;
import java.io.IOException;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import org.jboss.netty.buffer.ChannelBuffers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xerial.snappy.Snappy;

abstract class FrameCompressor {
    private static final Logger logger = LoggerFactory.getLogger(FrameCompressor.class);

    FrameCompressor() {
    }

    public abstract Frame compress(Frame var1) throws IOException;

    public abstract Frame decompress(Frame var1) throws IOException;

    public static class LZ4Compressor
    extends FrameCompressor {
        public static final LZ4Compressor instance;
        private static final int INTEGER_BYTES = 4;
        private final net.jpountz.lz4.LZ4Compressor compressor;
        private final LZ4FastDecompressor decompressor;

        private LZ4Compressor() {
            LZ4Factory lz4Factory = LZ4Factory.fastestInstance();
            this.compressor = lz4Factory.fastCompressor();
            this.decompressor = lz4Factory.fastDecompressor();
        }

        @Override
        public Frame compress(Frame frame) throws IOException {
            byte[] input = CBUtil.readRawBytes(frame.body);
            int maxCompressedLength = this.compressor.maxCompressedLength(input.length);
            byte[] output = new byte[4 + maxCompressedLength];
            output[0] = (byte)(input.length >>> 24);
            output[1] = (byte)(input.length >>> 16);
            output[2] = (byte)(input.length >>> 8);
            output[3] = (byte)input.length;
            try {
                int written = this.compressor.compress(input, 0, input.length, output, 4, maxCompressedLength);
                return frame.with(ChannelBuffers.wrappedBuffer((byte[])output, (int)0, (int)(4 + written)));
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        @Override
        public Frame decompress(Frame frame) throws IOException {
            byte[] input = CBUtil.readRawBytes(frame.body);
            int uncompressedLength = (input[0] & 0xFF) << 24 | (input[1] & 0xFF) << 16 | (input[2] & 0xFF) << 8 | input[3] & 0xFF;
            byte[] output = new byte[uncompressedLength];
            try {
                int read = this.decompressor.decompress(input, 4, output, 0, uncompressedLength);
                if (read != input.length - 4) {
                    throw new IOException("Compressed lengths mismatch");
                }
                return frame.with(ChannelBuffers.wrappedBuffer((byte[])output));
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        static {
            LZ4Compressor i;
            try {
                i = new LZ4Compressor();
            }
            catch (NoClassDefFoundError e) {
                i = null;
                logger.warn("Cannot find LZ4 class, you should make sure the LZ4 library is in the classpath if you intend to use it. LZ4 compression will not be available for the protocol.");
            }
            catch (Throwable e) {
                i = null;
                logger.warn("Error loading LZ4 library ({}). LZ4 compression will not be available for the protocol.", (Object)e.toString());
            }
            instance = i;
        }
    }

    public static class SnappyCompressor
    extends FrameCompressor {
        public static final SnappyCompressor instance;

        private SnappyCompressor() {
            Snappy.getNativeLibraryVersion();
        }

        @Override
        public Frame compress(Frame frame) throws IOException {
            byte[] input = CBUtil.readRawBytes(frame.body);
            byte[] output = new byte[Snappy.maxCompressedLength((int)input.length)];
            int written = Snappy.compress((byte[])input, (int)0, (int)input.length, (byte[])output, (int)0);
            return frame.with(ChannelBuffers.wrappedBuffer((byte[])output, (int)0, (int)written));
        }

        @Override
        public Frame decompress(Frame frame) throws IOException {
            byte[] input = CBUtil.readRawBytes(frame.body);
            if (!Snappy.isValidCompressedBuffer((byte[])input, (int)0, (int)input.length)) {
                throw new DriverInternalError("Provided frame does not appear to be Snappy compressed");
            }
            byte[] output = new byte[Snappy.uncompressedLength((byte[])input)];
            int size = Snappy.uncompress((byte[])input, (int)0, (int)input.length, (byte[])output, (int)0);
            return frame.with(ChannelBuffers.wrappedBuffer((byte[])output, (int)0, (int)size));
        }

        static {
            SnappyCompressor i;
            try {
                i = new SnappyCompressor();
            }
            catch (NoClassDefFoundError e) {
                i = null;
                logger.warn("Cannot find Snappy class, you should make sure the Snappy library is in the classpath if you intend to use it. Snappy compression will not be available for the protocol.");
            }
            catch (Throwable e) {
                i = null;
                logger.warn("Error loading Snappy library ({}). Snappy compression will not be available for the protocol.", (Object)e.toString());
            }
            instance = i;
        }
    }
}

