/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;

public abstract class ShutdownFuture
extends AbstractFuture<Void> {
    ShutdownFuture() {
    }

    static ShutdownFuture immediateFuture() {
        ShutdownFuture future = new ShutdownFuture(){

            @Override
            public ShutdownFuture force() {
                return this;
            }
        };
        future.set(null);
        return future;
    }

    public abstract ShutdownFuture force();

    static class Forwarding
    extends ShutdownFuture {
        private final List<ShutdownFuture> futures;

        Forwarding(List<ShutdownFuture> futures) {
            this.futures = futures;
            Futures.addCallback((ListenableFuture)Futures.allAsList(futures), (FutureCallback)new FutureCallback<List<Void>>(){

                public void onFailure(Throwable t) {
                    Forwarding.this.setException(t);
                }

                public void onSuccess(List<Void> v) {
                    Forwarding.this.onFuturesDone();
                }
            });
        }

        @Override
        public ShutdownFuture force() {
            for (ShutdownFuture future : this.futures) {
                future.force();
            }
            return this;
        }

        protected void onFuturesDone() {
            this.set(null);
        }
    }
}

