/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.querybuilder;

import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.querybuilder.BuiltStatement;
import com.datastax.driver.core.querybuilder.Using;
import com.datastax.driver.core.querybuilder.Utils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class Batch
extends BuiltStatement {
    private final List<RegularStatement> statements;
    private final boolean logged;
    private final Options usings;
    private ByteBuffer routingKey;

    Batch(RegularStatement[] statements, boolean logged) {
        super((String)null);
        this.statements = statements.length == 0 ? new ArrayList<RegularStatement>() : new ArrayList(statements.length);
        this.logged = logged;
        this.usings = new Options(this);
        for (int i = 0; i < statements.length; ++i) {
            this.add(statements[i]);
        }
    }

    @Override
    StringBuilder buildQueryString(List<ByteBuffer> variables) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.isCounterOp() ? "BEGIN COUNTER BATCH" : (this.logged ? "BEGIN BATCH" : "BEGIN UNLOGGED BATCH"));
        if (!this.usings.usings.isEmpty()) {
            builder.append(" USING ");
            Utils.joinAndAppend(builder, " AND ", this.usings.usings, variables);
        }
        builder.append(" ");
        for (int i = 0; i < this.statements.size(); ++i) {
            ByteBuffer[] vars;
            RegularStatement stmt = this.statements.get(i);
            if (stmt instanceof BuiltStatement) {
                BuiltStatement bst = (BuiltStatement)stmt;
                builder.append((CharSequence)Batch.maybeAddSemicolon(bst.buildQueryString(variables)));
                continue;
            }
            String str = stmt.getQueryString();
            builder.append(str);
            if (!str.trim().endsWith(";")) {
                builder.append(";");
            }
            if (variables == null || (vars = stmt.getValues()) == null) continue;
            for (int idx = 0; idx < vars.length; ++idx) {
                variables.add(vars[idx]);
            }
        }
        builder.append("APPLY BATCH;");
        return builder;
    }

    public Batch add(RegularStatement statement) {
        boolean isCounterOp;
        boolean bl = isCounterOp = statement instanceof BuiltStatement && ((BuiltStatement)statement).isCounterOp();
        if (this.isCounterOp == null) {
            this.setCounterOp(isCounterOp);
        } else if (this.isCounterOp() != isCounterOp) {
            throw new IllegalArgumentException("Cannot mix counter operations and non-counter operations in a batch statement");
        }
        this.statements.add(statement);
        this.hasBindMarkers = statement instanceof BuiltStatement ? ((BuiltStatement)statement).hasBindMarkers : true;
        this.checkForBindMarkers(null);
        if (this.routingKey == null && statement.getRoutingKey() != null) {
            this.routingKey = statement.getRoutingKey();
        }
        return this;
    }

    public Options using(Using using) {
        return this.usings.and(using);
    }

    @Override
    public ByteBuffer getRoutingKey() {
        return this.routingKey;
    }

    @Override
    public String getKeyspace() {
        return this.statements.isEmpty() ? null : this.statements.get(0).getKeyspace();
    }

    public static class Options
    extends BuiltStatement.ForwardingStatement<Batch> {
        private final List<Using> usings = new ArrayList<Using>();

        Options(Batch statement) {
            super(statement);
        }

        public Options and(Using using) {
            this.usings.add(using);
            this.checkForBindMarkers(using);
            return this;
        }

        public Batch add(RegularStatement statement) {
            return ((Batch)this.statement).add(statement);
        }
    }
}

