/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.Authenticator;
import com.datastax.driver.core.BusyConnectionException;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Configuration;
import com.datastax.driver.core.ConnectionException;
import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.Frame;
import com.datastax.driver.core.FrameCompressor;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.Message;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.RequestHandler;
import com.datastax.driver.core.Requests;
import com.datastax.driver.core.Responses;
import com.datastax.driver.core.SSLOptions;
import com.datastax.driver.core.ShutdownFuture;
import com.datastax.driver.core.SocketOptions;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.StreamIdGenerator;
import com.datastax.driver.core.TransportException;
import com.datastax.driver.core.exceptions.AuthenticationException;
import com.datastax.driver.core.exceptions.DriverInternalError;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.common.util.concurrent.Uninterruptibles;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLEngine;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Connection {
    private static final Logger logger = LoggerFactory.getLogger(Connection.class);
    public final InetAddress address;
    private final String name;
    private final Channel channel;
    private final Factory factory;
    private final Dispatcher dispatcher = new Dispatcher();
    public final AtomicInteger inFlight = new AtomicInteger(0);
    private final AtomicInteger writer = new AtomicInteger(0);
    private volatile String keyspace;
    private volatile boolean isDefunct;
    private volatile ConnectionException exception;
    private final AtomicReference<ConnectionShutdownFuture> shutdownFuture = new AtomicReference();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection(String name, InetAddress address, Factory factory) throws ConnectionException, InterruptedException {
        this.address = address;
        this.factory = factory;
        this.name = name;
        ClientBootstrap bootstrap = factory.newBootstrap();
        ProtocolOptions protocolOptions = factory.configuration.getProtocolOptions();
        bootstrap.setPipelineFactory((ChannelPipelineFactory)new PipelineFactory(this, protocolOptions.getCompression().compressor, protocolOptions.getSSLOptions()));
        ChannelFuture future = bootstrap.connect((SocketAddress)new InetSocketAddress(address, factory.getPort()));
        this.writer.incrementAndGet();
        try {
            this.channel = future.awaitUninterruptibly().getChannel();
            this.factory.allChannels.add((Object)this.channel);
            if (!future.isSuccess()) {
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("[%s] Error connecting to %s%s", name, address, Connection.extractMessage(future.getCause())));
                }
                throw new TransportException(address, "Cannot connect", future.getCause());
            }
        }
        finally {
            this.writer.decrementAndGet();
        }
        logger.trace("[{}] Connection opened successfully", (Object)name);
        this.initializeTransport();
        logger.trace("[{}] Transport initialized and ready", (Object)name);
    }

    private static String extractMessage(Throwable t) {
        if (t == null) {
            return "";
        }
        String msg = t.getMessage() == null || t.getMessage().isEmpty() ? t.toString() : t.getMessage();
        return " (" + msg + ")";
    }

    private void initializeTransport() throws ConnectionException, InterruptedException {
        try {
            ProtocolOptions.Compression compression = this.factory.configuration.getProtocolOptions().getCompression();
            Message.Response response = (Message.Response)this.write(new Requests.Startup(compression)).get();
            switch (response.type) {
                case READY: {
                    break;
                }
                case ERROR: {
                    throw this.defunct(new TransportException(this.address, String.format("Error initializing connection: %s", ((Responses.Error)response).message)));
                }
                case AUTHENTICATE: {
                    Authenticator authenticator = this.factory.authProvider.newAuthenticator(this.address);
                    byte[] initialResponse = authenticator.initialResponse();
                    if (null == initialResponse) {
                        initialResponse = new byte[]{};
                    }
                    Message.Response authResponse = (Message.Response)this.write(new Requests.AuthResponse(initialResponse)).get();
                    this.waitForAuthCompletion(authResponse, authenticator);
                    break;
                }
                default: {
                    throw this.defunct(new TransportException(this.address, String.format("Unexpected %s response message from server to a STARTUP message", new Object[]{response.type})));
                }
            }
        }
        catch (BusyConnectionException e) {
            throw new DriverInternalError("Newly created connection should not be busy");
        }
        catch (ExecutionException e) {
            throw this.defunct(new ConnectionException(this.address, String.format("Unexpected error during transport initialization (%s)", e.getCause()), e.getCause()));
        }
    }

    private void waitForAuthCompletion(Message.Response authResponse, Authenticator authenticator) throws ConnectionException, BusyConnectionException, ExecutionException, InterruptedException {
        switch (authResponse.type) {
            case AUTH_SUCCESS: {
                logger.trace("Authentication complete");
                authenticator.onAuthenticationSuccess(((Responses.AuthSuccess)authResponse).token);
                break;
            }
            case AUTH_CHALLENGE: {
                byte[] responseToServer = authenticator.evaluateChallenge(((Responses.AuthChallenge)authResponse).token);
                if (responseToServer == null) {
                    logger.trace("Authentication complete (No response to server)");
                    return;
                }
                logger.trace("Sending Auth response to challenge");
                this.waitForAuthCompletion((Message.Response)this.write(new Requests.AuthResponse(responseToServer)).get(), authenticator);
                break;
            }
            case ERROR: {
                throw new AuthenticationException(this.address, ((Responses.Error)authResponse).message);
            }
            default: {
                throw new TransportException(this.address, String.format("Unexpected %s response message from server to authentication message", new Object[]{authResponse.type}));
            }
        }
    }

    public boolean isDefunct() {
        return this.isDefunct;
    }

    public int maxAvailableStreams() {
        return this.dispatcher.streamIdHandler.maxAvailableStreams();
    }

    public ConnectionException lastException() {
        return this.exception;
    }

    ConnectionException defunct(ConnectionException e) {
        if (logger.isDebugEnabled()) {
            logger.debug("Defuncting connection to " + this.address, (Throwable)e);
        }
        this.exception = e;
        this.isDefunct = true;
        this.dispatcher.errorOutAllHandler(e);
        this.close();
        return e;
    }

    public String keyspace() {
        return this.keyspace;
    }

    public void setKeyspace(String keyspace) throws ConnectionException {
        if (keyspace == null) {
            return;
        }
        if (this.keyspace != null && this.keyspace.equals(keyspace)) {
            return;
        }
        try {
            logger.trace("[{}] Setting keyspace {}", (Object)this.name, (Object)keyspace);
            long timeout = this.factory.getConnectTimeoutMillis();
            Future future = this.write(new Requests.Query("USE \"" + keyspace + "\""));
            Message.Response response = (Message.Response)Uninterruptibles.getUninterruptibly((java.util.concurrent.Future)((Object)future), (long)timeout, (TimeUnit)TimeUnit.MILLISECONDS);
            switch (response.type) {
                case RESULT: {
                    this.keyspace = keyspace;
                    break;
                }
                default: {
                    this.defunct(new ConnectionException(this.address, String.format("Problem while setting keyspace, got %s as response", response)));
                    break;
                }
            }
        }
        catch (ConnectionException e) {
            throw this.defunct(e);
        }
        catch (TimeoutException e) {
            logger.warn(String.format("Timeout while setting keyspace on connection to %s. This should not happen but is not critical (it will retried)", this.address));
        }
        catch (BusyConnectionException e) {
            logger.warn(String.format("Tried to set the keyspace on busy connection to %s. This should not happen but is not critical (it will retried)", this.address));
        }
        catch (ExecutionException e) {
            throw this.defunct(new ConnectionException(this.address, "Error while setting keyspace", e));
        }
    }

    public Future write(Message.Request request) throws ConnectionException, BusyConnectionException {
        Future future = new Future(request);
        this.write(future);
        return future;
    }

    public ResponseHandler write(ResponseCallback callback) throws ConnectionException, BusyConnectionException {
        Message.Request request = callback.request();
        ResponseHandler handler = new ResponseHandler(this, callback);
        this.dispatcher.add(handler);
        request.setStreamId(handler.streamId);
        if (this.isDefunct) {
            this.dispatcher.removeHandler(handler.streamId, true);
            throw new ConnectionException(this.address, "Write attempt on defunct connection");
        }
        if (this.isClosed()) {
            this.dispatcher.removeHandler(handler.streamId, true);
            throw new ConnectionException(this.address, "Connection has been closed");
        }
        logger.trace("[{}] writing request {}", (Object)this.name, (Object)request);
        this.writer.incrementAndGet();
        this.channel.write((Object)request).addListener(this.writeHandler(request, handler));
        return handler;
    }

    private ChannelFutureListener writeHandler(final Message.Request request, final ResponseHandler handler) {
        return new ChannelFutureListener(){

            public void operationComplete(ChannelFuture writeFuture) {
                Connection.this.writer.decrementAndGet();
                if (!writeFuture.isSuccess()) {
                    logger.debug("[{}] Error writing request {}", (Object)Connection.this.name, (Object)request);
                    Connection.this.dispatcher.removeHandler(handler.streamId, true);
                    TransportException ce = writeFuture.getCause() instanceof ClosedChannelException ? new TransportException(Connection.this.address, "Error writing: Closed channel") : new TransportException(Connection.this.address, "Error writing", writeFuture.getCause());
                    handler.callback.onException(Connection.this, Connection.this.defunct(ce), System.nanoTime() - handler.startTime);
                } else {
                    logger.trace("[{}] request sent successfully", (Object)Connection.this.name);
                }
            }
        };
    }

    public boolean isClosed() {
        return this.shutdownFuture.get() != null;
    }

    public ShutdownFuture close() {
        ConnectionShutdownFuture future = new ConnectionShutdownFuture();
        if (!this.shutdownFuture.compareAndSet(null, future)) {
            return this.shutdownFuture.get();
        }
        logger.trace("[{}] closing connection", (Object)this.name);
        if (this.dispatcher.pending.isEmpty()) {
            future.force();
        }
        return future;
    }

    public String toString() {
        return String.format("Connection[%s, inFlight=%d, closed=%b]", this.name, this.inFlight.get(), this.isClosed());
    }

    private static class PipelineFactory
    implements ChannelPipelineFactory {
        private static final Message.ProtocolDecoder messageDecoder = new Message.ProtocolDecoder();
        private static final Message.ProtocolEncoder messageEncoder = new Message.ProtocolEncoder();
        private static final Frame.Encoder frameEncoder = new Frame.Encoder();
        private final Connection connection;
        private final FrameCompressor compressor;
        private final SSLOptions sslOptions;

        public PipelineFactory(Connection connection, FrameCompressor compressor, SSLOptions sslOptions) {
            this.connection = connection;
            this.compressor = compressor;
            this.sslOptions = sslOptions;
        }

        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline pipeline = Channels.pipeline();
            if (this.sslOptions != null) {
                SSLEngine engine = this.sslOptions.context.createSSLEngine();
                engine.setUseClientMode(true);
                engine.setEnabledCipherSuites(this.sslOptions.cipherSuites);
                SslHandler handler = new SslHandler(engine);
                handler.setCloseOnSSLException(true);
                pipeline.addLast("ssl", (ChannelHandler)handler);
            }
            pipeline.addLast("frameDecoder", (ChannelHandler)new Frame.Decoder());
            pipeline.addLast("frameEncoder", (ChannelHandler)frameEncoder);
            if (this.compressor != null) {
                pipeline.addLast("frameDecompressor", (ChannelHandler)new Frame.Decompressor(this.compressor));
                pipeline.addLast("frameCompressor", (ChannelHandler)new Frame.Compressor(this.compressor));
            }
            pipeline.addLast("messageDecoder", (ChannelHandler)messageDecoder);
            pipeline.addLast("messageEncoder", (ChannelHandler)messageEncoder);
            pipeline.addLast("dispatcher", (ChannelHandler)this.connection.dispatcher);
            return pipeline;
        }
    }

    public static interface DefaultResponseHandler {
        public void handle(Message.Response var1);
    }

    static class ResponseHandler {
        public final Connection connection;
        public final int streamId;
        public final ResponseCallback callback;
        private final Timeout timeout;
        private final long startTime;

        public ResponseHandler(Connection connection, ResponseCallback callback) throws BusyConnectionException {
            this.connection = connection;
            this.streamId = ((Connection)connection).dispatcher.streamIdHandler.next();
            this.callback = callback;
            long timeoutMs = connection.factory.getReadTimeoutMillis();
            this.timeout = timeoutMs <= 0L ? null : ((Connection)connection).factory.timer.newTimeout(this.onTimeoutTask(), timeoutMs, TimeUnit.MILLISECONDS);
            this.startTime = System.nanoTime();
        }

        void cancelTimeout() {
            if (this.timeout != null) {
                this.timeout.cancel();
            }
        }

        public void cancelHandler() {
            this.connection.dispatcher.removeHandler(this.streamId, false);
        }

        private TimerTask onTimeoutTask() {
            return new TimerTask(){

                public void run(Timeout timeout) {
                    ResponseHandler.this.callback.onTimeout(ResponseHandler.this.connection, System.nanoTime() - ResponseHandler.this.startTime);
                    ResponseHandler.this.cancelHandler();
                }
            };
        }
    }

    static interface ResponseCallback {
        public Message.Request request();

        public void onSet(Connection var1, Message.Response var2, long var3);

        public void onException(Connection var1, Exception var2, long var3);

        public void onTimeout(Connection var1, long var2);
    }

    static class Future
    extends AbstractFuture<Message.Response>
    implements RequestHandler.Callback {
        private final Message.Request request;
        private volatile InetAddress address;

        public Future(Message.Request request) {
            this.request = request;
        }

        @Override
        public void register(RequestHandler handler) {
        }

        @Override
        public Message.Request request() {
            return this.request;
        }

        @Override
        public void onSet(Connection connection, Message.Response response, ExecutionInfo info, Statement statement, long latency) {
            this.onSet(connection, response, latency);
        }

        @Override
        public void onSet(Connection connection, Message.Response response, long latency) {
            this.address = connection.address;
            super.set((Object)response);
        }

        @Override
        public void onException(Connection connection, Exception exception, long latency) {
            if (connection != null) {
                this.address = connection.address;
            }
            super.setException((Throwable)exception);
        }

        @Override
        public void onTimeout(Connection connection, long latency) {
            assert (connection != null);
            this.address = connection.address;
            super.setException((Throwable)new ConnectionException(connection.address, "Operation Timeouted"));
        }

        public InetAddress getAddress() {
            return this.address;
        }
    }

    private class ConnectionShutdownFuture
    extends ShutdownFuture {
        private ConnectionShutdownFuture() {
        }

        @Override
        public ConnectionShutdownFuture force() {
            if (Connection.this.channel == null) {
                this.set(null);
                return this;
            }
            Connection.this.dispatcher.errorOutAllHandler(new TransportException(Connection.this.address, "Connection has been closed"));
            ChannelFuture future = Connection.this.channel.close();
            future.addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) {
                    if (future.getCause() != null) {
                        ConnectionShutdownFuture.this.setException(future.getCause());
                    } else {
                        ConnectionShutdownFuture.this.set(null);
                    }
                }
            });
            return this;
        }
    }

    private class Dispatcher
    extends SimpleChannelUpstreamHandler {
        public final StreamIdGenerator streamIdHandler = new StreamIdGenerator();
        private final ConcurrentMap<Integer, ResponseHandler> pending = new ConcurrentHashMap<Integer, ResponseHandler>();

        private Dispatcher() {
        }

        public void add(ResponseHandler handler) {
            ResponseHandler old = this.pending.put(handler.streamId, handler);
            assert (old == null);
        }

        public void removeHandler(int streamId, boolean releaseStreamId) {
            ResponseHandler handler;
            if (!releaseStreamId) {
                this.streamIdHandler.mark(streamId);
            }
            if ((handler = (ResponseHandler)this.pending.remove(streamId)) != null) {
                handler.cancelTimeout();
            }
            if (releaseStreamId) {
                this.streamIdHandler.release(streamId);
            }
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
            if (!(e.getMessage() instanceof Message.Response)) {
                logger.error("[{}] Received unexpected message: {}", (Object)Connection.this.name, e.getMessage());
                Connection.this.defunct(new TransportException(Connection.this.address, "Unexpected message received: " + e.getMessage()));
            } else {
                Message.Response response = (Message.Response)e.getMessage();
                int streamId = response.getStreamId();
                logger.trace("[{}] received: {}", (Object)Connection.this.name, e.getMessage());
                if (streamId < 0) {
                    ((Connection)Connection.this).factory.defaultHandler.handle(response);
                    return;
                }
                ResponseHandler handler = (ResponseHandler)this.pending.remove(streamId);
                this.streamIdHandler.release(streamId);
                if (handler == null) {
                    this.streamIdHandler.unmark(streamId);
                    logger.debug("[{}] Response received on stream {} but no handler set anymore (either the request has timeouted or it was closed due to another error). Received message is {}", new Object[]{Connection.this.name, streamId, response});
                    return;
                }
                handler.cancelTimeout();
                handler.callback.onSet(Connection.this, response, System.nanoTime() - handler.startTime);
                if (Connection.this.isClosed() && this.pending.isEmpty()) {
                    ((ConnectionShutdownFuture)((Object)Connection.this.shutdownFuture.get())).force();
                }
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("[%s] connection error", Connection.this.name), e.getCause());
            }
            if (Connection.this.writer.get() > 0) {
                return;
            }
            Connection.this.defunct(new TransportException(Connection.this.address, String.format("Unexpected exception triggered (%s)", e.getCause()), e.getCause()));
        }

        public void errorOutAllHandler(ConnectionException ce) {
            Iterator iter = this.pending.values().iterator();
            while (iter.hasNext()) {
                ResponseHandler handler = (ResponseHandler)iter.next();
                handler.callback.onException(Connection.this, ce, System.nanoTime() - handler.startTime);
                iter.remove();
            }
        }

        public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) {
            if (Connection.this.isClosed()) {
                this.errorOutAllHandler(new TransportException(Connection.this.address, "Channel has been closed"));
            } else {
                Connection.this.defunct(new TransportException(Connection.this.address, "Channel has been closed"));
            }
        }
    }

    public static class Factory {
        private final ExecutorService bossExecutor = Executors.newCachedThreadPool();
        private final ExecutorService workerExecutor = Executors.newCachedThreadPool();
        public final HashedWheelTimer timer = new HashedWheelTimer(new ThreadFactoryBuilder().setNameFormat("Timeouter-%d").build());
        private final ChannelFactory channelFactory = new NioClientSocketChannelFactory((Executor)this.bossExecutor, (Executor)this.workerExecutor);
        private final ChannelGroup allChannels = new DefaultChannelGroup();
        private final ConcurrentMap<Host, AtomicInteger> idGenerators = new ConcurrentHashMap<Host, AtomicInteger>();
        public final DefaultResponseHandler defaultHandler;
        public final Configuration configuration;
        public final AuthProvider authProvider;
        private volatile boolean isShutdown;

        public Factory(Cluster.Manager manager, AuthProvider authProvider) {
            this(manager, manager.configuration, authProvider);
        }

        private Factory(DefaultResponseHandler defaultHandler, Configuration configuration, AuthProvider authProvider) {
            this.defaultHandler = defaultHandler;
            this.configuration = configuration;
            this.authProvider = authProvider;
        }

        public int getPort() {
            return this.configuration.getProtocolOptions().getPort();
        }

        public Connection open(Host host) throws ConnectionException, InterruptedException {
            InetAddress address = host.getAddress();
            if (this.isShutdown) {
                throw new ConnectionException(address, "Connection factory is shut down");
            }
            String name = address.toString() + "-" + this.getIdGenerator(host).getAndIncrement();
            return new Connection(name, address, this);
        }

        private AtomicInteger getIdGenerator(Host host) {
            AtomicInteger old;
            AtomicInteger g = (AtomicInteger)this.idGenerators.get(host);
            if (g == null && (old = this.idGenerators.putIfAbsent(host, g = new AtomicInteger(1))) != null) {
                g = old;
            }
            return g;
        }

        public long getConnectTimeoutMillis() {
            return this.configuration.getSocketOptions().getConnectTimeoutMillis();
        }

        public long getReadTimeoutMillis() {
            return this.configuration.getSocketOptions().getReadTimeoutMillis();
        }

        private ClientBootstrap newBootstrap() {
            Integer sendBufferSize;
            Integer receiveBufferSize;
            Boolean tcpNoDelay;
            Integer soLinger;
            Boolean reuseAddress;
            ClientBootstrap b = new ClientBootstrap(this.channelFactory);
            SocketOptions options = this.configuration.getSocketOptions();
            b.setOption("connectTimeoutMillis", (Object)options.getConnectTimeoutMillis());
            Boolean keepAlive = options.getKeepAlive();
            if (keepAlive != null) {
                b.setOption("keepAlive", (Object)keepAlive);
            }
            if ((reuseAddress = options.getReuseAddress()) != null) {
                b.setOption("reuseAddress", (Object)reuseAddress);
            }
            if ((soLinger = options.getSoLinger()) != null) {
                b.setOption("soLinger", (Object)soLinger);
            }
            if ((tcpNoDelay = options.getTcpNoDelay()) != null) {
                b.setOption("tcpNoDelay", (Object)tcpNoDelay);
            }
            if ((receiveBufferSize = options.getReceiveBufferSize()) != null) {
                b.setOption("receiveBufferSize", (Object)receiveBufferSize);
            }
            if ((sendBufferSize = options.getSendBufferSize()) != null) {
                b.setOption("sendBufferSize", (Object)sendBufferSize);
            }
            return b;
        }

        public void shutdown() {
            this.isShutdown = true;
            this.allChannels.close().awaitUninterruptibly();
            this.channelFactory.releaseExternalResources();
            this.timer.stop();
        }
    }
}

