/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Host;
import com.datastax.driver.core.Token;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

abstract class ReplicationStrategy {
    ReplicationStrategy() {
    }

    static ReplicationStrategy create(Map<String, String> replicationOptions) {
        String repFactorString;
        String strategyClass = replicationOptions.get("class");
        if (strategyClass == null | (repFactorString = replicationOptions.get("replication_factor")) == null) {
            return null;
        }
        try {
            if (strategyClass.contains("SimpleStrategy")) {
                return new SimpleStrategy(Integer.parseInt(repFactorString));
            }
            if (strategyClass.contains("SimpleStrategy")) {
                HashMap<String, Integer> dcRfs = new HashMap<String, Integer>();
                for (Map.Entry<String, String> entry : replicationOptions.entrySet()) {
                    if (entry.getKey().equals("class")) continue;
                    dcRfs.put(entry.getKey(), Integer.parseInt(entry.getValue()));
                }
                return new NetworkTopologyStrategy(dcRfs);
            }
            return null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    abstract Map<Token, Set<Host>> computeTokenToReplicaMap(Map<Token, Host> var1, List<Token> var2);

    private static Token getTokenWrapping(int i, List<Token> ring) {
        return ring.get(i % ring.size());
    }

    static class NetworkTopologyStrategy
    extends ReplicationStrategy {
        private final Map<String, Integer> replicationFactors;

        private NetworkTopologyStrategy(Map<String, Integer> replicationFactors) {
            this.replicationFactors = replicationFactors;
        }

        @Override
        Map<Token, Set<Host>> computeTokenToReplicaMap(Map<Token, Host> tokenToPrimary, List<Token> ring) {
            HashMap<Token, Set<Host>> replicaMap = new HashMap<Token, Set<Host>>(tokenToPrimary.size());
            for (int i = 0; i < ring.size(); ++i) {
                HashMap<String, Integer> remainings = new HashMap<String, Integer>(this.replicationFactors);
                ImmutableSet.Builder builder = ImmutableSet.builder();
                for (int j = 0; j < ring.size(); ++j) {
                    Integer remaining;
                    Host h = tokenToPrimary.get(ReplicationStrategy.getTokenWrapping(j, ring));
                    String dc = h.getDatacenter();
                    if (dc == null || (remaining = (Integer)remainings.get(dc)) <= 0) continue;
                    builder.add((Object)h);
                    remainings.put(dc, remaining - 1);
                    if (this.allDone(remainings)) break;
                }
                replicaMap.put(ring.get(i), (Set<Host>)builder.build());
            }
            return replicaMap;
        }

        private boolean allDone(Map<String, Integer> map) {
            for (Map.Entry<String, Integer> entry : map.entrySet()) {
                if (entry.getValue() <= 0) continue;
                return false;
            }
            return true;
        }
    }

    static class SimpleStrategy
    extends ReplicationStrategy {
        private final int replicationFactor;

        private SimpleStrategy(int replicationFactor) {
            this.replicationFactor = replicationFactor;
        }

        @Override
        Map<Token, Set<Host>> computeTokenToReplicaMap(Map<Token, Host> tokenToPrimary, List<Token> ring) {
            int rf = Math.min(this.replicationFactor, ring.size());
            HashMap<Token, Set<Host>> replicaMap = new HashMap<Token, Set<Host>>(tokenToPrimary.size());
            for (int i = 0; i < ring.size(); ++i) {
                ImmutableSet.Builder builder = ImmutableSet.builder();
                for (int j = 0; j < rf; ++j) {
                    builder.add((Object)tokenToPrimary.get(ReplicationStrategy.getTokenWrapping(i + j, ring)));
                }
                replicaMap.put(ring.get(i), (Set<Host>)builder.build());
            }
            return replicaMap;
        }
    }
}

