/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.ReplicationStrategy;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.Token;
import com.google.common.collect.ImmutableSet;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Metadata {
    private static final Logger logger = LoggerFactory.getLogger(Metadata.class);
    private final Cluster.Manager cluster;
    volatile String clusterName;
    private final ConcurrentMap<InetAddress, Host> hosts = new ConcurrentHashMap<InetAddress, Host>();
    private final ConcurrentMap<String, KeyspaceMetadata> keyspaces = new ConcurrentHashMap<String, KeyspaceMetadata>();
    private volatile TokenMap tokenMap;

    Metadata(Cluster.Manager cluster) {
        this.cluster = cluster;
    }

    synchronized void rebuildSchema(String keyspace, String table, ResultSet ks, ResultSet cfs, ResultSet cols) {
        String ksName;
        HashMap<String, ArrayList<Row>> cfDefs = new HashMap<String, ArrayList<Row>>();
        HashMap colsDefs = new HashMap();
        for (Row row : cfs) {
            ksName = row.getString("keyspace_name");
            ArrayList<Row> l = (ArrayList<Row>)cfDefs.get(ksName);
            if (l == null) {
                l = new ArrayList<Row>();
                cfDefs.put(ksName, l);
            }
            l.add(row);
        }
        for (Row row : cols) {
            ArrayList<Row> l;
            ksName = row.getString("keyspace_name");
            String cfName = row.getString("columnfamily_name");
            HashMap<String, ArrayList<Row>> colsByCf = (HashMap<String, ArrayList<Row>>)colsDefs.get(ksName);
            if (colsByCf == null) {
                colsByCf = new HashMap<String, ArrayList<Row>>();
                colsDefs.put(ksName, colsByCf);
            }
            if ((l = (ArrayList<Row>)colsByCf.get(cfName)) == null) {
                l = new ArrayList<Row>();
                colsByCf.put(cfName, l);
            }
            l.add(row);
        }
        if (table == null) {
            assert (ks != null);
            HashSet<String> addedKs = new HashSet<String>();
            for (Row ksRow : ks) {
                String ksName2 = ksRow.getString("keyspace_name");
                KeyspaceMetadata ksm = KeyspaceMetadata.build(ksRow);
                if (cfDefs.containsKey(ksName2)) {
                    Metadata.buildTableMetadata(ksm, (List)cfDefs.get(ksName2), (Map)colsDefs.get(ksName2));
                }
                addedKs.add(ksName2);
                this.keyspaces.put(ksName2, ksm);
            }
            if (keyspace == null) {
                Iterator iter = this.keyspaces.keySet().iterator();
                while (iter.hasNext()) {
                    if (addedKs.contains(iter.next())) continue;
                    iter.remove();
                }
            }
        } else {
            assert (keyspace != null);
            KeyspaceMetadata ksm = (KeyspaceMetadata)this.keyspaces.get(keyspace);
            if (ksm == null) {
                logger.error(String.format("Asked to rebuild table %s.%s but I don't know keyspace %s", keyspace, table, keyspace));
                this.cluster.submitSchemaRefresh(null, null);
                return;
            }
            if (cfDefs.containsKey(keyspace)) {
                Metadata.buildTableMetadata(ksm, (List)cfDefs.get(keyspace), (Map)colsDefs.get(keyspace));
            }
        }
    }

    private static void buildTableMetadata(KeyspaceMetadata ksm, List<Row> cfRows, Map<String, List<Row>> colsDefs) {
        boolean hasColumns = colsDefs != null && !colsDefs.isEmpty();
        for (Row cfRow : cfRows) {
            String cfName = cfRow.getString("columnfamily_name");
            TableMetadata tm = TableMetadata.build(ksm, cfRow, hasColumns);
            if (!hasColumns || colsDefs.get(cfName) == null) continue;
            for (Row colRow : colsDefs.get(cfName)) {
                ColumnMetadata.build(tm, colRow);
            }
        }
    }

    synchronized void rebuildTokenMap(String partitioner, Map<Host, Collection<String>> allTokens) {
        Token.Factory factory;
        Object object = partitioner == null ? (this.tokenMap == null ? null : this.tokenMap.factory) : (factory = Token.getFactory(partitioner));
        if (factory == null) {
            return;
        }
        this.tokenMap = TokenMap.build(factory, allTokens, this.keyspaces.values());
    }

    Host add(InetAddress address) {
        Host newHost = new Host(address, this.cluster.convictionPolicyFactory);
        Host previous = this.hosts.putIfAbsent(address, newHost);
        return previous == null ? newHost : null;
    }

    boolean remove(Host host) {
        return this.hosts.remove(host.getAddress()) != null;
    }

    Host getHost(InetAddress address) {
        return (Host)this.hosts.get(address);
    }

    Collection<Host> allHosts() {
        return this.hosts.values();
    }

    public Set<Host> getReplicas(String keyspace, ByteBuffer partitionKey) {
        TokenMap current = this.tokenMap;
        if (current == null) {
            return Collections.emptySet();
        }
        Set hosts = current.getReplicas(keyspace, current.factory.hash(partitionKey));
        return hosts == null ? Collections.emptySet() : hosts;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public Set<Host> getAllHosts() {
        return new HashSet<Host>(this.allHosts());
    }

    public KeyspaceMetadata getKeyspace(String keyspace) {
        return (KeyspaceMetadata)this.keyspaces.get(keyspace);
    }

    public List<KeyspaceMetadata> getKeyspaces() {
        return new ArrayList<KeyspaceMetadata>(this.keyspaces.values());
    }

    public String exportSchemaAsString() {
        StringBuilder sb = new StringBuilder();
        for (KeyspaceMetadata ksm : this.keyspaces.values()) {
            sb.append(ksm.exportAsString()).append("\n");
        }
        return sb.toString();
    }

    static class TokenMap {
        private final Token.Factory factory;
        private final Map<String, Map<Token, Set<Host>>> tokenToHosts;
        private final List<Token> ring;

        private TokenMap(Token.Factory factory, Map<String, Map<Token, Set<Host>>> tokenToHosts, List<Token> ring) {
            this.factory = factory;
            this.tokenToHosts = tokenToHosts;
            this.ring = ring;
        }

        public static TokenMap build(Token.Factory factory, Map<Host, Collection<String>> allTokens, Collection<KeyspaceMetadata> keyspaces) {
            HashMap<Token, Host> tokenToPrimary = new HashMap<Token, Host>();
            TreeSet<Token> allSorted = new TreeSet<Token>();
            for (Map.Entry<Host, Collection<String>> entry : allTokens.entrySet()) {
                Host host = entry.getKey();
                for (String tokenStr : entry.getValue()) {
                    try {
                        Token t = factory.fromString(tokenStr);
                        allSorted.add(t);
                        tokenToPrimary.put(t, host);
                    }
                    catch (IllegalArgumentException e) {}
                }
            }
            ArrayList<Token> ring = new ArrayList<Token>(allSorted);
            HashMap<String, Map<Token, Set<Host>>> tokenToHosts = new HashMap<String, Map<Token, Set<Host>>>();
            for (KeyspaceMetadata keyspace : keyspaces) {
                ReplicationStrategy strategy = keyspace.replicationStrategy();
                if (strategy == null) {
                    tokenToHosts.put(keyspace.getName(), TokenMap.makeNonReplicatedMap(tokenToPrimary));
                    continue;
                }
                tokenToHosts.put(keyspace.getName(), strategy.computeTokenToReplicaMap(tokenToPrimary, ring));
            }
            return new TokenMap(factory, tokenToHosts, ring);
        }

        private Set<Host> getReplicas(String keyspace, Token token) {
            Map<Token, Set<Host>> keyspaceHosts = this.tokenToHosts.get(keyspace);
            if (keyspaceHosts == null) {
                return Collections.emptySet();
            }
            int i = Collections.binarySearch(this.ring, token);
            if (i < 0 && (i = -i - 1) >= this.ring.size()) {
                i = 0;
            }
            return keyspaceHosts.get(this.ring.get(i));
        }

        private static Map<Token, Set<Host>> makeNonReplicatedMap(Map<Token, Host> input) {
            HashMap<Token, Set<Host>> output = new HashMap<Token, Set<Host>>(input.size());
            for (Map.Entry<Token, Host> entry : input.entrySet()) {
                output.put(entry.getKey(), (Set<Host>)ImmutableSet.of((Object)entry.getValue()));
            }
            return output;
        }
    }
}

