/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.policies.RetryPolicy;
import java.nio.ByteBuffer;

public abstract class Query {
    static final Query DEFAULT = new Query(){

        @Override
        public ByteBuffer getRoutingKey() {
            return null;
        }
    };
    private volatile ConsistencyLevel consistency = ConsistencyLevel.ONE;
    private volatile boolean traceQuery;
    private volatile RetryPolicy retryPolicy;

    Query() {
    }

    public Query setConsistencyLevel(ConsistencyLevel consistency) {
        this.consistency = consistency;
        return this;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.consistency;
    }

    public Query enableTracing() {
        this.traceQuery = true;
        return this;
    }

    public Query disableTracing() {
        this.traceQuery = false;
        return this;
    }

    public boolean isTracing() {
        return this.traceQuery;
    }

    public abstract ByteBuffer getRoutingKey();

    public Query setRetryPolicy(RetryPolicy policy) {
        this.retryPolicy = policy;
        return this;
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }
}

