/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.BusyConnectionException;
import com.datastax.driver.core.Connection;
import com.datastax.driver.core.ConnectionException;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostConnectionPool;
import com.datastax.driver.core.Metrics;
import com.datastax.driver.core.PooledConnection;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Query;
import com.datastax.driver.core.SessionManager;
import com.datastax.driver.core.WriteType;
import com.datastax.driver.core.exceptions.DriverInternalError;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.policies.RetryPolicy;
import com.yammer.metrics.core.TimerContext;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.cassandra.exceptions.PreparedQueryNotFoundException;
import org.apache.cassandra.exceptions.ReadTimeoutException;
import org.apache.cassandra.exceptions.UnavailableException;
import org.apache.cassandra.exceptions.WriteTimeoutException;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.messages.ErrorMessage;
import org.apache.cassandra.transport.messages.ExecuteMessage;
import org.apache.cassandra.transport.messages.PrepareMessage;
import org.apache.cassandra.transport.messages.QueryMessage;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RequestHandler
implements Connection.ResponseCallback {
    private static final Logger logger = LoggerFactory.getLogger(RequestHandler.class);
    private final SessionManager manager;
    private final Callback callback;
    private final Iterator<Host> queryPlan;
    private final Query query;
    private volatile Host current;
    private volatile List<Host> triedHosts;
    private volatile HostConnectionPool currentPool;
    private volatile int queryRetries;
    private volatile ConsistencyLevel retryConsistencyLevel;
    private volatile Map<InetAddress, String> errors;
    private volatile boolean isCanceled;
    private volatile Connection.ResponseHandler connectionHandler;
    private final TimerContext timerContext;
    private final long startTime;

    public RequestHandler(SessionManager manager, Callback callback, Query query) {
        this.manager = manager;
        this.callback = callback;
        callback.register(this);
        this.queryPlan = manager.loadBalancingPolicy().newQueryPlan(query);
        this.query = query;
        this.timerContext = this.metricsEnabled() ? this.metrics().getRequestsTimer().time() : null;
        this.startTime = System.nanoTime();
    }

    private boolean metricsEnabled() {
        return this.manager.configuration().getMetricsOptions() != null;
    }

    private Metrics metrics() {
        return this.manager.cluster.manager.metrics;
    }

    public void sendRequest() {
        try {
            while (this.queryPlan.hasNext() && !this.isCanceled) {
                Host host = this.queryPlan.next();
                logger.trace("Querying node {}", (Object)host);
                if (!this.query(host)) continue;
                return;
            }
            this.setFinalException(null, new NoHostAvailableException(this.errors == null ? Collections.emptyMap() : this.errors));
        }
        catch (Exception e) {
            this.setFinalException(null, new DriverInternalError("An unexpected error happened while sending requests", e));
        }
    }

    private boolean query(Host host) {
        this.currentPool = (HostConnectionPool)this.manager.pools.get(host);
        if (this.currentPool == null || this.currentPool.isShutdown()) {
            return false;
        }
        PooledConnection connection = null;
        try {
            connection = this.currentPool.borrowConnection(this.manager.configuration().getSocketOptions().getConnectTimeoutMillis(), TimeUnit.MILLISECONDS);
            if (this.current != null) {
                if (this.triedHosts == null) {
                    this.triedHosts = new ArrayList<Host>();
                }
                this.triedHosts.add(this.current);
            }
            this.current = host;
            this.connectionHandler = connection.write(this);
            return true;
        }
        catch (ConnectionException e) {
            if (this.metricsEnabled()) {
                this.metrics().getErrorMetrics().getConnectionErrors().inc();
            }
            if (connection != null) {
                connection.release();
            }
            this.logError(host.getAddress(), e.getMessage());
            return false;
        }
        catch (BusyConnectionException e) {
            if (connection != null) {
                connection.release();
            }
            this.logError(host.getAddress(), e.getMessage());
            return false;
        }
        catch (TimeoutException e) {
            this.logError(host.getAddress(), "Timeout while trying to acquire available connection (you may want to increase the driver number of per-host connections)");
            return false;
        }
        catch (RuntimeException e) {
            if (connection != null) {
                connection.release();
            }
            logger.error("Unexpected error while querying " + host.getAddress(), (Throwable)e);
            this.logError(host.getAddress(), e.getMessage());
            return false;
        }
    }

    private void logError(InetAddress address, String msg) {
        logger.debug("Error querying {}, trying next host (error is: {})", (Object)address, (Object)msg);
        if (this.errors == null) {
            this.errors = new HashMap<InetAddress, String>();
        }
        this.errors.put(address, msg);
    }

    private void retry(final boolean retryCurrent, ConsistencyLevel newConsistencyLevel) {
        final Host h = this.current;
        this.retryConsistencyLevel = newConsistencyLevel;
        this.manager.executor().execute(new Runnable(){

            @Override
            public void run() {
                if (retryCurrent && RequestHandler.this.query(h)) {
                    return;
                }
                RequestHandler.this.sendRequest();
            }
        });
    }

    public void cancel() {
        this.isCanceled = true;
        if (this.connectionHandler != null) {
            this.connectionHandler.cancelHandler();
        }
    }

    @Override
    public Message.Request request() {
        Message.Request request = this.callback.request();
        if (this.retryConsistencyLevel != null) {
            org.apache.cassandra.db.ConsistencyLevel cl = ConsistencyLevel.toCassandraCL(this.retryConsistencyLevel);
            if (request instanceof QueryMessage) {
                QueryMessage qm = (QueryMessage)request;
                if (qm.consistency != cl) {
                    request = new QueryMessage(qm.query, cl);
                }
            } else if (request instanceof ExecuteMessage) {
                ExecuteMessage em = (ExecuteMessage)request;
                if (em.consistency != cl) {
                    request = new ExecuteMessage(em.statementId, em.values, cl);
                }
            }
        }
        return request;
    }

    private void setFinalResult(Connection connection, Message.Response response) {
        if (this.timerContext != null) {
            this.timerContext.stop();
        }
        ExecutionInfo info = this.current.defaultExecutionInfo;
        if (this.triedHosts != null) {
            this.triedHosts.add(this.current);
            info = new ExecutionInfo(this.triedHosts);
        }
        if (this.retryConsistencyLevel != null) {
            info = info.withAchievedConsistency(this.retryConsistencyLevel);
        }
        this.callback.onSet(connection, response, info, System.nanoTime() - this.startTime);
    }

    private void setFinalException(Connection connection, Exception exception) {
        if (this.timerContext != null) {
            this.timerContext.stop();
        }
        this.callback.onException(connection, exception, System.nanoTime() - this.startTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onSet(Connection connection, Message.Response response, long latency) {
        if (connection instanceof PooledConnection) {
            ((PooledConnection)connection).release();
        }
        Host queriedHost = this.current;
        try {
            switch (response.type) {
                case RESULT: {
                    this.setFinalResult(connection, response);
                    return;
                }
                case ERROR: {
                    ErrorMessage err = (ErrorMessage)response;
                    RetryPolicy.RetryDecision retry = null;
                    RetryPolicy retryPolicy = this.query.getRetryPolicy() == null ? this.manager.configuration().getPolicies().getRetryPolicy() : this.query.getRetryPolicy();
                    switch (err.error.code()) {
                        case READ_TIMEOUT: {
                            assert (err.error instanceof ReadTimeoutException);
                            if (this.metricsEnabled()) {
                                this.metrics().getErrorMetrics().getReadTimeouts().inc();
                            }
                            ReadTimeoutException rte = (ReadTimeoutException)err.error;
                            ConsistencyLevel rcl = ConsistencyLevel.from(rte.consistency);
                            retry = retryPolicy.onReadTimeout(this.query, rcl, rte.blockFor, rte.received, rte.dataPresent, this.queryRetries);
                            break;
                        }
                        case WRITE_TIMEOUT: {
                            assert (err.error instanceof WriteTimeoutException);
                            if (this.metricsEnabled()) {
                                this.metrics().getErrorMetrics().getWriteTimeouts().inc();
                            }
                            WriteTimeoutException wte = (WriteTimeoutException)err.error;
                            ConsistencyLevel wcl = ConsistencyLevel.from(wte.consistency);
                            retry = retryPolicy.onWriteTimeout(this.query, wcl, WriteType.from(wte.writeType), wte.blockFor, wte.received, this.queryRetries);
                            break;
                        }
                        case UNAVAILABLE: {
                            assert (err.error instanceof UnavailableException);
                            if (this.metricsEnabled()) {
                                this.metrics().getErrorMetrics().getUnavailables().inc();
                            }
                            UnavailableException ue = (UnavailableException)err.error;
                            ConsistencyLevel ucl = ConsistencyLevel.from(ue.consistency);
                            retry = retryPolicy.onUnavailable(this.query, ucl, ue.required, ue.alive, this.queryRetries);
                            break;
                        }
                        case OVERLOADED: {
                            logger.warn("Host {} is overloaded, trying next host.", (Object)connection.address);
                            this.logError(connection.address, "Host overloaded");
                            if (this.metricsEnabled()) {
                                this.metrics().getErrorMetrics().getOthers().inc();
                            }
                            this.retry(false, null);
                            return;
                        }
                        case IS_BOOTSTRAPPING: {
                            logger.error("Query sent to {} but it is bootstrapping. This shouldn't happen but trying next host.", (Object)connection.address);
                            this.logError(connection.address, "Host is boostrapping");
                            if (this.metricsEnabled()) {
                                this.metrics().getErrorMetrics().getOthers().inc();
                            }
                            this.retry(false, null);
                            return;
                        }
                        case UNPREPARED: {
                            assert (err.error instanceof PreparedQueryNotFoundException);
                            PreparedQueryNotFoundException pqnf = (PreparedQueryNotFoundException)err.error;
                            PreparedStatement toPrepare = (PreparedStatement)this.manager.cluster.manager.preparedQueries.get(pqnf.id);
                            if (toPrepare == null) {
                                String msg = String.format("Tried to execute unknown prepared query %s", pqnf.id);
                                logger.error(msg);
                                this.setFinalException(connection, new DriverInternalError(msg));
                                return;
                            }
                            logger.info("Query {} is not prepared on {}, preparing before retrying executing. Seeing this message a few times is fine, but seeing it a lot may be source of performance problems", (Object)toPrepare.getQueryString(), (Object)connection.address);
                            String currentKeyspace = connection.keyspace();
                            String prepareKeyspace = toPrepare.getQueryKeyspace();
                            if (!(prepareKeyspace == null || currentKeyspace != null && currentKeyspace.equals(prepareKeyspace))) {
                                logger.trace("Setting keyspace for prepared query to {}", (Object)prepareKeyspace);
                                connection.setKeyspace(prepareKeyspace);
                            }
                            try {
                                connection.write(this.prepareAndRetry(toPrepare.getQueryString()));
                                return;
                            }
                            finally {
                                if (connection.keyspace() == null || !connection.keyspace().equals(currentKeyspace)) {
                                    logger.trace("Setting back keyspace post query preparation to {}", (Object)currentKeyspace);
                                    connection.setKeyspace(currentKeyspace);
                                }
                            }
                        }
                        default: {
                            if (!this.metricsEnabled()) break;
                            this.metrics().getErrorMetrics().getOthers().inc();
                        }
                    }
                    if (retry == null) {
                        this.setFinalResult(connection, response);
                        return;
                    } else {
                        switch (retry.getType()) {
                            case RETRY: {
                                ++this.queryRetries;
                                if (logger.isTraceEnabled()) {
                                    logger.trace("Doing retry {} for query {} at consistency {}", new Object[]{this.queryRetries, this.query, retry.getRetryConsistencyLevel()});
                                }
                                if (this.metricsEnabled()) {
                                    this.metrics().getErrorMetrics().getRetries().inc();
                                }
                                this.retry(true, retry.getRetryConsistencyLevel());
                                return;
                            }
                            case RETHROW: {
                                this.setFinalResult(connection, response);
                                return;
                            }
                            case IGNORE: {
                                if (this.metricsEnabled()) {
                                    this.metrics().getErrorMetrics().getIgnores().inc();
                                }
                                this.setFinalResult(connection, (Message.Response)new ResultMessage.Void());
                            }
                        }
                    }
                    return;
                }
                default: {
                    this.setFinalResult(connection, response);
                    return;
                }
            }
        }
        catch (Exception e) {
            this.setFinalException(connection, e);
            return;
        }
        finally {
            if (queriedHost != null) {
                this.manager.cluster.manager.reportLatency(queriedHost, latency);
            }
        }
    }

    private Connection.ResponseCallback prepareAndRetry(final String toPrepare) {
        return new Connection.ResponseCallback(){

            @Override
            public Message.Request request() {
                return new PrepareMessage(toPrepare);
            }

            @Override
            public void onSet(Connection connection, Message.Response response, long latency) {
                switch (response.type) {
                    case RESULT: {
                        if (((ResultMessage)response).kind == ResultMessage.Kind.PREPARED) {
                            logger.trace("Scheduling retry now that query is prepared");
                            RequestHandler.this.retry(true, null);
                            break;
                        }
                        RequestHandler.this.logError(connection.address, "Got unexpected response to prepare message: " + response);
                        RequestHandler.this.retry(false, null);
                        break;
                    }
                    case ERROR: {
                        RequestHandler.this.logError(connection.address, "Error preparing query, got " + response);
                        if (RequestHandler.this.metricsEnabled()) {
                            RequestHandler.this.metrics().getErrorMetrics().getOthers().inc();
                        }
                        RequestHandler.this.retry(false, null);
                        break;
                    }
                    default: {
                        RequestHandler.this.setFinalResult(connection, response);
                    }
                }
            }

            @Override
            public void onException(Connection connection, Exception exception, long latency) {
                RequestHandler.this.onException(connection, exception, latency);
            }

            @Override
            public void onTimeout(Connection connection, long latency) {
                RequestHandler.this.logError(connection.address, "Timeout waiting for response to prepare message");
                RequestHandler.this.retry(false, null);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onException(Connection connection, Exception exception, long latency) {
        if (connection instanceof PooledConnection) {
            ((PooledConnection)connection).release();
        }
        Host queriedHost = this.current;
        try {
            if (exception instanceof ConnectionException) {
                if (this.metricsEnabled()) {
                    this.metrics().getErrorMetrics().getConnectionErrors().inc();
                }
                ConnectionException ce = (ConnectionException)exception;
                this.logError(ce.address, ce.getMessage());
                this.retry(false, null);
                return;
            }
            this.setFinalException(connection, exception);
        }
        finally {
            if (queriedHost != null) {
                this.manager.cluster.manager.reportLatency(queriedHost, latency);
            }
        }
    }

    @Override
    public void onTimeout(Connection connection, long latency) {
        if (connection instanceof PooledConnection) {
            ((PooledConnection)connection).release();
        }
        Host queriedHost = this.current;
        this.logError(connection.address, "Timeout during read");
        this.retry(false, null);
        if (queriedHost != null) {
            this.manager.cluster.manager.reportLatency(queriedHost, latency);
        }
    }

    static interface Callback
    extends Connection.ResponseCallback {
        public void onSet(Connection var1, Message.Response var2, ExecutionInfo var3, long var4);

        public void register(RequestHandler var1);
    }
}

