/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.cassandra.transport.messages.ResultMessage;
import com.datastax.driver.core.ArrayBackedRow;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.QueryTrace;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.SessionManager;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ArrayBackedResultSet
implements ResultSet {
    private static final Logger logger = LoggerFactory.getLogger(ResultSet.class);
    private static final Queue<List<ByteBuffer>> EMPTY_QUEUE = new ArrayDeque<List<ByteBuffer>>(0);
    private final ColumnDefinitions metadata;
    private final Queue<List<ByteBuffer>> rows;
    private final ExecutionInfo info;

    private ArrayBackedResultSet(ColumnDefinitions metadata, Queue<List<ByteBuffer>> rows, ExecutionInfo info) {
        this.metadata = metadata;
        this.rows = rows;
        this.info = info;
    }

    static ResultSet fromMessage(ResultMessage msg, SessionManager session, ExecutionInfo info) {
        UUID tracingId = msg.getTracingId();
        info = tracingId == null || info == null ? info : info.withTrace(new QueryTrace(tracingId, session));
        switch (msg.kind) {
            case VOID: {
                return ArrayBackedResultSet.empty(info);
            }
            case ROWS: {
                ResultMessage.Rows r = (ResultMessage.Rows)msg;
                ColumnDefinitions.Definition[] defs = new ColumnDefinitions.Definition[r.result.metadata.names.size()];
                for (int i = 0; i < defs.length; ++i) {
                    defs[i] = ColumnDefinitions.Definition.fromTransportSpecification((ColumnSpecification)r.result.metadata.names.get(i));
                }
                return new ArrayBackedResultSet(new ColumnDefinitions(defs), new ArrayDeque<List<ByteBuffer>>(r.result.rows), info);
            }
            case SET_KEYSPACE: 
            case SCHEMA_CHANGE: {
                return ArrayBackedResultSet.empty(info);
            }
            case PREPARED: {
                throw new RuntimeException("Prepared statement received when a ResultSet was expected");
            }
        }
        logger.error("Received unknow result type '{}'; returning empty result set", (Object)msg.kind);
        return ArrayBackedResultSet.empty(info);
    }

    private static ResultSet empty(ExecutionInfo info) {
        return new ArrayBackedResultSet(ColumnDefinitions.EMPTY, EMPTY_QUEUE, info);
    }

    @Override
    public ColumnDefinitions getColumnDefinitions() {
        return this.metadata;
    }

    @Override
    public boolean isExhausted() {
        return this.rows.isEmpty();
    }

    @Override
    public Row one() {
        return ArrayBackedRow.fromData(this.metadata, this.rows.poll());
    }

    @Override
    public List<Row> all() {
        if (this.isExhausted()) {
            return Collections.emptyList();
        }
        ArrayList<Row> result = new ArrayList<Row>(this.rows.size());
        for (Row row : this) {
            result.add(row);
        }
        return result;
    }

    @Override
    public Iterator<Row> iterator() {
        return new Iterator<Row>(){

            @Override
            public boolean hasNext() {
                return !ArrayBackedResultSet.this.rows.isEmpty();
            }

            @Override
            public Row next() {
                return ArrayBackedRow.fromData(ArrayBackedResultSet.this.metadata, (List)ArrayBackedResultSet.this.rows.poll());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public ExecutionInfo getExecutionInfo() {
        return this.info;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ResultSet[ exhausted: ").append(this.isExhausted());
        sb.append(", ").append(this.metadata).append("]");
        return sb.toString();
    }
}

