/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.cassandra.transport.messages;

import com.datastax.cassandra.transport.Message;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.transport.CBUtil;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

public class QueryMessage
extends Message.Request {
    public static final Message.Codec<QueryMessage> codec = new Message.Codec<QueryMessage>(){

        public QueryMessage decode(ChannelBuffer body) {
            String query = CBUtil.readLongString((ChannelBuffer)body);
            ConsistencyLevel consistency = CBUtil.readConsistencyLevel((ChannelBuffer)body);
            return new QueryMessage(query, consistency);
        }

        public ChannelBuffer encode(QueryMessage msg) {
            return ChannelBuffers.wrappedBuffer((ChannelBuffer[])new ChannelBuffer[]{CBUtil.longStringToCB((String)msg.query), CBUtil.consistencyLevelToCB((ConsistencyLevel)msg.consistency)});
        }
    };
    public final String query;
    public final ConsistencyLevel consistency;

    public QueryMessage(String query, ConsistencyLevel consistency) {
        super(Message.Type.QUERY);
        this.query = query;
        this.consistency = consistency;
    }

    @Override
    public ChannelBuffer encode() {
        return codec.encode(this);
    }

    public String toString() {
        return "QUERY " + this.query;
    }
}

