/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Codec;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.BooleanType;
import org.apache.cassandra.db.marshal.DateType;
import org.apache.cassandra.db.marshal.DecimalType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.FloatType;
import org.apache.cassandra.db.marshal.InetAddressType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.IntegerType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UUIDType;

public class Row {
    private final ColumnDefinitions metadata;
    private final List<ByteBuffer> data;

    private Row(ColumnDefinitions metadata, List<ByteBuffer> data) {
        this.metadata = metadata;
        this.data = data;
    }

    static Row fromData(ColumnDefinitions metadata, List<ByteBuffer> data) {
        if (data == null) {
            return null;
        }
        return new Row(metadata, data);
    }

    public ColumnDefinitions getColumnDefinitions() {
        return this.metadata;
    }

    public boolean isNull(int i) {
        this.metadata.checkBounds(i);
        return this.data.get(i) == null;
    }

    public boolean isNull(String name) {
        return this.isNull(this.metadata.getIdx(name));
    }

    public boolean getBool(int i) {
        this.metadata.checkType(i, DataType.Name.BOOLEAN);
        ByteBuffer value = this.data.get(i);
        if (value == null || value.remaining() == 0) {
            return false;
        }
        return BooleanType.instance.compose(value);
    }

    public boolean getBool(String name) {
        return this.getBool(this.metadata.getIdx(name));
    }

    public int getInt(int i) {
        this.metadata.checkType(i, DataType.Name.INT);
        ByteBuffer value = this.data.get(i);
        if (value == null || value.remaining() == 0) {
            return 0;
        }
        return Int32Type.instance.compose(value);
    }

    public int getInt(String name) {
        return this.getInt(this.metadata.getIdx(name));
    }

    public long getLong(int i) {
        this.metadata.checkType(i, DataType.Name.BIGINT, DataType.Name.COUNTER);
        ByteBuffer value = this.data.get(i);
        if (value == null || value.remaining() == 0) {
            return 0L;
        }
        return LongType.instance.compose(value);
    }

    public long getLong(String name) {
        return this.getLong(this.metadata.getIdx(name));
    }

    public Date getDate(int i) {
        this.metadata.checkType(i, DataType.Name.TIMESTAMP);
        ByteBuffer value = this.data.get(i);
        if (value == null || value.remaining() == 0) {
            return null;
        }
        return DateType.instance.compose(value);
    }

    public Date getDate(String name) {
        return this.getDate(this.metadata.getIdx(name));
    }

    public float getFloat(int i) {
        this.metadata.checkType(i, DataType.Name.FLOAT);
        ByteBuffer value = this.data.get(i);
        if (value == null || value.remaining() == 0) {
            return 0.0f;
        }
        return FloatType.instance.compose(value).floatValue();
    }

    public float getFloat(String name) {
        return this.getFloat(this.metadata.getIdx(name));
    }

    public double getDouble(int i) {
        this.metadata.checkType(i, DataType.Name.DOUBLE);
        ByteBuffer value = this.data.get(i);
        if (value == null || value.remaining() == 0) {
            return 0.0;
        }
        return DoubleType.instance.compose(value);
    }

    public double getDouble(String name) {
        return this.getDouble(this.metadata.getIdx(name));
    }

    public ByteBuffer getBytesUnsafe(int i) {
        this.metadata.checkBounds(i);
        ByteBuffer value = this.data.get(i);
        if (value == null) {
            return null;
        }
        return value.duplicate();
    }

    public ByteBuffer getBytesUnsafe(String name) {
        return this.getBytesUnsafe(this.metadata.getIdx(name));
    }

    public ByteBuffer getBytes(int i) {
        this.metadata.checkType(i, DataType.Name.BLOB);
        return this.getBytesUnsafe(i);
    }

    public ByteBuffer getBytes(String name) {
        return this.getBytes(this.metadata.getIdx(name));
    }

    public String getString(int i) {
        DataType.Name type = this.metadata.checkType(i, DataType.Name.VARCHAR, DataType.Name.TEXT, DataType.Name.ASCII);
        ByteBuffer value = this.data.get(i);
        if (value == null) {
            return null;
        }
        return type == DataType.Name.ASCII ? AsciiType.instance.compose(value) : UTF8Type.instance.compose(value);
    }

    public String getString(String name) {
        return this.getString(this.metadata.getIdx(name));
    }

    public BigInteger getVarint(int i) {
        this.metadata.checkType(i, DataType.Name.VARINT);
        ByteBuffer value = this.data.get(i);
        if (value == null || value.remaining() == 0) {
            return null;
        }
        return IntegerType.instance.compose(value);
    }

    public BigInteger getVarint(String name) {
        return this.getVarint(this.metadata.getIdx(name));
    }

    public BigDecimal getDecimal(int i) {
        this.metadata.checkType(i, DataType.Name.DECIMAL);
        ByteBuffer value = this.data.get(i);
        if (value == null || value.remaining() == 0) {
            return null;
        }
        return DecimalType.instance.compose(value);
    }

    public BigDecimal getDecimal(String name) {
        return this.getDecimal(this.metadata.getIdx(name));
    }

    public UUID getUUID(int i) {
        DataType.Name type = this.metadata.checkType(i, DataType.Name.UUID, DataType.Name.TIMEUUID);
        ByteBuffer value = this.data.get(i);
        if (value == null || value.remaining() == 0) {
            return null;
        }
        return type == DataType.Name.UUID ? UUIDType.instance.compose(value) : TimeUUIDType.instance.compose(value);
    }

    public UUID getUUID(String name) {
        return this.getUUID(this.metadata.getIdx(name));
    }

    public InetAddress getInet(int i) {
        this.metadata.checkType(i, DataType.Name.INET);
        ByteBuffer value = this.data.get(i);
        if (value == null || value.remaining() == 0) {
            return null;
        }
        return InetAddressType.instance.compose(value);
    }

    public InetAddress getInet(String name) {
        return this.getInet(this.metadata.getIdx(name));
    }

    public <T> List<T> getList(int i, Class<T> elementsClass) {
        DataType type = this.metadata.getType(i);
        if (type.getName() != DataType.Name.LIST) {
            throw new InvalidTypeException(String.format("Column %s is not of list type", this.metadata.getName(i)));
        }
        Class<?> expectedClass = type.getTypeArguments().get((int)0).getName().javaType;
        if (!elementsClass.isAssignableFrom(expectedClass)) {
            throw new InvalidTypeException(String.format("Column %s is a list of %s (CQL type %s), cannot be retrieve as a list of %s", this.metadata.getName(i), expectedClass, type, elementsClass));
        }
        ByteBuffer value = this.data.get(i);
        if (value == null) {
            return Collections.emptyList();
        }
        return (List)Codec.getCodec(type).compose(value);
    }

    public <T> List<T> getList(String name, Class<T> elementsClass) {
        return this.getList(this.metadata.getIdx(name), elementsClass);
    }

    public <T> Set<T> getSet(int i, Class<T> elementsClass) {
        DataType type = this.metadata.getType(i);
        if (type.getName() != DataType.Name.SET) {
            throw new InvalidTypeException(String.format("Column %s is not of set type", this.metadata.getName(i)));
        }
        Class<?> expectedClass = type.getTypeArguments().get((int)0).getName().javaType;
        if (!elementsClass.isAssignableFrom(expectedClass)) {
            throw new InvalidTypeException(String.format("Column %s is a set of %s (CQL type %s), cannot be retrieve as a set of %s", this.metadata.getName(i), expectedClass, type, elementsClass));
        }
        ByteBuffer value = this.data.get(i);
        if (value == null) {
            return Collections.emptySet();
        }
        return (Set)Codec.getCodec(type).compose(value);
    }

    public <T> Set<T> getSet(String name, Class<T> elementsClass) {
        return this.getSet(this.metadata.getIdx(name), elementsClass);
    }

    public <K, V> Map<K, V> getMap(int i, Class<K> keysClass, Class<V> valuesClass) {
        DataType type = this.metadata.getType(i);
        if (type.getName() != DataType.Name.MAP) {
            throw new InvalidTypeException(String.format("Column %s is not of map type", this.metadata.getName(i)));
        }
        Class<?> expectedKeysClass = type.getTypeArguments().get((int)0).getName().javaType;
        Class<?> expectedValuesClass = type.getTypeArguments().get((int)1).getName().javaType;
        if (!keysClass.isAssignableFrom(expectedKeysClass) || !valuesClass.isAssignableFrom(expectedValuesClass)) {
            throw new InvalidTypeException(String.format("Column %s is a map of %s->%s (CQL type %s), cannot be retrieve as a map of %s->%s", this.metadata.getName(i), expectedKeysClass, expectedValuesClass, type, keysClass, valuesClass));
        }
        ByteBuffer value = this.data.get(i);
        if (value == null) {
            return Collections.emptyMap();
        }
        return (Map)Codec.getCodec(type).compose(value);
    }

    public <K, V> Map<K, V> getMap(String name, Class<K> keysClass, Class<V> valuesClass) {
        return this.getMap(this.metadata.getIdx(name), keysClass, valuesClass);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Row[");
        for (int i = 0; i < this.metadata.size(); ++i) {
            ByteBuffer bb;
            if (i != 0) {
                sb.append(", ");
            }
            if ((bb = this.data.get(i)) == null) {
                sb.append("NULL");
                continue;
            }
            sb.append(Codec.getCodec(this.metadata.getType(i)).getString(bb));
        }
        sb.append("]");
        return sb.toString();
    }
}

