/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.querybuilder;

import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.querybuilder.Utils;
import java.nio.ByteBuffer;
import java.util.List;

abstract class BuiltStatement
extends Statement {
    private final List<ColumnMetadata> partitionKey;
    private final ByteBuffer[] routingKey;
    private boolean dirty;
    private String cache;

    protected BuiltStatement() {
        this.partitionKey = null;
        this.routingKey = null;
    }

    protected BuiltStatement(TableMetadata tableMetadata) {
        this.partitionKey = tableMetadata.getPartitionKey();
        this.routingKey = new ByteBuffer[tableMetadata.getPartitionKey().size()];
    }

    @Override
    public String getQueryString() {
        if (this.dirty || this.cache == null) {
            this.cache = this.buildQueryString().trim();
            if (!this.cache.endsWith(";")) {
                this.cache = this.cache + ";";
            }
        }
        return this.cache;
    }

    protected abstract String buildQueryString();

    protected void setDirty() {
        this.dirty = true;
    }

    void maybeAddRoutingKey(String name, Object value) {
        if (this.routingKey == null || name == null) {
            return;
        }
        for (int i = 0; i < this.partitionKey.size(); ++i) {
            if (!name.equals(this.partitionKey.get(i).getName())) continue;
            this.routingKey[i] = this.partitionKey.get(i).getType().parse(Utils.toRawString(value));
            return;
        }
    }

    @Override
    public ByteBuffer getRoutingKey() {
        if (this.routingKey == null) {
            return null;
        }
        for (ByteBuffer bb : this.routingKey) {
            if (bb != null) continue;
            return null;
        }
        return this.routingKey.length == 1 ? this.routingKey[0] : BuiltStatement.compose(this.routingKey);
    }

    static ByteBuffer compose(ByteBuffer ... buffers) {
        int totalLength = 0;
        for (ByteBuffer bb : buffers) {
            totalLength += 2 + bb.remaining() + 1;
        }
        ByteBuffer out = ByteBuffer.allocate(totalLength);
        for (ByteBuffer bb : buffers) {
            BuiltStatement.putShortLength(out, bb.remaining());
            out.put(bb);
            out.put((byte)0);
        }
        out.flip();
        return out;
    }

    private static void putShortLength(ByteBuffer bb, int length) {
        bb.put((byte)(length >> 8 & 0xFF));
        bb.put((byte)(length & 0xFF));
    }

    static abstract class ForwardingStatement<T extends BuiltStatement>
    extends BuiltStatement {
        protected T statement;

        protected ForwardingStatement(T statement) {
            this.statement = statement;
        }

        @Override
        public String getQueryString() {
            return ((BuiltStatement)this.statement).getQueryString();
        }

        @Override
        protected String buildQueryString() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteBuffer getRoutingKey() {
            return ((BuiltStatement)this.statement).getRoutingKey();
        }

        @Override
        protected void setDirty() {
            ((BuiltStatement)this.statement).setDirty();
        }
    }
}

