/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.policies;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Query;
import com.datastax.driver.core.WriteType;

public interface RetryPolicy {
    public RetryDecision onReadTimeout(Query var1, ConsistencyLevel var2, int var3, int var4, boolean var5, int var6);

    public RetryDecision onWriteTimeout(Query var1, ConsistencyLevel var2, WriteType var3, int var4, int var5, int var6);

    public RetryDecision onUnavailable(Query var1, ConsistencyLevel var2, int var3, int var4, int var5);

    public static class RetryDecision {
        private final Type type;
        private final ConsistencyLevel retryCL;

        private RetryDecision(Type type, ConsistencyLevel retryCL) {
            this.type = type;
            this.retryCL = retryCL;
        }

        public Type getType() {
            return this.type;
        }

        public ConsistencyLevel getRetryConsistencyLevel() {
            return this.retryCL;
        }

        public static RetryDecision rethrow() {
            return new RetryDecision(Type.RETHROW, null);
        }

        public static RetryDecision retry(ConsistencyLevel consistency) {
            return new RetryDecision(Type.RETRY, consistency);
        }

        public static RetryDecision ignore() {
            return new RetryDecision(Type.IGNORE, null);
        }

        public static enum Type {
            RETRY,
            RETHROW,
            IGNORE;

        }
    }
}

