/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.BusyConnectionException;
import com.datastax.driver.core.Connection;
import com.datastax.driver.core.ConnectionException;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostConnectionPool;
import com.datastax.driver.core.Metrics;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Query;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.WriteType;
import com.datastax.driver.core.exceptions.DriverInternalError;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.policies.RetryPolicy;
import com.yammer.metrics.core.TimerContext;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.cassandra.exceptions.PreparedQueryNotFoundException;
import org.apache.cassandra.exceptions.ReadTimeoutException;
import org.apache.cassandra.exceptions.UnavailableException;
import org.apache.cassandra.exceptions.WriteTimeoutException;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.messages.ErrorMessage;
import org.apache.cassandra.transport.messages.ExecuteMessage;
import org.apache.cassandra.transport.messages.PrepareMessage;
import org.apache.cassandra.transport.messages.QueryMessage;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RetryingCallback
implements Connection.ResponseCallback {
    private static final Logger logger = LoggerFactory.getLogger(RetryingCallback.class);
    private final Session.Manager manager;
    private final Connection.ResponseCallback callback;
    private final TimerContext timerContext;
    private final Iterator<Host> queryPlan;
    private final Query query;
    private volatile Host current;
    private volatile HostConnectionPool currentPool;
    private volatile int queryRetries;
    private volatile ConsistencyLevel retryConsistencyLevel;
    private volatile Map<InetAddress, String> errors;

    public RetryingCallback(Session.Manager manager, Connection.ResponseCallback callback, Query query) {
        this.manager = manager;
        this.callback = callback;
        this.queryPlan = manager.loadBalancer.newQueryPlan(query);
        this.query = query;
        this.timerContext = manager.configuration().isMetricsEnabled() ? this.metrics().getRequestsTimer().time() : null;
    }

    private Metrics metrics() {
        return this.manager.cluster.manager.metrics;
    }

    public void sendRequest() {
        while (this.queryPlan.hasNext()) {
            Host host = this.queryPlan.next();
            if (!this.query(host)) continue;
            return;
        }
        this.setFinalException(null, new NoHostAvailableException(this.errors == null ? Collections.emptyMap() : this.errors));
    }

    private boolean query(Host host) {
        this.currentPool = (HostConnectionPool)this.manager.pools.get(host);
        if (this.currentPool == null || this.currentPool.isShutdown()) {
            return false;
        }
        Connection connection = null;
        try {
            connection = this.currentPool.borrowConnection(this.manager.configuration().getSocketOptions().getConnectTimeoutMillis(), TimeUnit.MILLISECONDS);
            this.current = host;
            connection.write(this);
            return true;
        }
        catch (ConnectionException e) {
            if (this.manager.configuration().isMetricsEnabled()) {
                this.metrics().getErrorMetrics().getConnectionErrors().inc();
            }
            if (connection != null) {
                this.currentPool.returnConnection(connection);
            }
            this.logError(host.getAddress(), e.getMessage());
            return false;
        }
        catch (BusyConnectionException e) {
            if (connection != null) {
                this.currentPool.returnConnection(connection);
            }
            this.logError(host.getAddress(), e.getMessage());
            return false;
        }
        catch (TimeoutException e) {
            this.logError(host.getAddress(), "Timeout while trying to acquire available connection");
            return false;
        }
        catch (RuntimeException e) {
            if (connection != null) {
                this.currentPool.returnConnection(connection);
            }
            logger.error("Unexpected error while querying " + host.getAddress(), (Throwable)e);
            this.logError(host.getAddress(), e.getMessage());
            return false;
        }
    }

    private void logError(InetAddress address, String msg) {
        logger.debug("Error querying {}, trying next host (error is: {})", (Object)address, (Object)msg);
        if (this.errors == null) {
            this.errors = new HashMap<InetAddress, String>();
        }
        this.errors.put(address, msg);
    }

    private void retry(final boolean retryCurrent, ConsistencyLevel newConsistencyLevel) {
        final Host h = this.current;
        this.retryConsistencyLevel = newConsistencyLevel;
        this.manager.executor().execute(new Runnable(){

            @Override
            public void run() {
                if (retryCurrent && RetryingCallback.this.query(h)) {
                    return;
                }
                RetryingCallback.this.sendRequest();
            }
        });
    }

    @Override
    public Message.Request request() {
        Message.Request request = this.callback.request();
        if (this.retryConsistencyLevel != null) {
            org.apache.cassandra.db.ConsistencyLevel cl = ConsistencyLevel.toCassandraCL(this.retryConsistencyLevel);
            if (request instanceof QueryMessage) {
                QueryMessage qm = (QueryMessage)request;
                if (qm.consistency != cl) {
                    request = new QueryMessage(qm.query, cl);
                }
            } else if (request instanceof ExecuteMessage) {
                ExecuteMessage em = (ExecuteMessage)request;
                if (em.consistency != cl) {
                    request = new ExecuteMessage(em.statementId, em.values, cl);
                }
            }
        }
        return request;
    }

    private void setFinalResult(Connection connection, Message.Response response) {
        if (this.timerContext != null) {
            this.timerContext.stop();
        }
        this.callback.onSet(connection, response);
    }

    private void setFinalException(Connection connection, Exception exception) {
        if (this.timerContext != null) {
            this.timerContext.stop();
        }
        this.callback.onException(connection, exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSet(Connection connection, Message.Response response) {
        if (this.currentPool == null) {
            logger.error("No current pool set; this should not happen");
        } else {
            this.currentPool.returnConnection(connection);
        }
        try {
            block2 : switch (response.type) {
                case RESULT: {
                    this.setFinalResult(connection, response);
                    break;
                }
                case ERROR: {
                    ErrorMessage err = (ErrorMessage)response;
                    RetryPolicy.RetryDecision retry = null;
                    RetryPolicy retryPolicy = this.query.getRetryPolicy() == null ? this.manager.configuration().getPolicies().getRetryPolicy() : this.query.getRetryPolicy();
                    switch (err.error.code()) {
                        case READ_TIMEOUT: {
                            assert (err.error instanceof ReadTimeoutException);
                            if (this.manager.configuration().isMetricsEnabled()) {
                                this.metrics().getErrorMetrics().getReadTimeouts().inc();
                            }
                            ReadTimeoutException rte = (ReadTimeoutException)err.error;
                            ConsistencyLevel rcl = ConsistencyLevel.from(rte.consistency);
                            retry = retryPolicy.onReadTimeout(this.query, rcl, rte.blockFor, rte.received, rte.dataPresent, this.queryRetries);
                            break;
                        }
                        case WRITE_TIMEOUT: {
                            assert (err.error instanceof WriteTimeoutException);
                            if (this.manager.configuration().isMetricsEnabled()) {
                                this.metrics().getErrorMetrics().getWriteTimeouts().inc();
                            }
                            WriteTimeoutException wte = (WriteTimeoutException)err.error;
                            ConsistencyLevel wcl = ConsistencyLevel.from(wte.consistency);
                            retry = retryPolicy.onWriteTimeout(this.query, wcl, WriteType.from(wte.writeType), wte.blockFor, wte.received, this.queryRetries);
                            break;
                        }
                        case UNAVAILABLE: {
                            assert (err.error instanceof UnavailableException);
                            if (this.manager.configuration().isMetricsEnabled()) {
                                this.metrics().getErrorMetrics().getUnavailables().inc();
                            }
                            UnavailableException ue = (UnavailableException)err.error;
                            ConsistencyLevel ucl = ConsistencyLevel.from(ue.consistency);
                            retry = retryPolicy.onUnavailable(this.query, ucl, ue.required, ue.alive, this.queryRetries);
                            break;
                        }
                        case OVERLOADED: {
                            logger.warn("Host {} is overloaded, trying next host.", (Object)connection.address);
                            if (this.manager.configuration().isMetricsEnabled()) {
                                this.metrics().getErrorMetrics().getOthers().inc();
                            }
                            this.retry(false, null);
                            return;
                        }
                        case IS_BOOTSTRAPPING: {
                            logger.error("Query sent to {} but it is bootstrapping. This shouldn't happen but trying next host.", (Object)connection.address);
                            if (this.manager.configuration().isMetricsEnabled()) {
                                this.metrics().getErrorMetrics().getOthers().inc();
                            }
                            this.retry(false, null);
                            return;
                        }
                        case UNPREPARED: {
                            assert (err.error instanceof PreparedQueryNotFoundException);
                            PreparedQueryNotFoundException pqnf = (PreparedQueryNotFoundException)err.error;
                            PreparedStatement toPrepare = this.manager.cluster.manager.preparedQueries.get(pqnf.id);
                            if (toPrepare == null) {
                                String msg = String.format("Tried to execute unknown prepared query %s", pqnf.id);
                                logger.error(msg);
                                this.setFinalException(connection, new DriverInternalError(msg));
                                return;
                            }
                            logger.trace("Preparing required prepared query {}", (Object)toPrepare.getQueryString());
                            String currentKeyspace = connection.keyspace();
                            String prepareKeyspace = toPrepare.getQueryKeyspace();
                            if (!(prepareKeyspace == null || currentKeyspace != null && currentKeyspace.equals(prepareKeyspace))) {
                                logger.trace("Setting keyspace for prepared query to {}", (Object)prepareKeyspace);
                                connection.setKeyspace(prepareKeyspace);
                            }
                            try {
                                connection.write(this.prepareAndRetry(toPrepare.getQueryString()));
                            }
                            finally {
                                if (connection.keyspace() == null || !connection.keyspace().equals(currentKeyspace)) {
                                    logger.trace("Setting back keyspace post query preparation to {}", (Object)currentKeyspace);
                                    connection.setKeyspace(currentKeyspace);
                                }
                            }
                            return;
                        }
                        default: {
                            if (!this.manager.configuration().isMetricsEnabled()) break;
                            this.metrics().getErrorMetrics().getOthers().inc();
                        }
                    }
                    if (retry == null) {
                        this.setFinalResult(connection, response);
                        break;
                    }
                    switch (retry.getType()) {
                        case RETRY: {
                            ++this.queryRetries;
                            if (logger.isTraceEnabled()) {
                                logger.trace("Doing retry {} for query {} at consistency {}", new Object[]{this.queryRetries, this.query, retry.getRetryConsistencyLevel()});
                            }
                            if (this.manager.configuration().isMetricsEnabled()) {
                                this.metrics().getErrorMetrics().getRetries().inc();
                            }
                            this.retry(true, retry.getRetryConsistencyLevel());
                            break block2;
                        }
                        case RETHROW: {
                            this.setFinalResult(connection, response);
                            break block2;
                        }
                        case IGNORE: {
                            if (this.manager.configuration().isMetricsEnabled()) {
                                this.metrics().getErrorMetrics().getIgnores().inc();
                            }
                            this.setFinalResult(connection, (Message.Response)new ResultMessage.Void());
                        }
                    }
                    break;
                }
                default: {
                    this.setFinalResult(connection, response);
                    break;
                }
            }
        }
        catch (Exception e) {
            this.setFinalException(connection, e);
        }
    }

    private Connection.ResponseCallback prepareAndRetry(final String toPrepare) {
        return new Connection.ResponseCallback(){

            @Override
            public Message.Request request() {
                return new PrepareMessage(toPrepare);
            }

            @Override
            public void onSet(Connection connection, Message.Response response) {
                logger.trace("Scheduling retry now that query is prepared");
                RetryingCallback.this.retry(true, null);
            }

            @Override
            public void onException(Connection connection, Exception exception) {
                RetryingCallback.this.onException(connection, exception);
            }
        };
    }

    @Override
    public void onException(Connection connection, Exception exception) {
        if (connection != null) {
            if (this.currentPool == null) {
                logger.error("No current pool set; this should not happen");
            } else {
                this.currentPool.returnConnection(connection);
            }
        }
        if (exception instanceof ConnectionException) {
            if (this.manager.configuration().isMetricsEnabled()) {
                this.metrics().getErrorMetrics().getConnectionErrors().inc();
            }
            ConnectionException ce = (ConnectionException)exception;
            this.logError(ce.address, ce.getMessage());
            this.retry(false, null);
            return;
        }
        this.setFinalException(connection, exception);
    }
}

