/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.ConnectionException;
import com.datastax.driver.core.ConvictionPolicy;
import java.net.InetAddress;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicReference;

public class Host {
    private final InetAddress address;
    private final HealthMonitor monitor;
    private volatile String datacenter;
    private volatile String rack;
    final AtomicReference<ScheduledFuture> reconnectionAttempt = new AtomicReference();

    Host(InetAddress address, ConvictionPolicy.Factory policy) {
        if (address == null || policy == null) {
            throw new NullPointerException();
        }
        this.address = address;
        this.monitor = new HealthMonitor(policy.create(this));
    }

    void setLocationInfo(String datacenter, String rack) {
        this.datacenter = datacenter;
        this.rack = rack;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public String getDatacenter() {
        return this.datacenter;
    }

    public String getRack() {
        return this.rack;
    }

    public HealthMonitor getMonitor() {
        return this.monitor;
    }

    public final int hashCode() {
        return this.address.hashCode();
    }

    public final boolean equals(Object o) {
        if (!(o instanceof Host)) {
            return false;
        }
        return this.address.equals(((Host)o).address);
    }

    public String toString() {
        return this.address.toString();
    }

    public static interface StateListener {
        public void onAdd(Host var1);

        public void onUp(Host var1);

        public void onDown(Host var1);

        public void onRemove(Host var1);
    }

    public class HealthMonitor {
        private final ConvictionPolicy policy;
        private Set<StateListener> listeners = new CopyOnWriteArraySet<StateListener>();
        private volatile boolean isUp;

        HealthMonitor(ConvictionPolicy policy) {
            this.policy = policy;
            this.isUp = true;
        }

        public void register(StateListener listener) {
            this.listeners.add(listener);
        }

        public void unregister(StateListener listener) {
            this.listeners.add(listener);
        }

        public boolean isUp() {
            return this.isUp;
        }

        private void setDown() {
            this.isUp = false;
            for (StateListener listener : this.listeners) {
                listener.onDown(Host.this);
            }
        }

        void reset() {
            this.policy.reset();
            for (StateListener listener : this.listeners) {
                listener.onUp(Host.this);
            }
            this.isUp = true;
        }

        boolean signalConnectionFailure(ConnectionException exception) {
            boolean isDown = this.policy.addFailure(exception);
            if (isDown) {
                this.setDown();
            }
            return isDown;
        }
    }
}

