/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.exceptions.DriverInternalError;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.BooleanType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.DateType;
import org.apache.cassandra.db.marshal.DecimalType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.FloatType;
import org.apache.cassandra.db.marshal.InetAddressType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.IntegerType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.ReversedType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UUIDType;

class Codec {
    private static Map<AbstractType<?>, DataType> rawNativeMap = new HashMap<AbstractType<?>, DataType>(){
        {
            this.put(AsciiType.instance, DataType.ascii());
            this.put(LongType.instance, DataType.bigint());
            this.put(BytesType.instance, DataType.blob());
            this.put(BooleanType.instance, DataType.cboolean());
            this.put(CounterColumnType.instance, DataType.counter());
            this.put(DecimalType.instance, DataType.decimal());
            this.put(DoubleType.instance, DataType.cdouble());
            this.put(FloatType.instance, DataType.cfloat());
            this.put(InetAddressType.instance, DataType.inet());
            this.put(Int32Type.instance, DataType.cint());
            this.put(UTF8Type.instance, DataType.text());
            this.put(DateType.instance, DataType.timestamp());
            this.put(UUIDType.instance, DataType.uuid());
            this.put(IntegerType.instance, DataType.varint());
            this.put(TimeUUIDType.instance, DataType.timeuuid());
        }
    };

    private Codec() {
    }

    public static <T> AbstractType<T> getCodec(DataType type) {
        return Codec.getCodecInternal(type);
    }

    private static AbstractType getCodecInternal(DataType type) {
        switch (type.getName()) {
            case ASCII: {
                return AsciiType.instance;
            }
            case BIGINT: {
                return LongType.instance;
            }
            case BLOB: {
                return BytesType.instance;
            }
            case BOOLEAN: {
                return BooleanType.instance;
            }
            case COUNTER: {
                return CounterColumnType.instance;
            }
            case DECIMAL: {
                return DecimalType.instance;
            }
            case DOUBLE: {
                return DoubleType.instance;
            }
            case FLOAT: {
                return FloatType.instance;
            }
            case INET: {
                return InetAddressType.instance;
            }
            case INT: {
                return Int32Type.instance;
            }
            case TEXT: {
                return UTF8Type.instance;
            }
            case TIMESTAMP: {
                return DateType.instance;
            }
            case UUID: {
                return UUIDType.instance;
            }
            case VARCHAR: {
                return UTF8Type.instance;
            }
            case VARINT: {
                return IntegerType.instance;
            }
            case TIMEUUID: {
                return TimeUUIDType.instance;
            }
            case LIST: {
                return ListType.getInstance(Codec.getCodec(type.getTypeArguments().get(0)));
            }
            case SET: {
                return SetType.getInstance(Codec.getCodec(type.getTypeArguments().get(0)));
            }
            case MAP: {
                return MapType.getInstance(Codec.getCodec(type.getTypeArguments().get(0)), Codec.getCodec(type.getTypeArguments().get(1)));
            }
        }
        throw new RuntimeException("Unknown type");
    }

    public static DataType rawTypeToDataType(AbstractType<?> rawType) {
        DataType type;
        if (rawType instanceof ReversedType) {
            rawType = ((ReversedType)rawType).baseType;
        }
        if ((type = rawNativeMap.get(rawType)) != null) {
            return type;
        }
        if (rawType instanceof CollectionType) {
            switch (((CollectionType)rawType).kind) {
                case LIST: {
                    return DataType.list(Codec.rawTypeToDataType(((ListType)rawType).elements));
                }
                case SET: {
                    return DataType.set(Codec.rawTypeToDataType(((SetType)rawType).elements));
                }
                case MAP: {
                    MapType mt = (MapType)rawType;
                    return DataType.map(Codec.rawTypeToDataType(mt.keys), Codec.rawTypeToDataType(mt.values));
                }
            }
        }
        throw new DriverInternalError("Unsupported type: " + rawType);
    }
}

