/*
 * Decompiled with CFR 0.152.
 */
package com.dtsx.astra.sdk.cassio;

import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.data.CqlVector;
import com.datastax.oss.driver.api.core.uuid.Uuids;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MetadataVectorRecord
implements Serializable {
    private String rowId;
    private String attributes;
    private String body;
    private Map<String, String> metadata = new HashMap<String, String>();
    private List<Float> vector;

    public MetadataVectorRecord() {
        this(Uuids.timeBased().toString(), null);
    }

    public MetadataVectorRecord(List<Float> vector) {
        this(Uuids.timeBased().toString(), vector);
    }

    public MetadataVectorRecord(String rowId, List<Float> vector) {
        this.rowId = rowId;
        this.vector = vector;
    }

    public SimpleStatement insertStatement(String keyspaceName, String tableName) {
        if (this.rowId == null) {
            throw new IllegalStateException("Row Id cannot be null");
        }
        if (this.vector == null) {
            throw new IllegalStateException("Vector cannot be null");
        }
        return SimpleStatement.newInstance((String)("INSERT INTO " + keyspaceName + "." + tableName + " (row_id,vector,attributes_blob,body_blob,metadata_s) VALUES (?,?,?,?,?)"), (Object[])new Object[]{this.rowId, CqlVector.newInstance(this.vector), this.attributes, this.body, this.metadata});
    }

    public String getRowId() {
        return this.rowId;
    }

    public String getAttributes() {
        return this.attributes;
    }

    public String getBody() {
        return this.body;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public List<Float> getVector() {
        return this.vector;
    }

    public void setRowId(String rowId) {
        this.rowId = rowId;
    }

    public void setAttributes(String attributes) {
        this.attributes = attributes;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public void setVector(List<Float> vector) {
        this.vector = vector;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetadataVectorRecord)) {
            return false;
        }
        MetadataVectorRecord other = (MetadataVectorRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$rowId = this.getRowId();
        String other$rowId = other.getRowId();
        if (this$rowId == null ? other$rowId != null : !this$rowId.equals(other$rowId)) {
            return false;
        }
        String this$attributes = this.getAttributes();
        String other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !this$attributes.equals(other$attributes)) {
            return false;
        }
        String this$body = this.getBody();
        String other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        List<Float> this$vector = this.getVector();
        List<Float> other$vector = other.getVector();
        return !(this$vector == null ? other$vector != null : !((Object)this$vector).equals(other$vector));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MetadataVectorRecord;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $rowId = this.getRowId();
        result = result * 59 + ($rowId == null ? 43 : $rowId.hashCode());
        String $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : $attributes.hashCode());
        String $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        List<Float> $vector = this.getVector();
        result = result * 59 + ($vector == null ? 43 : ((Object)$vector).hashCode());
        return result;
    }

    public String toString() {
        return "MetadataVectorRecord(rowId=" + this.getRowId() + ", attributes=" + this.getAttributes() + ", body=" + this.getBody() + ", metadata=" + String.valueOf(this.getMetadata()) + ", vector=" + String.valueOf(this.getVector()) + ")";
    }
}

