/*
 * Decompiled with CFR 0.152.
 */
package com.dtsx.astra.sdk.cassio;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import com.dtsx.astra.sdk.cassio.MetadataVectorTable;
import com.dtsx.astra.sdk.db.AstraDBOpsClient;
import com.dtsx.astra.sdk.utils.AstraEnvironment;
import io.stargate.sdk.utils.Utils;
import java.io.File;
import java.nio.file.Paths;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassIO {
    private static final Logger log = LoggerFactory.getLogger(CassIO.class);
    private static CqlSession cqlSession;
    private final Thread shutdownHook = new Thread(){

        @Override
        public void run() {
            if (cqlSession != null) {
                cqlSession.close();
            }
        }
    };

    public CassIO() {
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    public static CqlSession getCqlSession() {
        if (cqlSession == null) {
            throw new IllegalStateException("CqlSession not initialized, please use init() method");
        }
        return cqlSession;
    }

    public static synchronized CqlSession init(CqlSession cqlSession) {
        if (cqlSession == null) {
            throw new IllegalStateException("CqlSession not initialized, please use init() method");
        }
        CassIO.cqlSession = cqlSession;
        return cqlSession;
    }

    public static CqlSession init(String token, UUID dbId, String dbRegion) {
        return CassIO.init(token, dbId, dbRegion, "default_keyspace", AstraEnvironment.PROD);
    }

    public static CqlSession init(String token, UUID dbId, String dbRegion, String keyspace) {
        return CassIO.init(token, dbId, dbRegion, keyspace, AstraEnvironment.PROD);
    }

    public static synchronized CqlSession init(String token, UUID dbId, String dbRegion, String keyspace, AstraEnvironment env) {
        String secureConnectBundleFolder = (String)((Object)Utils.readEnvVariable((String)"ASTRA_DB_SCB_FOLDER").orElse(System.getProperty("user.home") + File.separator + ".astra" + File.separator + "scb"));
        if (!new File(secureConnectBundleFolder).exists() && new File(secureConnectBundleFolder).mkdirs()) {
            log.info("+ Folder Created to hold SCB {}", (Object)secureConnectBundleFolder);
        }
        AstraDBOpsClient devopsApiClient = new AstraDBOpsClient(token, env);
        devopsApiClient.database(dbId.toString()).downloadAllSecureConnectBundles(secureConnectBundleFolder);
        String scb = secureConnectBundleFolder + File.separator + "scb_" + String.valueOf(dbId) + "_" + dbRegion + ".zip";
        cqlSession = (CqlSession)((CqlSessionBuilder)((CqlSessionBuilder)((CqlSessionBuilder)CqlSession.builder().withAuthCredentials("token", token)).withCloudSecureConnectBundle(Paths.get(scb, new String[0]))).withKeyspace(keyspace)).build();
        return cqlSession;
    }

    public static MetadataVectorTable metadataVectorTable(String tableName, int vectorDimension) {
        if (tableName == null || tableName.isEmpty()) {
            throw new IllegalArgumentException("Table name must be provided");
        }
        if (vectorDimension < 1) {
            throw new IllegalArgumentException("Vector dimension must be greater than 0");
        }
        return new MetadataVectorTable(CassIO.getCqlSession(), ((CqlIdentifier)cqlSession.getKeyspace().orElseThrow(() -> new IllegalArgumentException("CqlSession does not select any keyspace"))).asInternal(), tableName, vectorDimension);
    }
}

