/*
 * Decompiled with CFR 0.152.
 */
package com.datasqrl.time;

import com.datasqrl.function.FlinkTypeUtil;
import com.datasqrl.time.TimeTumbleWindowFunctionEval;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.TypeInference;

public abstract class TimeTumbleWindowFunction
extends ScalarFunction
implements TimeTumbleWindowFunctionEval {
    protected final ChronoUnit timeUnit;
    protected final ChronoUnit offsetUnit;

    public ChronoUnit getTimeUnit() {
        return this.timeUnit;
    }

    public ChronoUnit getOffsetUnit() {
        return this.offsetUnit;
    }

    public TypeInference getTypeInference(DataTypeFactory typeFactory) {
        return TypeInference.newBuilder().inputTypeStrategy((InputTypeStrategy)FlinkTypeUtil.VariableArguments.builder().staticType(DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)3)).variableType(DataTypes.BIGINT()).minVariableArguments(0).maxVariableArguments(2).build()).outputTypeStrategy(FlinkTypeUtil.nullPreservingOutputStrategy((DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)3))).build();
    }

    @Override
    public Instant eval(Instant instant, Long multiple, Long offset) {
        if (multiple == null) {
            multiple = 1L;
        }
        if (offset == null) {
            offset = 0L;
        }
        ZonedDateTime time = ZonedDateTime.ofInstant(instant, ZoneOffset.UTC);
        ZonedDateTime truncated = time.minus(offset, this.offsetUnit).truncatedTo(this.timeUnit);
        long multipleToAdd = 1L;
        if (multiple > 1L) {
            ZonedDateTime truncatedBase = truncated.with(TemporalAdjusters.firstDayOfYear()).truncatedTo(ChronoUnit.DAYS);
            ZonedDateTime timeBase = time.with(TemporalAdjusters.firstDayOfYear()).truncatedTo(ChronoUnit.DAYS);
            if (!timeBase.equals(truncatedBase)) {
                return timeBase.plus(offset, this.offsetUnit).minusNanos(1L).toInstant();
            }
            Duration timeToBase = Duration.between(truncatedBase, truncated);
            long numberToBase = timeToBase.dividedBy(this.timeUnit.getDuration());
            multipleToAdd = multiple - numberToBase % multiple;
        }
        return truncated.plus(multipleToAdd, this.timeUnit).plus(offset, this.offsetUnit).minusNanos(1L).toInstant();
    }

    public TimeTumbleWindowFunction(ChronoUnit timeUnit, ChronoUnit offsetUnit) {
        this.timeUnit = timeUnit;
        this.offsetUnit = offsetUnit;
    }
}

