/*
 * Decompiled with CFR 0.152.
 */
package com.datasqrl.time;

import com.datasqrl.function.FlinkTypeUtil;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.TypeInference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParseTimestamp
extends ScalarFunction {
    private static final Logger log = LoggerFactory.getLogger(ParseTimestamp.class);

    public Instant eval(String s) {
        return Instant.parse(s);
    }

    public Instant eval(String s, String format) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format, Locale.US);
        try {
            return LocalDateTime.parse(s, formatter).atZone(ZoneId.systemDefault()).toInstant();
        }
        catch (Exception e) {
            log.warn(e.getMessage());
            return null;
        }
    }

    public TypeInference getTypeInference(DataTypeFactory typeFactory) {
        return TypeInference.newBuilder().inputTypeStrategy((InputTypeStrategy)FlinkTypeUtil.VariableArguments.builder().staticType(DataTypes.STRING()).variableType(DataTypes.STRING()).minVariableArguments(0).maxVariableArguments(1).build()).outputTypeStrategy(FlinkTypeUtil.nullPreservingOutputStrategy((DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)3))).build();
    }
}

