/*
 * Decompiled with CFR 0.152.
 */
package com.datasqrl.json;

import com.datasqrl.json.FlinkJsonType;
import com.datasqrl.json.FlinkJsonTypeSerializerSnapshot;
import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;

public class FlinkJsonTypeSerializer
extends TypeSerializer<FlinkJsonType> {
    ObjectMapper mapper = new ObjectMapper();

    public boolean isImmutableType() {
        return true;
    }

    public FlinkJsonType createInstance() {
        return new FlinkJsonType(null);
    }

    public FlinkJsonType copy(FlinkJsonType from) {
        return new FlinkJsonType(from.getJson());
    }

    public FlinkJsonType copy(FlinkJsonType from, FlinkJsonType reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(FlinkJsonType record, DataOutputView target) throws IOException {
        byte[] jsonData = this.mapper.writeValueAsBytes((Object)record.getJson());
        target.writeInt(jsonData.length);
        target.write(jsonData);
    }

    public FlinkJsonType deserialize(DataInputView source) throws IOException {
        int length = source.readInt();
        byte[] jsonData = new byte[length];
        source.readFully(jsonData);
        return new FlinkJsonType(this.mapper.readTree(jsonData));
    }

    public FlinkJsonType deserialize(FlinkJsonType reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int length = source.readInt();
        byte[] jsonData = new byte[length];
        source.readFully(jsonData);
        target.writeInt(length);
        target.write(jsonData);
    }

    public TypeSerializer<FlinkJsonType> duplicate() {
        return this;
    }

    public boolean equals(Object obj) {
        return obj instanceof FlinkJsonTypeSerializer;
    }

    public int hashCode() {
        return FlinkJsonTypeSerializer.class.hashCode();
    }

    public TypeSerializerSnapshot<FlinkJsonType> snapshotConfiguration() {
        return new FlinkJsonTypeSerializerSnapshot();
    }
}

