/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class JsonPrinter {
    static final String TAB = "  ";
    PrintWriter out;
    StringBuilder indent = new StringBuilder();

    public JsonPrinter(PrintWriter out) {
        this.out = out;
    }

    public static void prettyPrint(PrintWriter dst, Object obj) {
        new JsonPrinter(dst).prettyPrint(obj);
    }

    public static void prettyPrint(OutputStream dst, Object obj) {
        PrintWriter pw = new PrintWriter(dst);
        new JsonPrinter(pw).prettyPrint(obj);
        pw.flush();
    }

    public static void prettyPrint(Writer dst, Object obj) {
        PrintWriter pw = new PrintWriter(dst);
        new JsonPrinter(pw).prettyPrint(obj);
        pw.flush();
    }

    public void prettyPrint(Object obj) {
        if (obj == null) {
            this.out.print("null");
        } else if (obj instanceof Boolean) {
            this.out.print(obj);
        } else if (obj instanceof Byte || obj instanceof Short || obj instanceof Integer || obj instanceof Long) {
            long val = ((Number)obj).longValue();
            this.out.print(val);
        } else if (obj instanceof Number) {
            double val = ((Number)obj).doubleValue();
            if (Double.isNaN(val)) {
                this.out.print("\"NaN\"");
            } else if (Double.isInfinite(val)) {
                this.out.format("\"%sInf\"", val < 0.0 ? "-" : "");
            } else {
                this.out.print(val);
            }
        } else if (obj instanceof String) {
            this.out.print("\"");
            block9: for (char c : ((String)obj).toCharArray()) {
                switch (c) {
                    case '\"': {
                        this.out.print("\\\"");
                        continue block9;
                    }
                    case '\\': {
                        this.out.print("\\\\");
                        continue block9;
                    }
                    case '\b': {
                        this.out.print("\\b");
                        continue block9;
                    }
                    case '\f': {
                        this.out.print("\\f");
                        continue block9;
                    }
                    case '\n': {
                        this.out.print("\\n");
                        continue block9;
                    }
                    case '\r': {
                        this.out.print("\\r");
                        continue block9;
                    }
                    case '\t': {
                        this.out.print("\\t");
                        continue block9;
                    }
                    default: {
                        if (c < ' ') {
                            this.out.format("\\u%04x", c);
                            continue block9;
                        }
                        this.out.print(c);
                    }
                }
            }
            this.out.print("\"");
        } else if (obj instanceof List) {
            this.out.print("[ ");
            boolean first = true;
            for (Object item : (List)obj) {
                if (!first) {
                    this.out.print(", ");
                }
                first = false;
                this.prettyPrint(item);
            }
            this.out.format(" ]", new Object[0]);
        } else if (obj instanceof Map) {
            this.out.println("{");
            this.indent.append(TAB);
            boolean first = true;
            for (Map.Entry e : ((Map)obj).entrySet()) {
                if (!first) {
                    this.out.println(", ");
                }
                first = false;
                this.out.print(this.indent);
                Object key = e.getKey();
                if (!(key instanceof String)) {
                    throw new RuntimeException("invalid object key type in a map: " + key.getClass().getName());
                }
                this.prettyPrint(e.getKey());
                this.out.print(" : ");
                this.prettyPrint(e.getValue());
            }
            this.indent.delete(this.indent.length() - TAB.length(), this.indent.length());
            this.out.format("\n%s}", this.indent);
        } else if (obj instanceof String[]) {
            this.prettyPrint(Arrays.asList((String[])obj));
        } else {
            throw new RuntimeException("unsupported json data type");
        }
    }

    public static String toString(Object obj) {
        StringWriter sw = new StringWriter();
        JsonPrinter.prettyPrint(sw, obj);
        return sw.toString();
    }
}

