/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import lombok.Generated;
import org.datadog.jmxfetch.App;
import org.datadog.jmxfetch.AppConfig;
import org.datadog.jmxfetch.util.CustomLogger;
import org.datadog.jmxfetch.util.LogLevel;
import org.datadog.jmxfetch.util.MetadataHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxFetch {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JmxFetch.class);

    public static void main(String[] args) {
        AppConfig config = AppConfig.builder().build();
        JCommander commander = null;
        try {
            commander = new JCommander((Object)config, args);
        }
        catch (ParameterException e) {
            System.out.println(e.getMessage());
            System.exit(1);
        }
        if (config.isVersion() || "version".equals(config.getAction())) {
            JCommander.getConsole().println("JMX Fetch " + MetadataHelper.getVersion());
            System.exit(0);
        }
        if (config.isHelp() || "help".equals(config.getAction())) {
            commander.usage();
            System.exit(0);
        }
        CustomLogger.setup(LogLevel.fromString(config.getLogLevel()), config.getLogLocation(), config.isLogFormatRfc3339());
        JmxFetch.attachShutdownHook();
        App app = new App(config);
        System.exit(app.run());
    }

    private static void attachShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                log.info("JMXFetch is closing");
                CustomLogger.shutdown();
            }
        });
    }
}

