/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.datadog.jmxfetch.Filter;
import org.datadog.jmxfetch.JmxAttribute;

public class Configuration {
    private Map<String, Object> conf;
    private Filter include;
    private Filter exclude;

    public Configuration(Map<String, Object> conf) {
        this.conf = conf;
        this.include = new Filter(conf.get("include"));
        this.exclude = new Filter(conf.get("exclude"));
    }

    public Map<String, Object> getConf() {
        return this.conf;
    }

    public Filter getInclude() {
        return this.include;
    }

    public Filter getExclude() {
        return this.exclude;
    }

    public String toString() {
        return "include: " + this.include + " - exclude: " + this.exclude;
    }

    private Boolean hasInclude() {
        return this.getInclude() != null && !this.getInclude().isEmptyFilter();
    }

    private static List<Configuration> getIncludeConfigurationList(List<Configuration> configurationList) {
        ArrayList<Configuration> includeConfigList = new ArrayList<Configuration>(configurationList);
        Iterator confItr = includeConfigList.iterator();
        while (confItr.hasNext()) {
            Configuration conf = (Configuration)confItr.next();
            if (conf.hasInclude().booleanValue()) continue;
            confItr.remove();
        }
        return includeConfigList;
    }

    private static Map<String, List<Filter>> getIncludeFiltersByDomain(List<Configuration> configurationList) {
        HashMap<String, List<Filter>> includeFiltersByDomain = new HashMap<String, List<Filter>>();
        for (Configuration conf : configurationList) {
            Filter filter = conf.getInclude();
            ArrayList<Filter> filters = new ArrayList<Filter>();
            if (!filter.isEmptyBeanName()) {
                List<String> beanNames = filter.getBeanNames();
                for (String beanName : beanNames) {
                    String[] splitBeanName = beanName.split(":");
                    String domain = splitBeanName[0];
                    String rawBeanParameters = splitBeanName[1];
                    Map<String, String> beanParametersHash = JmxAttribute.getBeanParametersHash(rawBeanParameters);
                    beanParametersHash.put("domain", domain);
                    filters.add(new Filter(beanParametersHash));
                }
            } else {
                filters.add(filter);
            }
            for (Filter f : filters) {
                String domainName = f.getDomain();
                List domainFilters = includeFiltersByDomain.containsKey(domainName) ? (List)includeFiltersByDomain.get(domainName) : new ArrayList();
                domainFilters.add(f);
                includeFiltersByDomain.put(domainName, domainFilters);
            }
        }
        return includeFiltersByDomain;
    }

    private static Map<String, Set<String>> getCommonBeanKeysByDomain(Map<String, List<Filter>> filtersByDomain) {
        HashMap<String, Set<String>> beanKeysIntersectionByDomain = new HashMap<String, Set<String>>();
        for (Map.Entry<String, List<Filter>> filtersEntry : filtersByDomain.entrySet()) {
            List<Filter> filters = filtersEntry.getValue();
            if (filters == null || filters.isEmpty()) continue;
            HashSet<String> keysIntersection = new HashSet<String>(filters.get(0).keySet());
            for (Filter filter : filters) {
                keysIntersection.retainAll(filter.keySet());
            }
            for (String param : JmxAttribute.getExcludedBeanParams()) {
                keysIntersection.remove(param);
            }
            String domainName = filtersEntry.getKey();
            beanKeysIntersectionByDomain.put(domainName, keysIntersection);
        }
        return beanKeysIntersectionByDomain;
    }

    private static Map<String, Map<String, String>> getCommonScopeByDomain(Map<String, Set<String>> beanKeysByDomain, Map<String, List<Filter>> filtersByDomain) {
        HashMap<String, Map<String, String>> commonScopeByDomain = new HashMap<String, Map<String, String>>();
        for (Map.Entry<String, Set<String>> commonParametersByDomainEntry : beanKeysByDomain.entrySet()) {
            String domainName = commonParametersByDomainEntry.getKey();
            Set<String> commonParameters = commonParametersByDomainEntry.getValue();
            List<Filter> filters = filtersByDomain.get(domainName);
            HashMap<String, String> commonScope = new HashMap<String, String>();
            for (String parameter : commonParameters) {
                String commonValue = null;
                boolean hasCommonValue = true;
                for (Filter f : filters) {
                    List<String> parameterValues = f.getParameterValues(parameter);
                    if (parameterValues.size() != 1 || commonValue != null && !commonValue.equals(parameterValues.get(0))) {
                        hasCommonValue = false;
                        break;
                    }
                    commonValue = parameterValues.get(0);
                }
                if (!hasCommonValue) continue;
                commonScope.put(parameter, commonValue);
            }
            commonScopeByDomain.put(domainName, commonScope);
        }
        return commonScopeByDomain;
    }

    private static String beanScopeToString(String domain, Map<String, String> beanScope) {
        String result = "";
        domain = domain != null ? domain : "*";
        result = result + domain + ":";
        for (Map.Entry<String, String> beanScopeEntry : beanScope.entrySet()) {
            String param = beanScopeEntry.getKey();
            String value = beanScopeEntry.getValue();
            result = result + param + "=" + value + ",";
        }
        result = result + "*";
        return result;
    }

    public static List<String> getGreatestCommonScopes(List<Configuration> configurationList) {
        List<Configuration> includeConfigList = Configuration.getIncludeConfigurationList(configurationList);
        Map<String, List<Filter>> includeFiltersByDomain = Configuration.getIncludeFiltersByDomain(includeConfigList);
        Map<String, Set<String>> parametersIntersectionByDomain = Configuration.getCommonBeanKeysByDomain(includeFiltersByDomain);
        Map<String, Map<String, String>> commonBeanScopeByDomain = Configuration.getCommonScopeByDomain(parametersIntersectionByDomain, includeFiltersByDomain);
        ArrayList<String> result = new ArrayList<String>(commonBeanScopeByDomain.entrySet().size());
        for (Map.Entry<String, Map<String, String>> beanScopeEntry : commonBeanScopeByDomain.entrySet()) {
            String domain = beanScopeEntry.getKey();
            Map<String, String> beanScope = beanScopeEntry.getValue();
            result.add(Configuration.beanScopeToString(domain, beanScope));
        }
        return result;
    }
}

