/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch.reporter;

import com.fasterxml.jackson.jr.ob.JSON;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.datadog.jmxfetch.Instance;
import org.datadog.jmxfetch.JmxAttribute;
import org.datadog.jmxfetch.reporter.Reporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonReporter
extends Reporter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JsonReporter.class);
    private List<Map<String, Object>> metrics = new ArrayList<Map<String, Object>>();

    @Override
    protected void sendMetricPoint(String metricType, String metricName, double value, String[] tags) {
        long currentTime = System.currentTimeMillis() / 1000L;
        ArrayList<Number> point = new ArrayList<Number>(2);
        point.add(currentTime);
        point.add(value);
        ArrayList<ArrayList<Number>> points = new ArrayList<ArrayList<Number>>(1);
        points.add(point);
        HashMap<String, Object> metric = new HashMap<String, Object>();
        metric.put("host", "default");
        metric.put("interval", 0);
        metric.put("source_type_name", "JMX");
        metric.put("metric", metricName);
        metric.put("points", points);
        metric.put("tags", tags);
        metric.put("type", metricType);
        this.metrics.add(metric);
    }

    @Override
    public void doSendServiceCheck(String serviceCheckName, String status, String message, String[] tags) {
        log.debug("Displaying JSON output");
        HashMap<String, Object> sc = new HashMap<String, Object>();
        sc.put("check", serviceCheckName);
        sc.put("host_name", "default");
        sc.put("timestamp", System.currentTimeMillis() / 1000L);
        sc.put("status", this.statusToServiceCheckStatusValue(status));
        sc.put("message", message);
        sc.put("tags", tags);
        HashMap<String, List<Map<String, Object>>> aggregator = new HashMap<String, List<Map<String, Object>>>();
        aggregator.put("metrics", this.metrics);
        ArrayList<HashMap<String, Object>> serviceChecks = new ArrayList<HashMap<String, Object>>();
        serviceChecks.add(sc);
        aggregator.put("service_checks", serviceChecks);
        HashMap<String, HashMap<String, List<Map<String, Object>>>> serie = new HashMap<String, HashMap<String, List<Map<String, Object>>>>();
        serie.put("aggregator", aggregator);
        ArrayList<HashMap<String, HashMap<String, List<Map<String, Object>>>>> series = new ArrayList<HashMap<String, HashMap<String, List<Map<String, Object>>>>>(1);
        series.add(serie);
        System.out.println("=== JSON ===");
        try {
            System.out.println(JSON.std.with(new JSON.Feature[]{JSON.Feature.PRETTY_PRINT_OUTPUT, JSON.Feature.WRITE_NULL_PROPERTIES}).asString(series));
        }
        catch (IOException e) {
            log.error("Couln't produce JSON output");
        }
        this.metrics.clear();
    }

    @Override
    public void displayMetricReached() {
    }

    @Override
    public void displayMatchingAttributeName(JmxAttribute jmxAttribute, int rank, int limit) {
    }

    @Override
    public void displayNonMatchingAttributeName(JmxAttribute jmxAttribute) {
    }

    @Override
    public void displayInstanceName(Instance instance) {
    }
}

