/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.jr.ob.JSON;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

class JsonParser {
    private Map<String, Object> parsedJson;

    public JsonParser(InputStream jsonInputStream) throws IOException {
        try {
            this.parsedJson = JSON.std.mapFrom((Object)new InputStreamReader(jsonInputStream));
        }
        catch (JsonProcessingException ex) {
            throw new JsonException((Exception)((Object)ex));
        }
    }

    public JsonParser(JsonParser other) {
        this.parsedJson = new HashMap<String, Object>((Map)other.getParsedJson());
    }

    public Object getJsonConfigs() {
        return this.parsedJson.get("configs");
    }

    public Object getJsonTimestamp() {
        return this.parsedJson.get("timestamp");
    }

    public Object getJsonInstances(String key) {
        Map config = (Map)((Map)this.parsedJson.get("configs")).get(key);
        return config.get("instances");
    }

    public Object getInitConfig(String key) {
        Map config = (Map)((Map)this.parsedJson.get("configs")).get(key);
        return config.get("init_config");
    }

    public Object getParsedJson() {
        return this.parsedJson;
    }

    public static final class JsonException
    extends IOException {
        private final Exception exception;

        public JsonException(Exception exception) {
            this.exception = exception;
        }

        @Override
        public String toString() {
            return this.exception.toString();
        }
    }
}

