/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.datadog.jmxfetch.ExitWatcher;
import org.datadog.jmxfetch.Status;
import org.datadog.jmxfetch.converter.ExitWatcherConverter;
import org.datadog.jmxfetch.reporter.ConsoleReporter;
import org.datadog.jmxfetch.reporter.JsonReporter;
import org.datadog.jmxfetch.reporter.Reporter;
import org.datadog.jmxfetch.reporter.ReporterFactory;
import org.datadog.jmxfetch.service.ServiceNameProvider;
import org.datadog.jmxfetch.validator.LogLevelValidator;
import org.datadog.jmxfetch.validator.PositiveIntegerValidator;
import org.datadog.jmxfetch.validator.ReporterValidator;

@Parameters(separators="=")
public class AppConfig {
    public static final String ACTION_COLLECT = "collect";
    public static final String ACTION_LIST_JVMS = "list_jvms";
    public static final String ACTION_LIST_EVERYTHING = "list_everything";
    public static final String ACTION_LIST_COLLECTED = "list_collected_attributes";
    public static final String ACTION_LIST_MATCHING = "list_matching_attributes";
    public static final String ACTION_LIST_WITH_METRICS = "list_with_metrics";
    public static final String ACTION_LIST_WITH_RATE_METRICS = "list_with_rate_metrics";
    public static final String ACTION_LIST_NOT_MATCHING = "list_not_matching_attributes";
    public static final String ACTION_LIST_LIMITED = "list_limited_attributes";
    public static final String ACTION_HELP = "help";
    public static final String ACTION_VERSION = "version";
    public static final HashSet<String> ACTIONS = new HashSet<String>(Arrays.asList("collect", "list_everything", "list_collected_attributes", "list_matching_attributes", "list_with_metrics", "list_with_rate_metrics", "list_not_matching_attributes", "list_limited_attributes", "help", "version", "list_jvms"));
    private static final String AD_WIN_PIPE_PATH = "\\\\.\\pipe\\";
    private static final String AD_PIPE_NAME = "dd-auto_discovery";
    private static final String AD_LAUNCH_FILE = "jmx.launch";
    private static final int DEFAULT_THREAD_POOL_SIZE = 3;
    private static final int DEFAULT_COLLECTION_TO_S = 60;
    private static final int DEFAULT_RECONNECTION_TO_S = 60;
    private static final int DEFAULT_STATSD_QUEUE_SIZE = 4096;
    private static final String JMXFETCH_TELEMETRY_DOMAIN = "jmx_fetch";
    private Reporter reporter;
    @Parameter(names={"--help", "-h"}, description="Display this help page", help=true)
    private boolean help;
    @Parameter(names={"--version", "-v"}, description="Display the version number and exit", help=true)
    private boolean version;
    @Parameter(names={"--log_level", "-L"}, description="Level of verbosity", validateWith=LogLevelValidator.class, required=false)
    private String logLevel;
    @Parameter(names={"--log_location", "-l"}, description="Absolute path of the log file (default to null = no logging)", required=false)
    private String logLocation;
    @Parameter(names={"--log_format_rfc3339"}, description="Logs using the RFC3339 format for dates", required=false)
    private boolean logFormatRfc3339;
    @Parameter(names={"--conf_directory", "-D"}, description="Absolute path to the conf.d directory", required=false)
    private String confdDirectory;
    @Parameter(names={"--tmp_directory", "-T"}, description="Absolute path to a temporary directory", required=false)
    private String tmpDirectory;
    @Parameter(names={"--reporter", "-r"}, description="Reporter to use: should be either \"statsd:[STATSD_HOST][STATSD_PORT]\", \"statsd:unix://[STATSD_UNIX_SOCKET_PATH]\", \"console\" or \"json\"", validateWith=ReporterValidator.class, required=true)
    private String reporterString;
    @Parameter(names={"--statsd_telemetry", "-st"}, description="Enable StatsD client telemetry reporting", required=false)
    private boolean statsdTelemetry;
    @Parameter(names={"--jmxfetch_telemetry", "-jt"}, description="Enable additional jmxfetch telemetry reporting", required=false)
    private boolean jmxfetchTelemetry;
    @Parameter(names={"--statsd_queue_size", "-sq"}, description="Maximum number of unprocessed messages in the StatsD client queue.", validateWith=PositiveIntegerValidator.class, required=false)
    private int statsdQueueSize;
    @Parameter(names={"--statsd_nonblocking"}, description="Use non-blocking mode when sending metrics via statsd", required=false)
    private boolean statsdNonBlocking;
    @Parameter(names={"--statsd_buffer_size"}, description="Configure the statsd socket buffer size (in bytes)", validateWith=PositiveIntegerValidator.class, required=false)
    private int statsdBufferSize;
    @Parameter(names={"--statsd_socket_timeout"}, description="Configure the statsd socket timeout (in milliseconds)", validateWith=PositiveIntegerValidator.class, required=false)
    private int statsdSocketTimeout;
    @Parameter(names={"--check", "-c"}, description="Yaml file name to read (must be in the confd directory)", required=false, variableArity=true)
    private List<String> yamlFileList;
    @Parameter(names={"--check_period", "-p"}, description="Sleeping time during two iterations in ms", validateWith=PositiveIntegerValidator.class, required=false)
    private int checkPeriod;
    @Parameter(names={"--thread_pool_size", "-t"}, description="The size of the thread pool", validateWith=PositiveIntegerValidator.class, required=false)
    private int threadPoolSize;
    @Parameter(names={"--reconnection_thread_pool_size", "-u"}, description="The size of the reconnection thread pool", validateWith=PositiveIntegerValidator.class, required=false)
    private int reconnectionThreadPoolSize;
    @Parameter(names={"--collection_timeout", "-x"}, description="The concurrent collection timeout in seconds", validateWith=PositiveIntegerValidator.class, required=false)
    private int collectionTimeout;
    @Parameter(names={"--reconnection_timeout", "-y"}, description="The reconnection timeout in seconds", validateWith=PositiveIntegerValidator.class, required=false)
    private int reconnectionTimeout;
    @Parameter(names={"--ad_enabled", "--sd_enabled", "-w"}, description="Enable Auto Discovery.", required=false)
    private boolean adEnabled;
    @Parameter(names={"--ad_pipe", "--sd_pipe", "-P"}, description="Auto Discovery pipe name.", required=false)
    private String adPipe;
    @Parameter(names={"--status_location", "-s"}, description="Absolute path of the status file. (default to null = no status file written)", required=false)
    private String statusLocation;
    @Parameter(names={"--exit_file_location", "-e"}, description="Absolute path of the trigger file to watch to exit. (default to null = no exit on file)", converter=ExitWatcherConverter.class, required=false)
    private ExitWatcher exitWatcher;
    @Parameter(description="Action to take, should be in [help, version, collect, list_everything, list_collected_attributes, list_matching_attributes, list_with_metrics, list_with_rate_metrics, list_not_matching_attributes, list_limited_attributes, list_jvms]", required=true)
    private List<String> action;
    @Parameter(names={"--ipc_host", "-H"}, description="IPC host", required=false)
    private String ipcHost;
    @Parameter(names={"--ipc_port", "-I"}, description="IPC port", validateWith=PositiveIntegerValidator.class, required=false)
    private int ipcPort;
    private boolean targetDirectInstances;
    private boolean daemon;
    private boolean embedded;
    private List<String> instanceConfigResources;
    private List<String> metricConfigResources;
    private List<String> metricConfigFiles;
    private Integer initialRefreshBeansPeriod;
    private Integer refreshBeansPeriod;
    private Map<String, String> globalTags;
    private ServiceNameProvider serviceNameProvider;
    private Status status;

    public boolean updateStatus() {
        if (this.statusLocation != null) {
            this.status = new Status(this.statusLocation);
            return true;
        }
        if (this.ipcHost != null && this.ipcPort > 0) {
            this.status = new Status(this.ipcHost, this.ipcPort);
            return true;
        }
        return false;
    }

    public boolean remoteEnabled() {
        return this.ipcHost != null && this.ipcPort > 0;
    }

    public String getStatusLocation() {
        return this.statusLocation;
    }

    public String getAction() {
        if (this.action == null || this.action.isEmpty()) {
            return null;
        }
        return this.action.get(0);
    }

    public boolean isConsoleReporter() {
        return this.getReporter() != null && this.getReporter() instanceof ConsoleReporter;
    }

    public boolean isJsonReporter() {
        return this.getReporter() != null && this.getReporter() instanceof JsonReporter;
    }

    public boolean isHelp() {
        return this.help;
    }

    public boolean isVersion() {
        return this.version;
    }

    public Status getStatus() {
        return this.status;
    }

    public ExitWatcher getExitWatcher() {
        return this.exitWatcher;
    }

    public int getCheckPeriod() {
        return this.checkPeriod;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public int getReconnectionThreadPoolSize() {
        return this.reconnectionThreadPoolSize;
    }

    public int getCollectionTimeout() {
        return this.collectionTimeout;
    }

    public int getReconnectionTimeout() {
        return this.reconnectionTimeout;
    }

    public String getIpcHost() {
        return this.ipcHost;
    }

    public int getIpcPort() {
        return this.ipcPort;
    }

    public boolean getAutoDiscoveryPipeEnabled() {
        return this.adEnabled;
    }

    public Reporter getReporter() {
        if (this.reporter == null && this.reporterString != null) {
            this.reporter = ReporterFactory.getReporter(this);
        }
        return this.reporter;
    }

    public List<String> getYamlFileList() {
        return this.yamlFileList;
    }

    public String getConfdDirectory() {
        return this.confdDirectory;
    }

    public String getTmpDirectory() {
        return this.tmpDirectory;
    }

    public String getReporterString() {
        return this.reporterString;
    }

    public boolean getStatsdTelemetry() {
        return this.statsdTelemetry;
    }

    public boolean getJmxfetchTelemetry() {
        return this.jmxfetchTelemetry;
    }

    public String getJmxfetchTelemetryDomain() {
        return JMXFETCH_TELEMETRY_DOMAIN;
    }

    public int getStatsdQueueSize() {
        return this.statsdQueueSize;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public String getLogLocation() {
        return this.logLocation;
    }

    public boolean isLogFormatRfc3339() {
        return this.logFormatRfc3339;
    }

    public String getAutoDiscoveryPipe() {
        String pipePath = System.getProperty("os.name").startsWith("Windows") ? "\\\\.\\pipe\\/" + this.adPipe : this.getTmpDirectory() + "/" + this.adPipe;
        return pipePath;
    }

    public String getJmxLaunchFile() {
        return this.getTmpDirectory() + "/" + AD_LAUNCH_FILE;
    }

    public boolean isTargetDirectInstances() {
        return this.targetDirectInstances;
    }

    public List<String> getInstanceConfigResources() {
        return this.instanceConfigResources;
    }

    public List<String> getMetricConfigResources() {
        return this.metricConfigResources;
    }

    public List<String> getMetricConfigFiles() {
        return this.metricConfigFiles;
    }

    public Integer getRefreshBeansPeriod() {
        return this.refreshBeansPeriod;
    }

    public Integer getInitialRefreshBeansPeriod() {
        return this.initialRefreshBeansPeriod;
    }

    public Map<String, String> getGlobalTags() {
        return this.globalTags;
    }

    public ServiceNameProvider getServiceNameProvider() {
        return this.serviceNameProvider;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    public boolean isStatsdNonBlocking() {
        return this.statsdNonBlocking;
    }

    public int getStatsdBufferSize() {
        return this.statsdBufferSize;
    }

    public int getSocketTimeout() {
        return this.statsdSocketTimeout;
    }

    private static String $default$logLevel() {
        return "INFO";
    }

    private static boolean $default$logFormatRfc3339() {
        return false;
    }

    private static String $default$tmpDirectory() {
        return "/tmp";
    }

    private static int $default$statsdQueueSize() {
        return 4096;
    }

    private static boolean $default$statsdNonBlocking() {
        return false;
    }

    private static int $default$statsdBufferSize() {
        return 0;
    }

    private static int $default$statsdSocketTimeout() {
        return 0;
    }

    private static int $default$checkPeriod() {
        return 15000;
    }

    private static int $default$threadPoolSize() {
        return 3;
    }

    private static int $default$reconnectionThreadPoolSize() {
        return 3;
    }

    private static int $default$collectionTimeout() {
        return 60;
    }

    private static int $default$reconnectionTimeout() {
        return 60;
    }

    private static boolean $default$adEnabled() {
        return false;
    }

    private static String $default$adPipe() {
        return AD_PIPE_NAME;
    }

    private static ExitWatcher $default$exitWatcher() {
        return new ExitWatcher();
    }

    private static int $default$ipcPort() {
        return 0;
    }

    private static boolean $default$targetDirectInstances() {
        return false;
    }

    private static boolean $default$daemon() {
        return false;
    }

    private static boolean $default$embedded() {
        return false;
    }

    private static Status $default$status() {
        return new Status();
    }

    AppConfig(Reporter reporter, boolean help, boolean version, String logLevel, String logLocation, boolean logFormatRfc3339, String confdDirectory, String tmpDirectory, String reporterString, boolean statsdTelemetry, boolean jmxfetchTelemetry, int statsdQueueSize, boolean statsdNonBlocking, int statsdBufferSize, int statsdSocketTimeout, List<String> yamlFileList, int checkPeriod, int threadPoolSize, int reconnectionThreadPoolSize, int collectionTimeout, int reconnectionTimeout, boolean adEnabled, String adPipe, String statusLocation, ExitWatcher exitWatcher, List<String> action, String ipcHost, int ipcPort, boolean targetDirectInstances, boolean daemon, boolean embedded, List<String> instanceConfigResources, List<String> metricConfigResources, List<String> metricConfigFiles, Integer initialRefreshBeansPeriod, Integer refreshBeansPeriod, Map<String, String> globalTags, ServiceNameProvider serviceNameProvider, Status status) {
        this.reporter = reporter;
        this.help = help;
        this.version = version;
        this.logLevel = logLevel;
        this.logLocation = logLocation;
        this.logFormatRfc3339 = logFormatRfc3339;
        this.confdDirectory = confdDirectory;
        this.tmpDirectory = tmpDirectory;
        this.reporterString = reporterString;
        this.statsdTelemetry = statsdTelemetry;
        this.jmxfetchTelemetry = jmxfetchTelemetry;
        this.statsdQueueSize = statsdQueueSize;
        this.statsdNonBlocking = statsdNonBlocking;
        this.statsdBufferSize = statsdBufferSize;
        this.statsdSocketTimeout = statsdSocketTimeout;
        this.yamlFileList = yamlFileList;
        this.checkPeriod = checkPeriod;
        this.threadPoolSize = threadPoolSize;
        this.reconnectionThreadPoolSize = reconnectionThreadPoolSize;
        this.collectionTimeout = collectionTimeout;
        this.reconnectionTimeout = reconnectionTimeout;
        this.adEnabled = adEnabled;
        this.adPipe = adPipe;
        this.statusLocation = statusLocation;
        this.exitWatcher = exitWatcher;
        this.action = action;
        this.ipcHost = ipcHost;
        this.ipcPort = ipcPort;
        this.targetDirectInstances = targetDirectInstances;
        this.daemon = daemon;
        this.embedded = embedded;
        this.instanceConfigResources = instanceConfigResources;
        this.metricConfigResources = metricConfigResources;
        this.metricConfigFiles = metricConfigFiles;
        this.initialRefreshBeansPeriod = initialRefreshBeansPeriod;
        this.refreshBeansPeriod = refreshBeansPeriod;
        this.globalTags = globalTags;
        this.serviceNameProvider = serviceNameProvider;
        this.status = status;
    }

    public static AppConfigBuilder builder() {
        return new AppConfigBuilder();
    }

    public String toString() {
        return "AppConfig(reporter=" + this.getReporter() + ", help=" + this.isHelp() + ", version=" + this.isVersion() + ", logLevel=" + this.getLogLevel() + ", logLocation=" + this.getLogLocation() + ", logFormatRfc3339=" + this.isLogFormatRfc3339() + ", confdDirectory=" + this.getConfdDirectory() + ", tmpDirectory=" + this.getTmpDirectory() + ", reporterString=" + this.getReporterString() + ", statsdTelemetry=" + this.getStatsdTelemetry() + ", jmxfetchTelemetry=" + this.getJmxfetchTelemetry() + ", statsdQueueSize=" + this.getStatsdQueueSize() + ", statsdNonBlocking=" + this.isStatsdNonBlocking() + ", statsdBufferSize=" + this.getStatsdBufferSize() + ", statsdSocketTimeout=" + this.statsdSocketTimeout + ", yamlFileList=" + this.getYamlFileList() + ", checkPeriod=" + this.getCheckPeriod() + ", threadPoolSize=" + this.getThreadPoolSize() + ", reconnectionThreadPoolSize=" + this.getReconnectionThreadPoolSize() + ", collectionTimeout=" + this.getCollectionTimeout() + ", reconnectionTimeout=" + this.getReconnectionTimeout() + ", adEnabled=" + this.adEnabled + ", adPipe=" + this.adPipe + ", statusLocation=" + this.getStatusLocation() + ", exitWatcher=" + this.getExitWatcher() + ", action=" + this.getAction() + ", ipcHost=" + this.getIpcHost() + ", ipcPort=" + this.getIpcPort() + ", targetDirectInstances=" + this.isTargetDirectInstances() + ", daemon=" + this.isDaemon() + ", embedded=" + this.isEmbedded() + ", instanceConfigResources=" + this.getInstanceConfigResources() + ", metricConfigResources=" + this.getMetricConfigResources() + ", metricConfigFiles=" + this.getMetricConfigFiles() + ", initialRefreshBeansPeriod=" + this.getInitialRefreshBeansPeriod() + ", refreshBeansPeriod=" + this.getRefreshBeansPeriod() + ", globalTags=" + this.getGlobalTags() + ", serviceNameProvider=" + this.getServiceNameProvider() + ", status=" + this.getStatus() + ")";
    }

    public static class AppConfigBuilder {
        private Reporter reporter;
        private boolean help;
        private boolean version;
        private boolean logLevel$set;
        private String logLevel$value;
        private String logLocation;
        private boolean logFormatRfc3339$set;
        private boolean logFormatRfc3339$value;
        private String confdDirectory;
        private boolean tmpDirectory$set;
        private String tmpDirectory$value;
        private String reporterString;
        private boolean statsdTelemetry;
        private boolean jmxfetchTelemetry;
        private boolean statsdQueueSize$set;
        private int statsdQueueSize$value;
        private boolean statsdNonBlocking$set;
        private boolean statsdNonBlocking$value;
        private boolean statsdBufferSize$set;
        private int statsdBufferSize$value;
        private boolean statsdSocketTimeout$set;
        private int statsdSocketTimeout$value;
        private List<String> yamlFileList;
        private boolean checkPeriod$set;
        private int checkPeriod$value;
        private boolean threadPoolSize$set;
        private int threadPoolSize$value;
        private boolean reconnectionThreadPoolSize$set;
        private int reconnectionThreadPoolSize$value;
        private boolean collectionTimeout$set;
        private int collectionTimeout$value;
        private boolean reconnectionTimeout$set;
        private int reconnectionTimeout$value;
        private boolean adEnabled$set;
        private boolean adEnabled$value;
        private boolean adPipe$set;
        private String adPipe$value;
        private String statusLocation;
        private boolean exitWatcher$set;
        private ExitWatcher exitWatcher$value;
        private List<String> action;
        private String ipcHost;
        private boolean ipcPort$set;
        private int ipcPort$value;
        private boolean targetDirectInstances$set;
        private boolean targetDirectInstances$value;
        private boolean daemon$set;
        private boolean daemon$value;
        private boolean embedded$set;
        private boolean embedded$value;
        private List<String> instanceConfigResources;
        private List<String> metricConfigResources;
        private List<String> metricConfigFiles;
        private Integer initialRefreshBeansPeriod;
        private Integer refreshBeansPeriod;
        private Map<String, String> globalTags;
        private ServiceNameProvider serviceNameProvider;
        private boolean status$set;
        private Status status$value;

        AppConfigBuilder() {
        }

        public AppConfigBuilder reporter(Reporter reporter) {
            this.reporter = reporter;
            return this;
        }

        public AppConfigBuilder help(boolean help) {
            this.help = help;
            return this;
        }

        public AppConfigBuilder version(boolean version) {
            this.version = version;
            return this;
        }

        public AppConfigBuilder logLevel(String logLevel) {
            this.logLevel$value = logLevel;
            this.logLevel$set = true;
            return this;
        }

        public AppConfigBuilder logLocation(String logLocation) {
            this.logLocation = logLocation;
            return this;
        }

        public AppConfigBuilder logFormatRfc3339(boolean logFormatRfc3339) {
            this.logFormatRfc3339$value = logFormatRfc3339;
            this.logFormatRfc3339$set = true;
            return this;
        }

        public AppConfigBuilder confdDirectory(String confdDirectory) {
            this.confdDirectory = confdDirectory;
            return this;
        }

        public AppConfigBuilder tmpDirectory(String tmpDirectory) {
            this.tmpDirectory$value = tmpDirectory;
            this.tmpDirectory$set = true;
            return this;
        }

        public AppConfigBuilder reporterString(String reporterString) {
            this.reporterString = reporterString;
            return this;
        }

        public AppConfigBuilder statsdTelemetry(boolean statsdTelemetry) {
            this.statsdTelemetry = statsdTelemetry;
            return this;
        }

        public AppConfigBuilder jmxfetchTelemetry(boolean jmxfetchTelemetry) {
            this.jmxfetchTelemetry = jmxfetchTelemetry;
            return this;
        }

        public AppConfigBuilder statsdQueueSize(int statsdQueueSize) {
            this.statsdQueueSize$value = statsdQueueSize;
            this.statsdQueueSize$set = true;
            return this;
        }

        public AppConfigBuilder statsdNonBlocking(boolean statsdNonBlocking) {
            this.statsdNonBlocking$value = statsdNonBlocking;
            this.statsdNonBlocking$set = true;
            return this;
        }

        public AppConfigBuilder statsdBufferSize(int statsdBufferSize) {
            this.statsdBufferSize$value = statsdBufferSize;
            this.statsdBufferSize$set = true;
            return this;
        }

        public AppConfigBuilder statsdSocketTimeout(int statsdSocketTimeout) {
            this.statsdSocketTimeout$value = statsdSocketTimeout;
            this.statsdSocketTimeout$set = true;
            return this;
        }

        public AppConfigBuilder yamlFileList(List<String> yamlFileList) {
            this.yamlFileList = yamlFileList;
            return this;
        }

        public AppConfigBuilder checkPeriod(int checkPeriod) {
            this.checkPeriod$value = checkPeriod;
            this.checkPeriod$set = true;
            return this;
        }

        public AppConfigBuilder threadPoolSize(int threadPoolSize) {
            this.threadPoolSize$value = threadPoolSize;
            this.threadPoolSize$set = true;
            return this;
        }

        public AppConfigBuilder reconnectionThreadPoolSize(int reconnectionThreadPoolSize) {
            this.reconnectionThreadPoolSize$value = reconnectionThreadPoolSize;
            this.reconnectionThreadPoolSize$set = true;
            return this;
        }

        public AppConfigBuilder collectionTimeout(int collectionTimeout) {
            this.collectionTimeout$value = collectionTimeout;
            this.collectionTimeout$set = true;
            return this;
        }

        public AppConfigBuilder reconnectionTimeout(int reconnectionTimeout) {
            this.reconnectionTimeout$value = reconnectionTimeout;
            this.reconnectionTimeout$set = true;
            return this;
        }

        public AppConfigBuilder adEnabled(boolean adEnabled) {
            this.adEnabled$value = adEnabled;
            this.adEnabled$set = true;
            return this;
        }

        public AppConfigBuilder adPipe(String adPipe) {
            this.adPipe$value = adPipe;
            this.adPipe$set = true;
            return this;
        }

        public AppConfigBuilder statusLocation(String statusLocation) {
            this.statusLocation = statusLocation;
            return this;
        }

        public AppConfigBuilder exitWatcher(ExitWatcher exitWatcher) {
            this.exitWatcher$value = exitWatcher;
            this.exitWatcher$set = true;
            return this;
        }

        public AppConfigBuilder action(List<String> action) {
            this.action = action;
            return this;
        }

        public AppConfigBuilder ipcHost(String ipcHost) {
            this.ipcHost = ipcHost;
            return this;
        }

        public AppConfigBuilder ipcPort(int ipcPort) {
            this.ipcPort$value = ipcPort;
            this.ipcPort$set = true;
            return this;
        }

        public AppConfigBuilder targetDirectInstances(boolean targetDirectInstances) {
            this.targetDirectInstances$value = targetDirectInstances;
            this.targetDirectInstances$set = true;
            return this;
        }

        public AppConfigBuilder daemon(boolean daemon) {
            this.daemon$value = daemon;
            this.daemon$set = true;
            return this;
        }

        public AppConfigBuilder embedded(boolean embedded) {
            this.embedded$value = embedded;
            this.embedded$set = true;
            return this;
        }

        public AppConfigBuilder instanceConfigResources(List<String> instanceConfigResources) {
            this.instanceConfigResources = instanceConfigResources;
            return this;
        }

        public AppConfigBuilder metricConfigResources(List<String> metricConfigResources) {
            this.metricConfigResources = metricConfigResources;
            return this;
        }

        public AppConfigBuilder metricConfigFiles(List<String> metricConfigFiles) {
            this.metricConfigFiles = metricConfigFiles;
            return this;
        }

        public AppConfigBuilder initialRefreshBeansPeriod(Integer initialRefreshBeansPeriod) {
            this.initialRefreshBeansPeriod = initialRefreshBeansPeriod;
            return this;
        }

        public AppConfigBuilder refreshBeansPeriod(Integer refreshBeansPeriod) {
            this.refreshBeansPeriod = refreshBeansPeriod;
            return this;
        }

        public AppConfigBuilder globalTags(Map<String, String> globalTags) {
            this.globalTags = globalTags;
            return this;
        }

        public AppConfigBuilder serviceNameProvider(ServiceNameProvider serviceNameProvider) {
            this.serviceNameProvider = serviceNameProvider;
            return this;
        }

        public AppConfigBuilder status(Status status) {
            this.status$value = status;
            this.status$set = true;
            return this;
        }

        public AppConfig build() {
            String logLevel$value = this.logLevel$value;
            if (!this.logLevel$set) {
                logLevel$value = AppConfig.$default$logLevel();
            }
            boolean logFormatRfc3339$value = this.logFormatRfc3339$value;
            if (!this.logFormatRfc3339$set) {
                logFormatRfc3339$value = AppConfig.$default$logFormatRfc3339();
            }
            String tmpDirectory$value = this.tmpDirectory$value;
            if (!this.tmpDirectory$set) {
                tmpDirectory$value = AppConfig.$default$tmpDirectory();
            }
            int statsdQueueSize$value = this.statsdQueueSize$value;
            if (!this.statsdQueueSize$set) {
                statsdQueueSize$value = AppConfig.$default$statsdQueueSize();
            }
            boolean statsdNonBlocking$value = this.statsdNonBlocking$value;
            if (!this.statsdNonBlocking$set) {
                statsdNonBlocking$value = AppConfig.$default$statsdNonBlocking();
            }
            int statsdBufferSize$value = this.statsdBufferSize$value;
            if (!this.statsdBufferSize$set) {
                statsdBufferSize$value = AppConfig.$default$statsdBufferSize();
            }
            int statsdSocketTimeout$value = this.statsdSocketTimeout$value;
            if (!this.statsdSocketTimeout$set) {
                statsdSocketTimeout$value = AppConfig.$default$statsdSocketTimeout();
            }
            int checkPeriod$value = this.checkPeriod$value;
            if (!this.checkPeriod$set) {
                checkPeriod$value = AppConfig.$default$checkPeriod();
            }
            int threadPoolSize$value = this.threadPoolSize$value;
            if (!this.threadPoolSize$set) {
                threadPoolSize$value = AppConfig.$default$threadPoolSize();
            }
            int reconnectionThreadPoolSize$value = this.reconnectionThreadPoolSize$value;
            if (!this.reconnectionThreadPoolSize$set) {
                reconnectionThreadPoolSize$value = AppConfig.$default$reconnectionThreadPoolSize();
            }
            int collectionTimeout$value = this.collectionTimeout$value;
            if (!this.collectionTimeout$set) {
                collectionTimeout$value = AppConfig.$default$collectionTimeout();
            }
            int reconnectionTimeout$value = this.reconnectionTimeout$value;
            if (!this.reconnectionTimeout$set) {
                reconnectionTimeout$value = AppConfig.$default$reconnectionTimeout();
            }
            boolean adEnabled$value = this.adEnabled$value;
            if (!this.adEnabled$set) {
                adEnabled$value = AppConfig.$default$adEnabled();
            }
            String adPipe$value = this.adPipe$value;
            if (!this.adPipe$set) {
                adPipe$value = AppConfig.$default$adPipe();
            }
            ExitWatcher exitWatcher$value = this.exitWatcher$value;
            if (!this.exitWatcher$set) {
                exitWatcher$value = AppConfig.$default$exitWatcher();
            }
            int ipcPort$value = this.ipcPort$value;
            if (!this.ipcPort$set) {
                ipcPort$value = AppConfig.$default$ipcPort();
            }
            boolean targetDirectInstances$value = this.targetDirectInstances$value;
            if (!this.targetDirectInstances$set) {
                targetDirectInstances$value = AppConfig.$default$targetDirectInstances();
            }
            boolean daemon$value = this.daemon$value;
            if (!this.daemon$set) {
                daemon$value = AppConfig.$default$daemon();
            }
            boolean embedded$value = this.embedded$value;
            if (!this.embedded$set) {
                embedded$value = AppConfig.$default$embedded();
            }
            Status status$value = this.status$value;
            if (!this.status$set) {
                status$value = AppConfig.$default$status();
            }
            return new AppConfig(this.reporter, this.help, this.version, logLevel$value, this.logLocation, logFormatRfc3339$value, this.confdDirectory, tmpDirectory$value, this.reporterString, this.statsdTelemetry, this.jmxfetchTelemetry, statsdQueueSize$value, statsdNonBlocking$value, statsdBufferSize$value, statsdSocketTimeout$value, this.yamlFileList, checkPeriod$value, threadPoolSize$value, reconnectionThreadPoolSize$value, collectionTimeout$value, reconnectionTimeout$value, adEnabled$value, adPipe$value, this.statusLocation, exitWatcher$value, this.action, this.ipcHost, ipcPort$value, targetDirectInstances$value, daemon$value, embedded$value, this.instanceConfigResources, this.metricConfigResources, this.metricConfigFiles, this.initialRefreshBeansPeriod, this.refreshBeansPeriod, this.globalTags, this.serviceNameProvider, status$value);
        }

        public String toString() {
            return "AppConfig.AppConfigBuilder(reporter=" + this.reporter + ", help=" + this.help + ", version=" + this.version + ", logLevel$value=" + this.logLevel$value + ", logLocation=" + this.logLocation + ", logFormatRfc3339$value=" + this.logFormatRfc3339$value + ", confdDirectory=" + this.confdDirectory + ", tmpDirectory$value=" + this.tmpDirectory$value + ", reporterString=" + this.reporterString + ", statsdTelemetry=" + this.statsdTelemetry + ", jmxfetchTelemetry=" + this.jmxfetchTelemetry + ", statsdQueueSize$value=" + this.statsdQueueSize$value + ", statsdNonBlocking$value=" + this.statsdNonBlocking$value + ", statsdBufferSize$value=" + this.statsdBufferSize$value + ", statsdSocketTimeout$value=" + this.statsdSocketTimeout$value + ", yamlFileList=" + this.yamlFileList + ", checkPeriod$value=" + this.checkPeriod$value + ", threadPoolSize$value=" + this.threadPoolSize$value + ", reconnectionThreadPoolSize$value=" + this.reconnectionThreadPoolSize$value + ", collectionTimeout$value=" + this.collectionTimeout$value + ", reconnectionTimeout$value=" + this.reconnectionTimeout$value + ", adEnabled$value=" + this.adEnabled$value + ", adPipe$value=" + this.adPipe$value + ", statusLocation=" + this.statusLocation + ", exitWatcher$value=" + this.exitWatcher$value + ", action=" + this.action + ", ipcHost=" + this.ipcHost + ", ipcPort$value=" + this.ipcPort$value + ", targetDirectInstances$value=" + this.targetDirectInstances$value + ", daemon$value=" + this.daemon$value + ", embedded$value=" + this.embedded$value + ", instanceConfigResources=" + this.instanceConfigResources + ", metricConfigResources=" + this.metricConfigResources + ", metricConfigFiles=" + this.metricConfigFiles + ", initialRefreshBeansPeriod=" + this.initialRefreshBeansPeriod + ", refreshBeansPeriod=" + this.refreshBeansPeriod + ", globalTags=" + this.globalTags + ", serviceNameProvider=" + this.serviceNameProvider + ", status$value=" + this.status$value + ")";
        }
    }
}

