/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch.util;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMISocketFactory;
import javax.rmi.ssl.SslRMIClientSocketFactory;

public class JmxfetchRmiClientSocketFactory
implements RMIClientSocketFactory {
    private final int timeoutMs;
    private final int connectionTimeoutMs;
    private final RMIClientSocketFactory factory;

    public JmxfetchRmiClientSocketFactory(int timeoutMs, int connectionTimeoutMs, boolean ssl) {
        this.timeoutMs = timeoutMs;
        this.connectionTimeoutMs = connectionTimeoutMs;
        this.factory = ssl ? new SslRMIClientSocketFactory() : RMISocketFactory.getDefaultSocketFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Socket createSocket(String host, int port) throws IOException {
        Socket socket = null;
        AsyncSocketFactory f = new AsyncSocketFactory(this.factory, host, port);
        Thread t = new Thread(f);
        try {
            AsyncSocketFactory asyncSocketFactory = f;
            synchronized (asyncSocketFactory) {
                t.start();
                try {
                    long now = System.currentTimeMillis();
                    long until = now + (long)this.connectionTimeoutMs;
                    do {
                        f.wait(until - now);
                    } while ((socket = this.getSocketFromFactory(f)) == null && (now = System.currentTimeMillis()) < until);
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException("interrupted during socket connection attempt");
                }
            }
        }
        catch (IOException e) {
            f.clean();
            throw e;
        }
        if (socket == null) {
            throw new IOException("connect timed out: " + host + ":" + port);
        }
        socket.setSoTimeout(this.timeoutMs);
        socket.setSoLinger(false, 0);
        return socket;
    }

    Socket getSocketFromFactory(AsyncSocketFactory factory) throws IOException {
        Exception e = factory.getException();
        if (e != null) {
            e.fillInStackTrace();
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new Error("unforeseen checked exception" + e.toString());
        }
        return factory.getSocket();
    }

    private class AsyncSocketFactory
    implements Runnable {
        private final RMIClientSocketFactory factory;
        private final String host;
        private final int port;
        private Exception exception = null;
        private Socket socket = null;
        private boolean shouldClose = false;

        AsyncSocketFactory(RMIClientSocketFactory factory, String host, int port) {
            this.factory = factory;
            this.host = host;
            this.port = port;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Socket s = this.factory.createSocket(this.host, this.port);
                AsyncSocketFactory asyncSocketFactory = this;
                synchronized (asyncSocketFactory) {
                    this.socket = s;
                    this.notify();
                }
                asyncSocketFactory = this;
                synchronized (asyncSocketFactory) {
                    if (this.shouldClose) {
                        try {
                            s.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (Exception e) {
                AsyncSocketFactory asyncSocketFactory = this;
                synchronized (asyncSocketFactory) {
                    this.exception = e;
                    this.notify();
                }
            }
        }

        synchronized void clean() {
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.shouldClose = true;
        }

        private synchronized Exception getException() {
            return this.exception;
        }

        private synchronized Socket getSocket() {
            return this.socket;
        }
    }
}

