/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch;

import com.fasterxml.jackson.jr.ob.JSON;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.datadog.jmxfetch.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class Status {
    private static final Logger log = LoggerFactory.getLogger(Status.class);
    public static final String STATUS_WARNING = "WARNING";
    public static final String STATUS_OK = "OK";
    public static final String STATUS_ERROR = "ERROR";
    private static final String INITIALIZED_CHECKS = "initialized_checks";
    private static final String FAILED_CHECKS = "failed_checks";
    private static final String API_STATUS_PATH = "agent/jmx/status";
    private Map<String, Object> instanceStats;
    private String statusFileLocation;
    private HttpClient client;
    private boolean isEnabled;

    public Status() {
        this(null);
    }

    public Status(String host, int port) {
        this.client = new HttpClient(host, port, false);
        this.configure(null, host, port);
    }

    public Status(String statusFileLocation) {
        this.configure(statusFileLocation, null, 0);
    }

    void configure(String statusFileLocation, String host, int port) {
        this.statusFileLocation = statusFileLocation;
        this.instanceStats = new HashMap<String, Object>();
        this.isEnabled = this.statusFileLocation != null || this.client != null;
        this.clearStats();
    }

    private void clearStats() {
        this.instanceStats.put(INITIALIZED_CHECKS, new HashMap());
        this.instanceStats.put(FAILED_CHECKS, new HashMap());
    }

    public void addInstanceStats(String checkName, String instance, int metricCount, int serviceCheckCount, String message, String status) {
        this.addStats(checkName, instance, metricCount, serviceCheckCount, message, status, INITIALIZED_CHECKS);
    }

    private void addStats(String checkName, String instance, int metricCount, int serviceCheckCount, String message, String status, String key) {
        ArrayList checkStats;
        HashMap initializedChecks = (HashMap)this.instanceStats.get(key);
        if (initializedChecks == null) {
            initializedChecks = new HashMap();
        }
        if ((checkStats = (ArrayList)initializedChecks.get(checkName)) == null) {
            checkStats = new ArrayList();
        }
        HashMap<String, Object> instStats = new HashMap<String, Object>();
        if (instance != null) {
            instStats.put("instance_name", instance);
        }
        if (metricCount != -1) {
            instStats.put("metric_count", metricCount);
        }
        if (serviceCheckCount != -1) {
            instStats.put("service_check_count", serviceCheckCount);
        }
        instStats.put("message", message);
        instStats.put("status", status);
        checkStats.add(instStats);
        initializedChecks.put(checkName, checkStats);
        this.instanceStats.put(key, initializedChecks);
    }

    public void addInitFailedCheck(String checkName, String message, String status) {
        this.addStats(checkName, null, -1, -1, message, status, FAILED_CHECKS);
    }

    private String generateYaml() {
        Yaml yaml = new Yaml();
        HashMap<String, Object> status = new HashMap<String, Object>();
        status.put("timestamp", System.currentTimeMillis());
        status.put("checks", this.instanceStats);
        return yaml.dump(status);
    }

    private String generateJson() throws IOException {
        HashMap<String, Object> status = new HashMap<String, Object>();
        status.put("timestamp", System.currentTimeMillis());
        status.put("checks", this.instanceStats);
        return JSON.std.with(new JSON.Feature[]{JSON.Feature.WRITE_NULL_PROPERTIES}).asString(status);
    }

    public void flush() {
        if (this.isEnabled()) {
            if (this.client != null) {
                try {
                    String json = this.generateJson();
                    HttpClient.HttpResponse response = this.client.request("POST", json, API_STATUS_PATH);
                    if (!response.isResponse2xx()) {
                        log.debug("Problem submitting JSON status: " + json);
                    }
                }
                catch (Exception e) {
                    log.warn("Could not post status: " + e.getMessage());
                }
            } else {
                String yaml = this.generateYaml();
                try {
                    File statusFile = new File(this.statusFileLocation);
                    log.debug("Writing status to temp yaml file: " + statusFile.getAbsolutePath());
                    Status.writeStringToFile(statusFile, yaml);
                }
                catch (Exception e) {
                    log.warn("Cannot write status to temp file: " + e.getMessage());
                }
            }
        }
        this.clearStats();
    }

    public String getStatusFileLocation() {
        return this.statusFileLocation;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeStringToFile(File file, String string) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        BufferedOutputStream bos = new BufferedOutputStream(out);
        try {
            bos.write(string.getBytes(Charset.forName("UTF-8")));
        }
        finally {
            bos.close();
            out.close();
        }
    }
}

