/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch.reporter;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import org.datadog.jmxfetch.Instance;
import org.datadog.jmxfetch.JmxAttribute;
import org.datadog.jmxfetch.reporter.Reporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonReporter
extends Reporter {
    private static final Logger log = LoggerFactory.getLogger(JsonReporter.class);
    private LinkedList<HashMap<String, Object>> metrics = new LinkedList();

    @Override
    protected void sendMetricPoint(String metricType, String metricName, double value, String[] tags) {
        long currentTime = System.currentTimeMillis() / 1000L;
        ArrayList<Number> point = new ArrayList<Number>();
        point.add(currentTime);
        point.add(value);
        ArrayList<ArrayList<Number>> points = new ArrayList<ArrayList<Number>>();
        points.add(point);
        HashMap<String, Object> metric = new HashMap<String, Object>();
        metric.put("host", "default");
        metric.put("interval", 0);
        metric.put("source_type_name", "JMX");
        metric.put("metric", metricName);
        metric.put("points", points);
        metric.put("tags", tags);
        metric.put("type", metricType);
        this.metrics.add(metric);
    }

    @Override
    public void doSendServiceCheck(String checkName, String status, String message, String[] tags) {
        HashMap<String, LinkedList<HashMap<String, Object>>> aggregator = new HashMap<String, LinkedList<HashMap<String, Object>>>();
        aggregator.put("metrics", this.metrics);
        HashMap<String, HashMap<String, LinkedList<HashMap<String, Object>>>> serie = new HashMap<String, HashMap<String, LinkedList<HashMap<String, Object>>>>();
        serie.put("aggregator", aggregator);
        ArrayList<HashMap<String, HashMap<String, LinkedList<HashMap<String, Object>>>>> series = new ArrayList<HashMap<String, HashMap<String, LinkedList<HashMap<String, Object>>>>>();
        series.add(serie);
        System.out.println("=== JSON ===");
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        try {
            mapper.writeValue((OutputStream)System.out, series);
        }
        catch (IOException e) {
            log.error("Couln't produce JSON output");
        }
    }

    @Override
    public void displayMetricReached() {
    }

    @Override
    public void displayMatchingAttributeName(JmxAttribute jmxAttribute, int rank, int limit) {
    }

    @Override
    public void displayNonMatchingAttributeName(JmxAttribute jmxAttribute) {
    }

    @Override
    public void displayInstanceName(Instance instance) {
    }
}

