/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch.tasks;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.datadog.jmxfetch.Instance;
import org.datadog.jmxfetch.InstanceTask;
import org.datadog.jmxfetch.reporter.Reporter;
import org.datadog.jmxfetch.tasks.TaskMethod;
import org.datadog.jmxfetch.tasks.TaskStatusHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskProcessor {
    private static final Logger log = LoggerFactory.getLogger(TaskProcessor.class);
    private Reporter reporter;
    private ExecutorService threadPoolExecutor;

    public TaskProcessor(ExecutorService executor, Reporter reporter) {
        this.threadPoolExecutor = executor;
        this.reporter = reporter;
    }

    public void setThreadPoolExecutor(ExecutorService executor) {
        this.threadPoolExecutor = executor;
    }

    public boolean ready() {
        ThreadPoolExecutor tpe = (ThreadPoolExecutor)this.threadPoolExecutor;
        return tpe.getMaximumPoolSize() != tpe.getActiveCount();
    }

    public <T> List<TaskStatusHandler> processTasks(List<InstanceTask<T>> tasks, int timeout, TimeUnit timeUnit, TaskMethod<T> processor) throws Exception {
        ArrayList<TaskStatusHandler> statuses = new ArrayList<TaskStatusHandler>();
        try {
            ArrayList<InstanceTask<T>> callables = new ArrayList<InstanceTask<T>>();
            for (InstanceTask<T> task : tasks) {
                callables.add(task);
            }
            List results = this.threadPoolExecutor.invokeAll(callables, timeout, timeUnit);
            for (int i = 0; i < results.size(); ++i) {
                Instance instance = tasks.get(i).getInstance();
                try {
                    Future future = results.get(i);
                    statuses.add(processor.invoke(instance, future, this.reporter));
                    continue;
                }
                catch (Exception e) {
                    log.warn("There was an error processing concurrent instance: " + instance, (Throwable)e);
                    statuses.add(new TaskStatusHandler(e));
                }
            }
        }
        catch (Exception e) {
            log.warn("JMXFetch internal TaskProcessor error invoking concurrent tasks: ", (Throwable)e);
            throw e;
        }
        return statuses;
    }

    public void stop() {
        this.threadPoolExecutor.shutdownNow();
    }
}

