/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch.reporter;

import com.google.common.base.Joiner;
import java.util.Arrays;
import org.datadog.jmxfetch.reporter.ConsoleReporter;
import org.datadog.jmxfetch.reporter.Reporter;
import org.datadog.jmxfetch.reporter.StatsdReporter;

public class ReporterFactory {
    public static Reporter getReporter(String type) {
        if (type == null || type.length() <= 0) {
            throw new IllegalArgumentException("Null or empty reporter type");
        }
        if ("console".equals(type)) {
            return new ConsoleReporter();
        }
        if (type.startsWith("statsd:")) {
            String[] typeElements = type.split(":");
            String host = "localhost";
            Integer port = Integer.valueOf(typeElements[typeElements.length - 1]);
            if (typeElements.length > 2) {
                host = Joiner.on((String)":").join((Object[])Arrays.copyOfRange(typeElements, 1, typeElements.length - 1));
            }
            return new StatsdReporter(host, port);
        }
        throw new IllegalArgumentException("Invalid reporter type: " + type);
    }

    private ReporterFactory() {
    }
}

