/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch.util;

public final class ByteArraySearcher {
    private final long[] high;
    private final long[] low;
    private final long termination;

    public ByteArraySearcher(byte[] term) {
        if (term.length > 64) {
            throw new IllegalArgumentException("term must be shorter than 64 characters");
        }
        this.high = new long[16];
        this.low = new long[16];
        int mask = 1;
        for (byte b : term) {
            int n = b & 0xF;
            this.low[n] = this.low[n] | (long)mask;
            int n2 = b >>> 4;
            this.high[n2] = this.high[n2] | (long)mask;
            mask <<= 1;
        }
        this.termination = 1 << term.length - 1;
    }

    public boolean matches(byte[] array) {
        long state = 0L;
        for (int i = 0; i < array.length; ++i) {
            byte symbol = array[i];
            long highMask = this.high[symbol >>> 4];
            long lowMask = this.low[symbol & 0xF];
            if (((state = (state << 1 | 1L) & highMask & lowMask) & this.termination) != this.termination) continue;
            return true;
        }
        return false;
    }
}

