/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.management.remote.JMXServiceURL;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import org.apache.log4j.Logger;
import org.datadog.jmxfetch.Connection;

public class RemoteConnection
extends Connection {
    private String host;
    private Integer port;
    private String user;
    private String password;
    private String path = "jmxrmi";
    private String jmxUrl;
    private String rmiTimeout;
    private static final String TRUST_STORE_PATH_KEY = "trust_store_path";
    private static final String TRUST_STORE_PASSWORD_KEY = "trust_store_password";
    private static final String KEY_STORE_PATH_KEY = "key_store_path";
    private static final String KEY_STORE_PASSWORD_KEY = "key_store_password";
    private static final String DEFAULT_RMI_RESPONSE_TIMEOUT = "15000";
    private static final Logger LOGGER = Logger.getLogger((String)Connection.class.getName());

    public RemoteConnection(LinkedHashMap<String, Object> connectionParams) throws IOException {
        this.host = (String)connectionParams.get("host");
        try {
            this.port = (Integer)connectionParams.get("port");
        }
        catch (ClassCastException e) {
            this.port = Integer.parseInt((String)connectionParams.get("port"));
        }
        try {
            this.rmiTimeout = (String)connectionParams.get("rmi_client_timeout");
        }
        catch (ClassCastException e) {
            this.rmiTimeout = Integer.toString((Integer)connectionParams.get("rmi_client_timeout"));
        }
        if (this.rmiTimeout == null) {
            this.rmiTimeout = DEFAULT_RMI_RESPONSE_TIMEOUT;
        }
        this.user = (String)connectionParams.get("user");
        this.password = (String)connectionParams.get("password");
        this.jmxUrl = (String)connectionParams.get("jmx_url");
        if (connectionParams.containsKey("path")) {
            this.path = (String)connectionParams.get("path");
        }
        this.env = this.getEnv(connectionParams);
        this.address = this.getAddress(connectionParams);
        if (connectionParams.containsKey(TRUST_STORE_PATH_KEY) && connectionParams.containsKey(TRUST_STORE_PASSWORD_KEY)) {
            String trustStorePath = (String)connectionParams.get(TRUST_STORE_PATH_KEY);
            String trustStorePassword = (String)connectionParams.get(TRUST_STORE_PASSWORD_KEY);
            if (trustStorePath != null && trustStorePassword != null) {
                System.setProperty("javax.net.ssl.trustStore", trustStorePath);
                System.setProperty("javax.net.ssl.trustStorePassword", trustStorePassword);
                LOGGER.info((Object)("Setting trustStore path: " + trustStorePath + " and trustStorePassword"));
            }
        }
        if (connectionParams.containsKey(KEY_STORE_PATH_KEY) && connectionParams.containsKey(KEY_STORE_PASSWORD_KEY)) {
            String keyStorePath = (String)connectionParams.get(KEY_STORE_PATH_KEY);
            String keyStorePassword = (String)connectionParams.get(KEY_STORE_PASSWORD_KEY);
            if (keyStorePath != null && keyStorePassword != null) {
                System.setProperty("javax.net.ssl.keyStore", keyStorePath);
                System.setProperty("javax.net.ssl.keyStorePassword", keyStorePassword);
                LOGGER.info((Object)("Setting keyStore path: " + keyStorePath + " and keyStorePassword"));
            }
        }
        System.setProperty("sun.rmi.transport.tcp.responseTimeout", this.rmiTimeout);
        this.createConnection();
    }

    private HashMap<String, Object> getEnv(LinkedHashMap<String, Object> connectionParams) {
        HashMap<String, Object> environment = new HashMap<String, Object>();
        if (connectionParams.containsKey("rmi_registry_ssl") && ((Boolean)connectionParams.get("rmi_registry_ssl")).booleanValue()) {
            SslRMIClientSocketFactory csf = new SslRMIClientSocketFactory();
            environment.put("com.sun.jndi.rmi.factory.socket", csf);
            environment.put("jmx.remote.rmi.client.socket.factory", csf);
        }
        environment.put("jmx.remote.credentials", new String[]{this.user, this.password});
        return environment;
    }

    private JMXServiceURL getAddress(LinkedHashMap<String, Object> connectionParams) throws MalformedURLException {
        if (this.jmxUrl != null) {
            return new JMXServiceURL(this.jmxUrl);
        }
        return new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + this.host + ":" + this.port + "/" + this.path);
    }
}

