/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch.reporter;

import com.google.common.base.Joiner;
import java.util.HashMap;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.datadog.jmxfetch.Instance;
import org.datadog.jmxfetch.JMXAttribute;
import org.datadog.jmxfetch.reporter.Reporter;

public class ConsoleReporter
extends Reporter {
    private static final Logger LOGGER = Logger.getLogger((String)ConsoleReporter.class.getName());
    private LinkedList<HashMap<String, Object>> metrics = new LinkedList();
    private LinkedList<HashMap<String, Object>> serviceChecks = new LinkedList();

    @Override
    protected void sendMetricPoint(String metricType, String metricName, double value, String[] tags) {
        String tagString = "[" + Joiner.on((String)",").join((Object[])tags) + "]";
        LOGGER.info((Object)(metricName + tagString + " - " + System.currentTimeMillis() / 1000L + " = " + value));
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("name", metricName);
        m.put("value", value);
        m.put("tags", tags);
        m.put("type", metricType);
        this.metrics.add(m);
    }

    public LinkedList<HashMap<String, Object>> getMetrics() {
        LinkedList<HashMap<String, Object>> returnedMetrics = new LinkedList<HashMap<String, Object>>();
        for (HashMap hashMap : this.metrics) {
            returnedMetrics.add(new HashMap(hashMap));
        }
        this.metrics.clear();
        return returnedMetrics;
    }

    @Override
    public void doSendServiceCheck(String checkName, String status, String message, String[] tags) {
        String tagString = "";
        if (tags != null && tags.length > 0) {
            tagString = "[" + Joiner.on((String)",").join((Object[])tags) + "]";
        }
        LOGGER.info((Object)(checkName + tagString + " - " + System.currentTimeMillis() / 1000L + " = " + status));
        HashMap<String, Object> sc = new HashMap<String, Object>();
        sc.put("name", checkName);
        sc.put("status", status);
        sc.put("message", message);
        sc.put("tags", tags);
        this.serviceChecks.add(sc);
    }

    public LinkedList<HashMap<String, Object>> getServiceChecks() {
        LinkedList<HashMap<String, Object>> returnedServiceChecks = new LinkedList<HashMap<String, Object>>();
        for (HashMap hashMap : this.serviceChecks) {
            returnedServiceChecks.add(new HashMap(hashMap));
        }
        this.serviceChecks.clear();
        return returnedServiceChecks;
    }

    @Override
    public void displayMetricReached() {
        LOGGER.info((Object)"       ------- METRIC LIMIT REACHED: ATTRIBUTES BELOW WON'T BE COLLECTED -------");
    }

    @Override
    public void displayMatchingAttributeName(JMXAttribute jmxAttribute, int rank, int limit) {
        LOGGER.info((Object)("       Matching: " + rank + "/" + limit + ". " + jmxAttribute));
    }

    @Override
    public void displayNonMatchingAttributeName(JMXAttribute jmxAttribute) {
        LOGGER.info((Object)("       Not Matching: " + jmxAttribute));
    }

    @Override
    public void displayInstanceName(Instance instance) {
        LOGGER.info((Object)"#####################################");
        LOGGER.info((Object)("Instance: " + instance));
        LOGGER.info((Object)"#####################################");
    }
}

