/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch;

import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.management.remote.JMXServiceURL;
import org.apache.log4j.Logger;
import org.datadog.jmxfetch.Connection;

public class AttachApiConnection
extends Connection {
    private static final String CONNECTOR_ADDRESS = "com.sun.management.jmxremote.localConnectorAddress";
    private static final Logger LOGGER = Logger.getLogger((String)Connection.class.getName());
    private String processRegex;

    public AttachApiConnection(LinkedHashMap<String, Object> connectionParams) throws IOException {
        this.processRegex = (String)connectionParams.get("process_name_regex");
        this.env = new HashMap();
        this.address = this.getAddress(connectionParams);
        this.createConnection();
    }

    private JMXServiceURL getAddress(LinkedHashMap<String, Object> connectionParams) throws IOException {
        JMXServiceURL address;
        try {
            address = new JMXServiceURL(this.getJMXUrlForProcessRegex(this.processRegex));
        }
        catch (AttachNotSupportedException e) {
            throw new IOException("Unnable to attach to process regex:  " + this.processRegex, e);
        }
        return address;
    }

    private String getJMXUrlForProcessRegex(String processRegex) throws AttachNotSupportedException, IOException {
        for (VirtualMachineDescriptor vmd : VirtualMachine.list()) {
            if (!vmd.displayName().matches(processRegex)) continue;
            VirtualMachine vm = VirtualMachine.attach(vmd);
            String connectorAddress = vm.getAgentProperties().getProperty(CONNECTOR_ADDRESS);
            if (connectorAddress == null) {
                this.loadJMXAgent(vm);
                connectorAddress = vm.getAgentProperties().getProperty(CONNECTOR_ADDRESS);
            }
            return connectorAddress;
        }
        throw new IOException("No match found. Available JVMs can be listed with the `list_jvms` command.");
    }

    private void loadJMXAgent(VirtualMachine vm) throws IOException {
        String agent = vm.getSystemProperties().getProperty("java.home") + File.separator + "lib" + File.separator + "management-agent.jar";
        try {
            vm.loadAgent(agent);
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Error initializing JMX agent", (Throwable)e);
        }
    }
}

