/*
 * Decompiled with CFR 0.152.
 */
package com.timgroup.statsd;

import com.timgroup.statsd.Message;
import com.timgroup.statsd.NumericMessage;
import com.timgroup.statsd.StatsDProcessor;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;

public class Telemetry {
    public static int DEFAULT_FLUSH_INTERVAL = 10000;
    protected final AtomicInteger metricsSent = new AtomicInteger(0);
    protected final AtomicInteger gaugeSent = new AtomicInteger(0);
    protected final AtomicInteger countSent = new AtomicInteger(0);
    protected final AtomicInteger histogramSent = new AtomicInteger(0);
    protected final AtomicInteger distributionSent = new AtomicInteger(0);
    protected final AtomicInteger setSent = new AtomicInteger(0);
    protected final AtomicInteger eventsSent = new AtomicInteger(0);
    protected final AtomicInteger serviceChecksSent = new AtomicInteger(0);
    protected final AtomicInteger bytesSent = new AtomicInteger(0);
    protected final AtomicInteger bytesDropped = new AtomicInteger(0);
    protected final AtomicInteger packetsSent = new AtomicInteger(0);
    protected final AtomicInteger packetsDropped = new AtomicInteger(0);
    protected final AtomicInteger packetsDroppedQueue = new AtomicInteger(0);
    protected final AtomicInteger aggregatedContexts = new AtomicInteger(0);
    protected final AtomicInteger aggregatedGaugeContexts = new AtomicInteger(0);
    protected final AtomicInteger aggregatedCountContexts = new AtomicInteger(0);
    protected final AtomicInteger aggregatedSetContexts = new AtomicInteger(0);
    protected final String metricsSentMetric = "datadog.dogstatsd.client.metrics";
    protected final String metricsByTypeSentMetric = "datadog.dogstatsd.client.metrics_by_type";
    protected final String eventsSentMetric = "datadog.dogstatsd.client.events";
    protected final String serviceChecksSentMetric = "datadog.dogstatsd.client.service_checks";
    protected final String bytesSentMetric = "datadog.dogstatsd.client.bytes_sent";
    protected final String bytesDroppedMetric = "datadog.dogstatsd.client.bytes_dropped";
    protected final String packetsSentMetric = "datadog.dogstatsd.client.packets_sent";
    protected final String packetsDroppedMetric = "datadog.dogstatsd.client.packets_dropped";
    protected final String packetsDroppedQueueMetric = "datadog.dogstatsd.client.packets_dropped_queue";
    protected final String aggregatedContextsMetric = "datadog.dogstatsd.client.aggregated_context";
    protected final String aggregatedContextsByTypeMetric = "datadog.dogstatsd.client.aggregated_context_by_type";
    protected String tags;
    protected StringBuilder tagBuilder = new StringBuilder();
    public StatsDProcessor processor;
    protected Timer timer;

    Telemetry(String tags, StatsDProcessor processor) {
        this.tags = tags;
        this.processor = processor;
        this.timer = null;
    }

    public void start(long flushInterval) {
        this.timer = new Timer(true);
        this.timer.scheduleAtFixedRate((TimerTask)new TelemetryTask(this), flushInterval, flushInterval);
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    public void flush() {
        this.processor.send(new TelemetryMessage(this.metricsSentMetric, this.metricsSent.getAndSet(0), this.tags));
        this.processor.send(new TelemetryMessage(this.eventsSentMetric, this.eventsSent.getAndSet(0), this.tags));
        this.processor.send(new TelemetryMessage(this.serviceChecksSentMetric, this.serviceChecksSent.getAndSet(0), this.tags));
        this.processor.send(new TelemetryMessage(this.bytesSentMetric, this.bytesSent.getAndSet(0), this.tags));
        this.processor.send(new TelemetryMessage(this.bytesDroppedMetric, this.bytesDropped.getAndSet(0), this.tags));
        this.processor.send(new TelemetryMessage(this.packetsSentMetric, this.packetsSent.getAndSet(0), this.tags));
        this.processor.send(new TelemetryMessage(this.packetsDroppedMetric, this.packetsDropped.getAndSet(0), this.tags));
        this.processor.send(new TelemetryMessage(this.packetsDroppedQueueMetric, this.packetsDroppedQueue.getAndSet(0), this.tags));
        this.processor.send(new TelemetryMessage(this.aggregatedContextsMetric, this.aggregatedContexts.getAndSet(0), this.tags));
        this.processor.send(new TelemetryMessage(this.metricsByTypeSentMetric, this.gaugeSent.getAndSet(0), this.getTelemetryTags(this.tags, Message.Type.GAUGE)));
        this.processor.send(new TelemetryMessage(this.metricsByTypeSentMetric, this.countSent.getAndSet(0), this.getTelemetryTags(this.tags, Message.Type.COUNT)));
        this.processor.send(new TelemetryMessage(this.metricsByTypeSentMetric, this.setSent.getAndSet(0), this.getTelemetryTags(this.tags, Message.Type.SET)));
        this.processor.send(new TelemetryMessage(this.metricsByTypeSentMetric, this.histogramSent.getAndSet(0), this.getTelemetryTags(this.tags, Message.Type.HISTOGRAM)));
        this.processor.send(new TelemetryMessage(this.metricsByTypeSentMetric, this.distributionSent.getAndSet(0), this.getTelemetryTags(this.tags, Message.Type.DISTRIBUTION)));
        this.processor.send(new TelemetryMessage(this.aggregatedContextsByTypeMetric, this.aggregatedGaugeContexts.getAndSet(0), this.getTelemetryTags(this.tags, Message.Type.GAUGE)));
        this.processor.send(new TelemetryMessage(this.aggregatedContextsByTypeMetric, this.aggregatedCountContexts.getAndSet(0), this.getTelemetryTags(this.tags, Message.Type.COUNT)));
        this.processor.send(new TelemetryMessage(this.aggregatedContextsByTypeMetric, this.aggregatedSetContexts.getAndSet(0), this.getTelemetryTags(this.tags, Message.Type.SET)));
    }

    protected String getTelemetryTags(String tags, Message.Type type) {
        this.tagBuilder.setLength(0);
        this.tagBuilder.append(tags);
        switch (type) {
            case GAUGE: {
                this.tagBuilder.append(",metrics_type:gauge");
                break;
            }
            case COUNT: {
                this.tagBuilder.append(",metrics_type:count");
                break;
            }
            case SET: {
                this.tagBuilder.append(",metrics_type:set");
                break;
            }
            case HISTOGRAM: {
                this.tagBuilder.append(",metrics_type:histogram");
                break;
            }
            case DISTRIBUTION: {
                this.tagBuilder.append(",metrics_type:distribution");
                break;
            }
        }
        return this.tagBuilder.toString();
    }

    public void incrMetricsSent(int value) {
        this.metricsSent.addAndGet(value);
    }

    public void incrMetricsSent(int value, Message.Type type) {
        this.incrMetricsSent(value);
        switch (type) {
            case GAUGE: {
                this.incrGaugeSent(value);
                break;
            }
            case COUNT: {
                this.incrCountSent(value);
                break;
            }
            case SET: {
                this.incrSetSent(value);
                break;
            }
            case HISTOGRAM: {
                this.incrHistogramSent(value);
                break;
            }
            case DISTRIBUTION: {
                this.incrDistributionSent(value);
                break;
            }
        }
    }

    public void incrGaugeSent(int value) {
        this.gaugeSent.addAndGet(value);
    }

    public void incrCountSent(int value) {
        this.countSent.addAndGet(value);
    }

    public void incrHistogramSent(int value) {
        this.histogramSent.addAndGet(value);
    }

    public void incrDistributionSent(int value) {
        this.distributionSent.addAndGet(value);
    }

    public void incrSetSent(int value) {
        this.setSent.addAndGet(value);
    }

    public void incrEventsSent(int value) {
        this.eventsSent.addAndGet(value);
    }

    public void incrServiceChecksSent(int value) {
        this.serviceChecksSent.addAndGet(value);
    }

    public void incrBytesSent(int value) {
        this.bytesSent.addAndGet(value);
    }

    public void incrBytesDropped(int value) {
        this.bytesDropped.addAndGet(value);
    }

    public void incrPacketSent(int value) {
        this.packetsSent.addAndGet(value);
    }

    public void incrPacketDropped(int value) {
        this.packetsDropped.addAndGet(value);
    }

    public void incrPacketDroppedQueue(int value) {
        this.packetsDroppedQueue.addAndGet(value);
    }

    public void incrAggregatedContexts(int value) {
        this.aggregatedContexts.addAndGet(value);
    }

    public void incrAggregatedGaugeContexts(int value) {
        this.aggregatedGaugeContexts.addAndGet(value);
    }

    public void incrAggregatedCountContexts(int value) {
        this.aggregatedCountContexts.addAndGet(value);
    }

    public void incrAggregatedSetContexts(int value) {
        this.aggregatedSetContexts.addAndGet(value);
    }

    public void reset() {
        this.metricsSent.set(0);
        this.eventsSent.set(0);
        this.serviceChecksSent.set(0);
        this.bytesSent.set(0);
        this.bytesDropped.set(0);
        this.packetsSent.set(0);
        this.packetsDropped.set(0);
        this.packetsDroppedQueue.set(0);
        this.aggregatedContexts.set(0);
        this.gaugeSent.set(0);
        this.countSent.set(0);
        this.histogramSent.set(0);
        this.distributionSent.set(0);
        this.setSent.set(0);
        this.aggregatedGaugeContexts.set(0);
        this.aggregatedCountContexts.set(0);
        this.aggregatedSetContexts.set(0);
    }

    public String getTags() {
        return this.tags;
    }

    public static class Builder {
        private String tags;
        private StatsDProcessor processor;

        public Builder tags(String tags) {
            this.tags = tags;
            return this;
        }

        public Builder processor(StatsDProcessor processor) {
            this.processor = processor;
            return this;
        }

        public Telemetry build() {
            return new Telemetry(this.tags, this.processor);
        }
    }

    class TelemetryMessage
    extends NumericMessage<Integer> {
        private final String tagsString;

        protected TelemetryMessage(String metric, Integer value, String tags) {
            super(metric, Message.Type.COUNT, value, null);
            this.tagsString = tags;
            this.done = true;
        }

        @Override
        public final boolean writeTo(StringBuilder builder, int capacity, String containerID) {
            builder.append(this.aspect).append(':').append(this.value).append('|').append((Object)this.type).append(this.tagsString);
            if (containerID != null && !containerID.isEmpty()) {
                builder.append("|c:").append(containerID);
            }
            builder.append('\n');
            return false;
        }
    }

    protected class TelemetryTask
    extends TimerTask {
        private Telemetry telemetry;

        TelemetryTask(Telemetry telemetry) {
            this.telemetry = telemetry;
        }

        @Override
        public void run() {
            this.telemetry.flush();
        }
    }
}

