/*
 * Decompiled with CFR 0.152.
 */
package com.timgroup.statsd;

import com.timgroup.statsd.AlphaNumericMessage;
import com.timgroup.statsd.BufferPool;
import com.timgroup.statsd.CgroupReader;
import com.timgroup.statsd.ClientChannel;
import com.timgroup.statsd.DatagramClientChannel;
import com.timgroup.statsd.Event;
import com.timgroup.statsd.Message;
import com.timgroup.statsd.NamedPipeClientChannel;
import com.timgroup.statsd.NamedPipeSocketAddress;
import com.timgroup.statsd.NonBlockingStatsDClientBuilder;
import com.timgroup.statsd.NumericMessage;
import com.timgroup.statsd.ServiceCheck;
import com.timgroup.statsd.StatsDBlockingProcessor;
import com.timgroup.statsd.StatsDClient;
import com.timgroup.statsd.StatsDClientErrorHandler;
import com.timgroup.statsd.StatsDClientException;
import com.timgroup.statsd.StatsDNonBlockingProcessor;
import com.timgroup.statsd.StatsDProcessor;
import com.timgroup.statsd.StatsDSender;
import com.timgroup.statsd.StatsDThreadFactory;
import com.timgroup.statsd.Telemetry;
import com.timgroup.statsd.UnixDatagramClientChannel;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;

public class NonBlockingStatsDClient
implements StatsDClient {
    public static final String DD_DOGSTATSD_PORT_ENV_VAR = "DD_DOGSTATSD_PORT";
    public static final String DD_AGENT_HOST_ENV_VAR = "DD_AGENT_HOST";
    public static final String DD_NAMED_PIPE_ENV_VAR = "DD_DOGSTATSD_PIPE_NAME";
    public static final String DD_ENTITY_ID_ENV_VAR = "DD_ENTITY_ID";
    private static final String ENTITY_ID_TAG_NAME = "dd.internal.entity_id";
    public static final String ORIGIN_DETECTION_ENABLED_ENV_VAR = "DD_ORIGIN_DETECTION_ENABLED";
    public static final int DEFAULT_UDP_MAX_PACKET_SIZE_BYTES = 1432;
    public static final int DEFAULT_UDS_MAX_PACKET_SIZE_BYTES = 8192;
    public static final int DEFAULT_QUEUE_SIZE = 4096;
    public static final int DEFAULT_POOL_SIZE = 512;
    public static final int DEFAULT_PROCESSOR_WORKERS = 1;
    public static final int DEFAULT_SENDER_WORKERS = 1;
    public static final int DEFAULT_DOGSTATSD_PORT = 8125;
    public static final int SOCKET_TIMEOUT_MS = 100;
    public static final int SOCKET_BUFFER_BYTES = -1;
    public static final boolean DEFAULT_BLOCKING = false;
    public static final boolean DEFAULT_ENABLE_TELEMETRY = true;
    public static final boolean DEFAULT_ENABLE_AGGREGATION = true;
    public static final boolean DEFAULT_ENABLE_ORIGIN_DETECTION = true;
    public static final String CLIENT_TAG = "client:java";
    public static final String CLIENT_VERSION_TAG = "client_version:";
    public static final String CLIENT_TRANSPORT_TAG = "client_transport:";
    public static final Charset UTF_8 = StandardCharsets.UTF_8;
    private static final StatsDClientErrorHandler NO_OP_HANDLER = new StatsDClientErrorHandler(){

        @Override
        public void handle(Exception ex) {
        }
    };
    protected static final ThreadLocal<NumberFormat> NUMBER_FORMATTER = new ThreadLocal<NumberFormat>(){

        @Override
        protected NumberFormat initialValue() {
            return NonBlockingStatsDClient.newFormatter(false);
        }
    };
    protected static final ThreadLocal<NumberFormat> SAMPLE_RATE_FORMATTER = new ThreadLocal<NumberFormat>(){

        @Override
        protected NumberFormat initialValue() {
            return NonBlockingStatsDClient.newFormatter(true);
        }
    };
    private final String prefix;
    private final ClientChannel clientChannel;
    private final ClientChannel telemetryClientChannel;
    private final StatsDClientErrorHandler handler;
    private final String constantTagsRendered;
    protected final StatsDProcessor statsDProcessor;
    protected StatsDProcessor telemetryStatsDProcessor;
    protected final StatsDSender statsDSender;
    protected StatsDSender telemetryStatsDSender;
    protected final Telemetry telemetry;
    private final boolean blocking;

    private static NumberFormat newFormatter(boolean sampler) {
        NumberFormat numberFormatter = NumberFormat.getInstance(Locale.US);
        numberFormatter.setGroupingUsed(false);
        if (numberFormatter instanceof DecimalFormat) {
            DecimalFormat decimalFormat = (DecimalFormat)numberFormatter;
            DecimalFormatSymbols symbols = decimalFormat.getDecimalFormatSymbols();
            symbols.setNaN("NaN");
            decimalFormat.setDecimalFormatSymbols(symbols);
        }
        if (sampler) {
            numberFormatter.setMinimumFractionDigits(6);
        } else {
            numberFormatter.setMaximumFractionDigits(6);
        }
        return numberFormatter;
    }

    protected static String format(ThreadLocal<NumberFormat> formatter, Number value) {
        return formatter.get().format(value);
    }

    private NonBlockingStatsDClient(String prefix, int queueSize, String[] constantTags, StatsDClientErrorHandler errorHandler, Callable<SocketAddress> addressLookup, Callable<SocketAddress> telemetryAddressLookup, int timeout, int bufferSize, int maxPacketSizeBytes, String entityID, int poolSize, int processorWorkers, int senderWorkers, boolean blocking, boolean enableTelemetry, int telemetryFlushInterval, int aggregationFlushInterval, int aggregationShards, ThreadFactory customThreadFactory, String containerID, boolean originDetectionEnabled) throws StatsDClientException {
        this.prefix = prefix != null && !prefix.isEmpty() ? prefix + "." : "";
        this.handler = errorHandler == null ? NO_OP_HANDLER : errorHandler;
        this.blocking = blocking;
        ArrayList<String> costantPreTags = new ArrayList<String>();
        if (constantTags != null) {
            for (String constantTag : constantTags) {
                costantPreTags.add(constantTag);
            }
        }
        boolean hasEntityID = NonBlockingStatsDClient.updateTagsWithEntityID(costantPreTags, entityID);
        for (Literal literal : Literal.values()) {
            String envVal = literal.envVal();
            if (envVal == null || envVal.trim().isEmpty()) continue;
            costantPreTags.add(literal.tag() + ":" + envVal);
        }
        this.constantTagsRendered = costantPreTags.isEmpty() ? null : NonBlockingStatsDClient.tagString(costantPreTags.toArray(new String[costantPreTags.size()]), null, new StringBuilder()).toString();
        costantPreTags = null;
        if (hasEntityID) {
            containerID = null;
        } else {
            boolean originEnabled = this.isOriginDetectionEnabled(containerID, originDetectionEnabled, hasEntityID);
            containerID = this.getContainerID(containerID, originEnabled);
        }
        try {
            this.clientChannel = this.createByteChannel(addressLookup, timeout, bufferSize);
            ThreadFactory threadFactory = customThreadFactory != null ? customThreadFactory : new StatsDThreadFactory();
            this.statsDProcessor = this.createProcessor(queueSize, this.handler, maxPacketSizeBytes, poolSize, processorWorkers, blocking, aggregationFlushInterval, aggregationShards, threadFactory, containerID);
            Properties properties = new Properties();
            properties.load(this.getClass().getClassLoader().getResourceAsStream("dogstatsd/version.properties"));
            String telemetryTags = this.tagString(new String[]{CLIENT_TRANSPORT_TAG + this.clientChannel.getTransportType(), CLIENT_VERSION_TAG + properties.getProperty("dogstatsd_client_version"), CLIENT_TAG}, new StringBuilder()).toString();
            if (addressLookup == telemetryAddressLookup) {
                this.telemetryClientChannel = this.clientChannel;
                this.telemetryStatsDProcessor = this.statsDProcessor;
            } else {
                this.telemetryClientChannel = this.createByteChannel(telemetryAddressLookup, timeout, bufferSize);
                this.telemetryStatsDProcessor = this.createProcessor(queueSize, this.handler, maxPacketSizeBytes, poolSize, 1, false, 0, aggregationShards, threadFactory, containerID);
            }
            this.telemetry = new Telemetry.Builder().tags(telemetryTags).processor(this.telemetryStatsDProcessor).build();
            this.telemetryStatsDSender = this.statsDSender = this.createSender(this.handler, this.clientChannel, this.statsDProcessor.getBufferPool(), this.statsDProcessor.getOutboundQueue(), senderWorkers, threadFactory);
            if (this.telemetryStatsDProcessor != this.statsDProcessor) {
                this.telemetryStatsDSender = this.createSender(this.handler, this.telemetryClientChannel, this.telemetryStatsDProcessor.getBufferPool(), this.telemetryStatsDProcessor.getOutboundQueue(), 1, threadFactory);
            }
            this.statsDProcessor.setTelemetry(this.telemetry);
            this.statsDSender.setTelemetry(this.telemetry);
        }
        catch (Exception e) {
            throw new StatsDClientException("Failed to start StatsD client", e);
        }
        this.statsDProcessor.startWorkers("StatsD-Processor-");
        this.statsDSender.startWorkers("StatsD-Sender-");
        if (enableTelemetry) {
            if (this.telemetryStatsDProcessor != this.statsDProcessor) {
                this.telemetryStatsDProcessor.startWorkers("StatsD-TelemetryProcessor-");
                this.telemetryStatsDSender.startWorkers("StatsD-TelemetrySender-");
            }
            this.telemetry.start(telemetryFlushInterval);
        }
    }

    public NonBlockingStatsDClient(NonBlockingStatsDClientBuilder builder) throws StatsDClientException {
        this(builder.prefix, builder.queueSize, builder.constantTags, builder.errorHandler, builder.addressLookup, builder.telemetryAddressLookup, builder.timeout, builder.socketBufferSize, builder.maxPacketSizeBytes, builder.entityID, builder.bufferPoolSize, builder.processorWorkers, builder.senderWorkers, builder.blocking, builder.enableTelemetry, builder.telemetryFlushInterval, builder.enableAggregation ? builder.aggregationFlushInterval : 0, builder.aggregationShards, builder.threadFactory, builder.containerID, builder.originDetectionEnabled);
    }

    protected StatsDProcessor createProcessor(int queueSize, StatsDClientErrorHandler handler, int maxPacketSizeBytes, int bufferPoolSize, int workers, boolean blocking, int aggregationFlushInterval, int aggregationShards, ThreadFactory threadFactory, String containerID) throws Exception {
        if (blocking) {
            return new StatsDBlockingProcessor(queueSize, handler, maxPacketSizeBytes, bufferPoolSize, workers, aggregationFlushInterval, aggregationShards, threadFactory, containerID);
        }
        return new StatsDNonBlockingProcessor(queueSize, handler, maxPacketSizeBytes, bufferPoolSize, workers, aggregationFlushInterval, aggregationShards, threadFactory, containerID);
    }

    protected StatsDSender createSender(StatsDClientErrorHandler handler, WritableByteChannel clientChannel, BufferPool pool, BlockingQueue<ByteBuffer> buffers, int senderWorkers, ThreadFactory threadFactory) throws Exception {
        return new StatsDSender(clientChannel, handler, pool, buffers, senderWorkers, threadFactory);
    }

    @Override
    public void stop() {
        try {
            this.telemetry.stop();
            this.statsDProcessor.shutdown(this.blocking);
            this.statsDSender.shutdown(this.blocking);
            if (this.telemetryStatsDProcessor != this.statsDProcessor) {
                this.telemetryStatsDProcessor.shutdown(false);
                this.telemetryStatsDSender.shutdown(false);
            }
        }
        catch (Exception e) {
            this.handler.handle(e);
        }
        finally {
            if (this.clientChannel != null) {
                try {
                    this.clientChannel.close();
                }
                catch (IOException e) {
                    this.handler.handle(e);
                }
            }
            if (this.telemetryClientChannel != null && this.telemetryClientChannel != this.clientChannel) {
                try {
                    this.telemetryClientChannel.close();
                }
                catch (IOException e) {
                    this.handler.handle(e);
                }
            }
        }
    }

    @Override
    public void close() {
        this.stop();
    }

    static StringBuilder tagString(String[] tags, String tagPrefix, StringBuilder sb) {
        if (tagPrefix != null) {
            sb.append(tagPrefix);
            if (tags == null || tags.length == 0) {
                return sb;
            }
            sb.append(',');
        } else {
            if (tags == null || tags.length == 0) {
                return sb;
            }
            sb.append("|#");
        }
        for (int n = tags.length - 1; n >= 0; --n) {
            sb.append(tags[n]);
            if (n <= 0) continue;
            sb.append(',');
        }
        return sb;
    }

    StringBuilder tagString(String[] tags, StringBuilder builder) {
        return NonBlockingStatsDClient.tagString(tags, this.constantTagsRendered, builder);
    }

    ClientChannel createByteChannel(Callable<SocketAddress> addressLookup, int timeout, int bufferSize) throws Exception {
        SocketAddress address = addressLookup.call();
        if (address instanceof NamedPipeSocketAddress) {
            return new NamedPipeClientChannel((NamedPipeSocketAddress)address);
        }
        try {
            if (Class.forName("jnr.unixsocket.UnixSocketAddress").isInstance(address)) {
                return new UnixDatagramClientChannel(address, timeout, bufferSize);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return new DatagramClientChannel(address);
    }

    private boolean sendMetric(Message message) {
        return this.send(message);
    }

    private boolean send(Message message) {
        boolean success = this.statsDProcessor.send(message);
        if (success) {
            this.telemetry.incrMetricsSent(1, message.getType());
        } else {
            this.telemetry.incrPacketDroppedQueue(1);
        }
        return success;
    }

    private void send(String aspect, double value, Message.Type type, double sampleRate, String[] tags) {
        if (this.statsDProcessor.getAggregator().getFlushInterval() != 0L && !Double.isNaN(sampleRate)) {
            switch (type) {
                case COUNT: {
                    sampleRate = Double.NaN;
                    break;
                }
            }
        }
        if (Double.isNaN(sampleRate) || !this.isInvalidSample(sampleRate)) {
            this.sendMetric(new StatsDMessage<Double>(aspect, type, Double.valueOf(value), sampleRate, tags){

                @Override
                protected void writeValue(StringBuilder builder) {
                    builder.append(NonBlockingStatsDClient.format(NUMBER_FORMATTER, this.value));
                }
            });
        }
    }

    private void send(String aspect, double value, Message.Type type, String[] tags) {
        this.send(aspect, value, type, Double.NaN, tags);
    }

    private void send(String aspect, long value, Message.Type type, double sampleRate, String[] tags) {
        if (this.statsDProcessor.getAggregator().getFlushInterval() != 0L && !Double.isNaN(sampleRate)) {
            switch (type) {
                case COUNT: {
                    sampleRate = Double.NaN;
                    break;
                }
            }
        }
        if (Double.isNaN(sampleRate) || !this.isInvalidSample(sampleRate)) {
            this.sendMetric(new StatsDMessage<Long>(aspect, type, Long.valueOf(value), sampleRate, tags){

                @Override
                protected void writeValue(StringBuilder builder) {
                    builder.append(this.value);
                }
            });
        }
    }

    private void send(String aspect, long value, Message.Type type, String[] tags) {
        this.send(aspect, value, type, Double.NaN, tags);
    }

    @Override
    public void count(String aspect, long delta, String ... tags) {
        this.send(aspect, delta, Message.Type.COUNT, tags);
    }

    @Override
    public void count(String aspect, long delta, double sampleRate, String ... tags) {
        this.send(aspect, delta, Message.Type.COUNT, sampleRate, tags);
    }

    @Override
    public void count(String aspect, double delta, String ... tags) {
        this.send(aspect, delta, Message.Type.COUNT, tags);
    }

    @Override
    public void count(String aspect, double delta, double sampleRate, String ... tags) {
        this.send(aspect, delta, Message.Type.COUNT, sampleRate, tags);
    }

    @Override
    public void incrementCounter(String aspect, String ... tags) {
        this.count(aspect, 1L, tags);
    }

    @Override
    public void incrementCounter(String aspect, double sampleRate, String ... tags) {
        this.count(aspect, 1L, sampleRate, tags);
    }

    @Override
    public void increment(String aspect, String ... tags) {
        this.incrementCounter(aspect, tags);
    }

    @Override
    public void increment(String aspect, double sampleRate, String ... tags) {
        this.incrementCounter(aspect, sampleRate, tags);
    }

    @Override
    public void decrementCounter(String aspect, String ... tags) {
        this.count(aspect, -1L, tags);
    }

    @Override
    public void decrementCounter(String aspect, double sampleRate, String ... tags) {
        this.count(aspect, -1L, sampleRate, tags);
    }

    @Override
    public void decrement(String aspect, String ... tags) {
        this.decrementCounter(aspect, tags);
    }

    @Override
    public void decrement(String aspect, double sampleRate, String ... tags) {
        this.decrementCounter(aspect, sampleRate, tags);
    }

    @Override
    public void recordGaugeValue(String aspect, double value, String ... tags) {
        this.send(aspect, value, Message.Type.GAUGE, tags);
    }

    @Override
    public void recordGaugeValue(String aspect, double value, double sampleRate, String ... tags) {
        this.send(aspect, value, Message.Type.GAUGE, sampleRate, tags);
    }

    @Override
    public void recordGaugeValue(String aspect, long value, String ... tags) {
        this.send(aspect, value, Message.Type.GAUGE, tags);
    }

    @Override
    public void recordGaugeValue(String aspect, long value, double sampleRate, String ... tags) {
        this.send(aspect, value, Message.Type.GAUGE, sampleRate, tags);
    }

    @Override
    public void gauge(String aspect, double value, String ... tags) {
        this.recordGaugeValue(aspect, value, tags);
    }

    @Override
    public void gauge(String aspect, double value, double sampleRate, String ... tags) {
        this.recordGaugeValue(aspect, value, sampleRate, tags);
    }

    @Override
    public void gauge(String aspect, long value, String ... tags) {
        this.recordGaugeValue(aspect, value, tags);
    }

    @Override
    public void gauge(String aspect, long value, double sampleRate, String ... tags) {
        this.recordGaugeValue(aspect, value, sampleRate, tags);
    }

    @Override
    public void recordExecutionTime(String aspect, long timeInMs, String ... tags) {
        this.send(aspect, timeInMs, Message.Type.TIME, tags);
    }

    @Override
    public void recordExecutionTime(String aspect, long timeInMs, double sampleRate, String ... tags) {
        this.send(aspect, timeInMs, Message.Type.TIME, sampleRate, tags);
    }

    @Override
    public void time(String aspect, long value, String ... tags) {
        this.recordExecutionTime(aspect, value, tags);
    }

    @Override
    public void time(String aspect, long value, double sampleRate, String ... tags) {
        this.recordExecutionTime(aspect, value, sampleRate, tags);
    }

    @Override
    public void recordHistogramValue(String aspect, double value, String ... tags) {
        this.send(aspect, value, Message.Type.HISTOGRAM, tags);
    }

    @Override
    public void recordHistogramValue(String aspect, double value, double sampleRate, String ... tags) {
        this.send(aspect, value, Message.Type.HISTOGRAM, sampleRate, tags);
    }

    @Override
    public void recordHistogramValue(String aspect, long value, String ... tags) {
        this.send(aspect, value, Message.Type.HISTOGRAM, tags);
    }

    @Override
    public void recordHistogramValue(String aspect, long value, double sampleRate, String ... tags) {
        this.send(aspect, value, Message.Type.HISTOGRAM, sampleRate, tags);
    }

    @Override
    public void histogram(String aspect, double value, String ... tags) {
        this.recordHistogramValue(aspect, value, tags);
    }

    @Override
    public void histogram(String aspect, double value, double sampleRate, String ... tags) {
        this.recordHistogramValue(aspect, value, sampleRate, tags);
    }

    @Override
    public void histogram(String aspect, long value, String ... tags) {
        this.recordHistogramValue(aspect, value, tags);
    }

    @Override
    public void histogram(String aspect, long value, double sampleRate, String ... tags) {
        this.recordHistogramValue(aspect, value, sampleRate, tags);
    }

    @Override
    public void recordDistributionValue(String aspect, double value, String ... tags) {
        this.send(aspect, value, Message.Type.DISTRIBUTION, tags);
    }

    @Override
    public void recordDistributionValue(String aspect, double value, double sampleRate, String ... tags) {
        this.send(aspect, value, Message.Type.DISTRIBUTION, sampleRate, tags);
    }

    @Override
    public void recordDistributionValue(String aspect, long value, String ... tags) {
        this.send(aspect, value, Message.Type.DISTRIBUTION, tags);
    }

    @Override
    public void recordDistributionValue(String aspect, long value, double sampleRate, String ... tags) {
        this.send(aspect, value, Message.Type.DISTRIBUTION, sampleRate, tags);
    }

    @Override
    public void distribution(String aspect, double value, String ... tags) {
        this.recordDistributionValue(aspect, value, tags);
    }

    @Override
    public void distribution(String aspect, double value, double sampleRate, String ... tags) {
        this.recordDistributionValue(aspect, value, sampleRate, tags);
    }

    @Override
    public void distribution(String aspect, long value, String ... tags) {
        this.recordDistributionValue(aspect, value, tags);
    }

    @Override
    public void distribution(String aspect, long value, double sampleRate, String ... tags) {
        this.recordDistributionValue(aspect, value, sampleRate, tags);
    }

    private StringBuilder eventMap(Event event, StringBuilder res) {
        String sourceTypeName;
        String alertType;
        String priority;
        String aggregationKey;
        String hostname;
        long millisSinceEpoch = event.getMillisSinceEpoch();
        if (millisSinceEpoch != -1L) {
            res.append("|d:").append(millisSinceEpoch / 1000L);
        }
        if ((hostname = event.getHostname()) != null) {
            res.append("|h:").append(hostname);
        }
        if ((aggregationKey = event.getAggregationKey()) != null) {
            res.append("|k:").append(aggregationKey);
        }
        if ((priority = event.getPriority()) != null) {
            res.append("|p:").append(priority);
        }
        if ((alertType = event.getAlertType()) != null) {
            res.append("|t:").append(alertType);
        }
        if ((sourceTypeName = event.getSourceTypeName()) != null) {
            res.append("|s:").append(sourceTypeName);
        }
        return res;
    }

    @Override
    public void recordEvent(final Event event, final String ... eventTags) {
        this.statsDProcessor.send(new AlphaNumericMessage(Message.Type.EVENT, ""){

            @Override
            public void writeTo(StringBuilder builder, String containerID) {
                String title = NonBlockingStatsDClient.escapeEventString(NonBlockingStatsDClient.this.prefix + event.getTitle());
                String text = NonBlockingStatsDClient.escapeEventString(event.getText());
                builder.append(Message.Type.EVENT.toString()).append("{").append(NonBlockingStatsDClient.this.getUtf8Length(title)).append(",").append(NonBlockingStatsDClient.this.getUtf8Length(text)).append("}:").append(title).append("|");
                if (text != null) {
                    builder.append(text);
                }
                NonBlockingStatsDClient.this.eventMap(event, builder);
                NonBlockingStatsDClient.this.tagString(eventTags, builder);
                if (containerID != null && !containerID.isEmpty()) {
                    builder.append("|c:").append(containerID);
                }
                builder.append('\n');
            }
        });
        this.telemetry.incrEventsSent(1);
    }

    private static String escapeEventString(String title) {
        if (title == null) {
            return null;
        }
        return title.replace("\n", "\\n");
    }

    private int getUtf8Length(String text) {
        if (text == null) {
            return 0;
        }
        return text.getBytes(UTF_8).length;
    }

    @Override
    public void recordServiceCheckRun(final ServiceCheck sc) {
        this.statsDProcessor.send(new AlphaNumericMessage(Message.Type.SERVICE_CHECK, ""){

            @Override
            public void writeTo(StringBuilder sb, String containerID) {
                sb.append(Message.Type.SERVICE_CHECK.toString()).append("|").append(sc.getName()).append("|").append(sc.getStatus());
                if (sc.getTimestamp() > 0) {
                    sb.append("|d:").append(sc.getTimestamp());
                }
                if (sc.getHostname() != null) {
                    sb.append("|h:").append(sc.getHostname());
                }
                NonBlockingStatsDClient.this.tagString(sc.getTags(), sb);
                if (sc.getMessage() != null) {
                    sb.append("|m:").append(sc.getEscapedMessage());
                }
                if (containerID != null && !containerID.isEmpty()) {
                    sb.append("|c:").append(containerID);
                }
                sb.append('\n');
            }
        });
        this.telemetry.incrServiceChecksSent(1);
    }

    private static boolean updateTagsWithEntityID(List<String> tags, String entityID) {
        if (entityID == null || entityID.trim().isEmpty()) {
            entityID = System.getenv(DD_ENTITY_ID_ENV_VAR);
        }
        if (entityID != null && !entityID.trim().isEmpty()) {
            String entityTag = "dd.internal.entity_id:" + entityID;
            return tags.add(entityTag);
        }
        return false;
    }

    @Override
    public void serviceCheck(ServiceCheck sc) {
        this.recordServiceCheckRun(sc);
    }

    @Override
    public void recordSetValue(String aspect, String val, String ... tags) {
        this.statsDProcessor.send(new AlphaNumericMessage(aspect, Message.Type.SET, val, tags){

            protected void writeValue(StringBuilder builder) {
                builder.append(this.getValue());
            }

            @Override
            protected final void writeTo(StringBuilder builder, String containerID) {
                builder.append(NonBlockingStatsDClient.this.prefix).append(this.aspect).append(':');
                this.writeValue(builder);
                builder.append('|').append((Object)this.type);
                NonBlockingStatsDClient.this.tagString(this.tags, builder);
                if (containerID != null && !containerID.isEmpty()) {
                    builder.append("|c:").append(containerID);
                }
                builder.append('\n');
            }
        });
    }

    protected boolean isInvalidSample(double sampleRate) {
        return sampleRate != 1.0 && ThreadLocalRandom.current().nextDouble() > sampleRate;
    }

    boolean isOriginDetectionEnabled(String containerID, boolean originDetectionEnabled, boolean hasEntityID) {
        if (!originDetectionEnabled || hasEntityID || containerID != null && !containerID.isEmpty()) {
            return false;
        }
        String value = System.getenv(ORIGIN_DETECTION_ENABLED_ENV_VAR);
        String string = value = value != null ? value.trim() : null;
        if (value != null && !value.isEmpty()) {
            return !Arrays.asList("no", "false", "0", "n", "off").contains(value.toLowerCase());
        }
        return true;
    }

    private String getContainerID(String containerID, boolean originDetectionEnabled) {
        if (containerID != null && !containerID.isEmpty()) {
            return containerID;
        }
        if (originDetectionEnabled) {
            CgroupReader reader = new CgroupReader();
            try {
                return reader.getContainerID();
            }
            catch (IOException e) {
                throw new StatsDClientException("Failed to get container ID", e);
            }
        }
        return null;
    }

    abstract class StatsDMessage<T extends Number>
    extends NumericMessage<T> {
        final double sampleRate;
        final /* synthetic */ NonBlockingStatsDClient this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        protected StatsDMessage(String value, Message.Type sampleRate, T t, double tags, String[] stringArray) {
            void aspect;
            this.this$0 = (NonBlockingStatsDClient)this$0;
            super((String)aspect, (Message.Type)type, value, (String[])tags);
            this.sampleRate = sampleRate;
        }

        @Override
        public final void writeTo(StringBuilder builder, String containerID) {
            builder.append(this.this$0.prefix).append(this.aspect).append(':');
            this.writeValue(builder);
            builder.append('|').append((Object)this.type);
            if (!Double.isNaN(this.sampleRate)) {
                builder.append('|').append('@').append(NonBlockingStatsDClient.format(SAMPLE_RATE_FORMATTER, this.sampleRate));
            }
            this.this$0.tagString(this.tags, builder);
            if (containerID != null && !containerID.isEmpty()) {
                builder.append("|c:").append(containerID);
            }
            builder.append('\n');
        }

        protected abstract void writeValue(StringBuilder var1);
    }

    static enum Literal {
        SERVICE,
        ENV,
        VERSION;

        private static final String PREFIX = "dd";

        String envName() {
            return ("dd_" + this.toString()).toUpperCase();
        }

        String envVal() {
            return System.getenv(this.envName());
        }

        String tag() {
            return this.toString().toLowerCase();
        }
    }
}

