/*
 * Decompiled with CFR 0.152.
 */
package com.timgroup.statsd;

import com.timgroup.statsd.BufferPool;
import com.timgroup.statsd.Message;
import com.timgroup.statsd.StatsDAggregator;
import com.timgroup.statsd.StatsDClientErrorHandler;
import com.timgroup.statsd.Telemetry;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public abstract class StatsDProcessor {
    protected static final Charset MESSAGE_CHARSET = Charset.forName("UTF-8");
    protected static final String MESSAGE_TOO_LONG = "Message longer than size of sendBuffer";
    protected static final int WAIT_SLEEP_MS = 10;
    protected final StatsDClientErrorHandler handler;
    protected final BufferPool bufferPool;
    protected final Queue<Message> highPrioMessages;
    protected final BlockingQueue<ByteBuffer> outboundQueue;
    protected final CountDownLatch endSignal;
    protected final ThreadFactory threadFactory;
    protected final Thread[] workers;
    protected final int qcapacity;
    protected StatsDAggregator aggregator;
    protected volatile Telemetry telemetry;
    protected volatile boolean shutdown;

    StatsDProcessor(int queueSize, StatsDClientErrorHandler handler, int maxPacketSizeBytes, int poolSize, int workers, int aggregatorFlushInterval, int aggregatorShards, ThreadFactory threadFactory) throws Exception {
        this.handler = handler;
        this.threadFactory = threadFactory;
        this.workers = new Thread[workers];
        this.qcapacity = queueSize;
        this.bufferPool = new BufferPool(poolSize, maxPacketSizeBytes, true);
        this.highPrioMessages = new ConcurrentLinkedQueue<Message>();
        this.outboundQueue = new ArrayBlockingQueue<ByteBuffer>(poolSize);
        this.endSignal = new CountDownLatch(workers);
        this.aggregator = new StatsDAggregator(this, aggregatorShards, aggregatorFlushInterval);
    }

    protected abstract ProcessingTask createProcessingTask();

    protected abstract boolean send(Message var1);

    protected boolean sendHighPrio(Message message) {
        if (!this.shutdown) {
            this.highPrioMessages.offer(message);
            return true;
        }
        return false;
    }

    public BufferPool getBufferPool() {
        return this.bufferPool;
    }

    public BlockingQueue<ByteBuffer> getOutboundQueue() {
        return this.outboundQueue;
    }

    public int getQcapacity() {
        return this.qcapacity;
    }

    void startWorkers(String namePrefix) {
        this.aggregator.start();
        for (int i = 0; i < this.workers.length; ++i) {
            this.workers[i] = this.threadFactory.newThread(this.createProcessingTask());
            this.workers[i].setName(namePrefix + (i + 1));
            this.workers[i].start();
        }
    }

    public StatsDAggregator getAggregator() {
        return this.aggregator;
    }

    public void setTelemetry(Telemetry telemetry) {
        this.telemetry = telemetry;
    }

    public Telemetry getTelemetry() {
        return this.telemetry;
    }

    void shutdown() {
        this.shutdown = true;
        this.aggregator.stop();
        for (int i = 0; i < this.workers.length; ++i) {
            this.workers[i].interrupt();
        }
    }

    boolean awaitUntil(long deadline) {
        while (true) {
            long remaining = deadline - System.currentTimeMillis();
            try {
                return this.endSignal.await(remaining, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    protected abstract class ProcessingTask
    implements Runnable {
        protected StringBuilder builder = new StringBuilder();
        protected CharBuffer buffer = CharBuffer.wrap(this.builder);
        protected final CharsetEncoder utf8Encoder = MESSAGE_CHARSET.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);

        protected ProcessingTask() {
        }

        @Override
        public final void run() {
            try {
                this.processLoop();
            }
            finally {
                StatsDProcessor.this.endSignal.countDown();
            }
        }

        protected abstract void processLoop();

        protected void writeBuilderToSendBuffer(ByteBuffer sendBuffer) {
            int length = this.builder.length();
            if (length <= this.buffer.capacity()) {
                this.buffer.limit(length).position(0);
            } else {
                this.buffer = CharBuffer.wrap(this.builder);
            }
            if (this.utf8Encoder.encode(this.buffer, sendBuffer, true) == CoderResult.OVERFLOW) {
                throw new BufferOverflowException();
            }
        }
    }
}

