/*
 * Decompiled with CFR 0.152.
 */
package com.timgroup.statsd;

import com.timgroup.statsd.Message;
import com.timgroup.statsd.StatsDProcessor;
import com.timgroup.statsd.Telemetry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

public class StatsDAggregator {
    public static int DEFAULT_FLUSH_INTERVAL = 2000;
    public static int DEFAULT_SHARDS = 4;
    protected final String AGGREGATOR_THREAD_NAME = "statsd-aggregator-thread";
    protected final Set<Message.Type> aggregateSet = new HashSet<Message.Type>(Arrays.asList(Message.Type.COUNT, Message.Type.GAUGE, Message.Type.SET));
    protected final ArrayList<Map<Message, Message>> aggregateMetrics;
    protected final int shardGranularity;
    protected final long flushInterval;
    private final StatsDProcessor processor;
    protected Timer scheduler = null;
    private Telemetry telemetry;

    public StatsDAggregator(StatsDProcessor processor, int shards, long flushInterval) {
        this.processor = processor;
        this.flushInterval = flushInterval;
        this.shardGranularity = shards;
        this.aggregateMetrics = new ArrayList(shards);
        if (flushInterval > 0L) {
            this.scheduler = new Timer("statsd-aggregator-thread", true);
        }
        for (int i = 0; i < this.shardGranularity; ++i) {
            this.aggregateMetrics.add(i, new HashMap());
        }
    }

    public void start() {
        if (this.flushInterval > 0L) {
            this.telemetry = this.processor.getTelemetry();
            this.scheduler.scheduleAtFixedRate((TimerTask)new FlushTask(), this.flushInterval, this.flushInterval);
        }
    }

    public void stop() {
        if (this.flushInterval > 0L) {
            this.scheduler.cancel();
        }
    }

    public boolean isTypeAggregate(Message.Type type) {
        return this.aggregateSet.contains((Object)type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean aggregateMessage(Message message) {
        Map<Message, Message> map;
        if (this.flushInterval == 0L || !this.isTypeAggregate(message.getType()) || message.getDone()) {
            return false;
        }
        int hash = message.hashCode();
        int bucket = Math.abs(hash % this.shardGranularity);
        Map<Message, Message> map2 = map = this.aggregateMetrics.get(bucket);
        synchronized (map2) {
            if (!map.containsKey(message)) {
                map.put(message, message);
            } else {
                Message msg = map.get(message);
                msg.aggregate(message);
                if (this.telemetry != null) {
                    this.telemetry.incrAggregatedContexts(1);
                    switch (message.getType()) {
                        case GAUGE: {
                            this.telemetry.incrAggregatedGaugeContexts(1);
                            break;
                        }
                        case COUNT: {
                            this.telemetry.incrAggregatedCountContexts(1);
                            break;
                        }
                        case SET: {
                            this.telemetry.incrAggregatedSetContexts(1);
                            break;
                        }
                    }
                }
            }
        }
        return true;
    }

    public final long getFlushInterval() {
        return this.flushInterval;
    }

    public final int getShardGranularity() {
        return this.shardGranularity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flush() {
        for (int i = 0; i < this.shardGranularity; ++i) {
            Map<Message, Message> map;
            Map<Message, Message> map2 = map = this.aggregateMetrics.get(i);
            synchronized (map2) {
                Iterator<Map.Entry<Message, Message>> iter = map.entrySet().iterator();
                while (iter.hasNext()) {
                    Message msg = iter.next().getValue();
                    msg.setDone(true);
                    if (!this.processor.sendHighPrio(msg) && this.telemetry != null) {
                        this.telemetry.incrPacketDroppedQueue(1);
                    }
                    iter.remove();
                }
                continue;
            }
        }
    }

    private class FlushTask
    extends TimerTask {
        private FlushTask() {
        }

        @Override
        public void run() {
            StatsDAggregator.this.flush();
        }
    }
}

