/*
 * Decompiled with CFR 0.152.
 */
package com.timgroup.statsd;

import com.timgroup.statsd.Message;
import com.timgroup.statsd.NumericMessage;
import com.timgroup.statsd.StatsDProcessor;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;

public class Telemetry {
    public static int DEFAULT_FLUSH_INTERVAL = 10000;
    protected final AtomicInteger metricsSent = new AtomicInteger(0);
    protected final AtomicInteger eventsSent = new AtomicInteger(0);
    protected final AtomicInteger serviceChecksSent = new AtomicInteger(0);
    protected final AtomicInteger bytesSent = new AtomicInteger(0);
    protected final AtomicInteger bytesDropped = new AtomicInteger(0);
    protected final AtomicInteger packetsSent = new AtomicInteger(0);
    protected final AtomicInteger packetsDropped = new AtomicInteger(0);
    protected final AtomicInteger packetsDroppedQueue = new AtomicInteger(0);
    protected final AtomicInteger aggregatedContexts = new AtomicInteger(0);
    protected final String metricsSentMetric = "datadog.dogstatsd.client.metrics";
    protected final String eventsSentMetric = "datadog.dogstatsd.client.events";
    protected final String serviceChecksSentMetric = "datadog.dogstatsd.client.service_checks";
    protected final String bytesSentMetric = "datadog.dogstatsd.client.bytes_sent";
    protected final String bytesDroppedMetric = "datadog.dogstatsd.client.bytes_dropped";
    protected final String packetsSentMetric = "datadog.dogstatsd.client.packets_sent";
    protected final String packetsDroppedMetric = "datadog.dogstatsd.client.packets_dropped";
    protected final String packetsDroppedQueueMetric = "datadog.dogstatsd.client.packets_dropped_queue";
    protected final String aggregatedContextsMetric = "datadog.dogstatsd.client.aggregated_context";
    protected String tags;
    public StatsDProcessor processor;
    protected Timer timer;

    Telemetry(String tags, StatsDProcessor processor) {
        this.tags = tags;
        this.processor = processor;
        this.timer = null;
    }

    public void start(long flushInterval) {
        this.timer = new Timer(true);
        this.timer.scheduleAtFixedRate((TimerTask)new TelemetryTask(this), flushInterval, flushInterval);
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    public void flush() {
        this.processor.send(new TelemetryMessage(this.metricsSentMetric, this.metricsSent.getAndSet(0), this.tags));
        this.processor.send(new TelemetryMessage(this.eventsSentMetric, this.eventsSent.getAndSet(0), this.tags));
        this.processor.send(new TelemetryMessage(this.serviceChecksSentMetric, this.serviceChecksSent.getAndSet(0), this.tags));
        this.processor.send(new TelemetryMessage(this.bytesSentMetric, this.bytesSent.getAndSet(0), this.tags));
        this.processor.send(new TelemetryMessage(this.bytesDroppedMetric, this.bytesDropped.getAndSet(0), this.tags));
        this.processor.send(new TelemetryMessage(this.packetsSentMetric, this.packetsSent.getAndSet(0), this.tags));
        this.processor.send(new TelemetryMessage(this.packetsDroppedMetric, this.packetsDropped.getAndSet(0), this.tags));
        this.processor.send(new TelemetryMessage(this.packetsDroppedQueueMetric, this.packetsDroppedQueue.getAndSet(0), this.tags));
        this.processor.send(new TelemetryMessage(this.aggregatedContextsMetric, this.aggregatedContexts.getAndSet(0), this.tags));
    }

    public void incrMetricsSent(int value) {
        this.metricsSent.addAndGet(value);
    }

    public void incrEventsSent(int value) {
        this.eventsSent.addAndGet(value);
    }

    public void incrServiceChecksSent(int value) {
        this.serviceChecksSent.addAndGet(value);
    }

    public void incrBytesSent(int value) {
        this.bytesSent.addAndGet(value);
    }

    public void incrBytesDropped(int value) {
        this.bytesDropped.addAndGet(value);
    }

    public void incrPacketSent(int value) {
        this.packetsSent.addAndGet(value);
    }

    public void incrPacketDropped(int value) {
        this.packetsDropped.addAndGet(value);
    }

    public void incrPacketDroppedQueue(int value) {
        this.packetsDroppedQueue.addAndGet(value);
    }

    public void incrAggregatedContexts(int value) {
        this.aggregatedContexts.addAndGet(value);
    }

    public void reset() {
        this.metricsSent.set(0);
        this.eventsSent.set(0);
        this.serviceChecksSent.set(0);
        this.bytesSent.set(0);
        this.bytesDropped.set(0);
        this.packetsSent.set(0);
        this.packetsDropped.set(0);
        this.packetsDroppedQueue.set(0);
        this.aggregatedContexts.set(0);
    }

    public String getTags() {
        return this.tags;
    }

    class TelemetryMessage
    extends NumericMessage<Integer> {
        private final String tagsString;

        protected TelemetryMessage(String metric, Integer value, String tags) {
            super(metric, Message.Type.COUNT, value, null);
            this.tagsString = tags;
            this.done = true;
        }

        @Override
        public final void writeTo(StringBuilder builder) {
            builder.append(this.aspect).append(':').append(this.value).append('|').append((Object)this.type).append(this.tagsString);
        }
    }

    protected class TelemetryTask
    extends TimerTask {
        private Telemetry telemetry;

        TelemetryTask(Telemetry telemetry) {
            this.telemetry = telemetry;
        }

        @Override
        public void run() {
            this.telemetry.flush();
        }
    }
}

