/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.traceinterceptor;

import datadog.trace.api.Config;
import datadog.trace.api.interceptor.AbstractTraceInterceptor;
import datadog.trace.api.interceptor.MutableSpan;
import datadog.trace.api.interceptor.TraceInterceptor;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LatencyTraceInterceptor
extends AbstractTraceInterceptor {
    private static final Logger log = LoggerFactory.getLogger(LatencyTraceInterceptor.class);
    private static final long LATENCY = (long)Config.get().getTraceKeepLatencyThreshold() * 1000000L;
    public static final TraceInterceptor INSTANCE = new LatencyTraceInterceptor(AbstractTraceInterceptor.Priority.ROOT_SPAN_LATENCY);

    protected LatencyTraceInterceptor(AbstractTraceInterceptor.Priority priority) {
        super(priority);
    }

    public Collection<? extends MutableSpan> onTraceComplete(Collection<? extends MutableSpan> latencyTrace) {
        if (latencyTrace.isEmpty()) {
            return latencyTrace;
        }
        MutableSpan rootSpan = latencyTrace.iterator().next().getLocalRootSpan();
        if (rootSpan != null && rootSpan.getDurationNano() > LATENCY) {
            rootSpan.setTag("manual.keep", true);
        }
        return latencyTrace;
    }
}

