/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.scopemanager;

import ddtrot.dd.context.Context;
import ddtrot.dd.context.ContextKey;
import ddtrot.dd.trace.bootstrap.instrumentation.api.ProfilingContextIntegration;
import ddtrot.dd.trace.core.scopemanager.ContinuableScope;
import ddtrot.dd.trace.core.scopemanager.ScopeStack;
import javax.annotation.Nullable;

final class ScopeContext
implements Context {
    private final Thread originalThread = Thread.currentThread();
    private final ScopeStack scopeStack;
    private final ContinuableScope parent;
    private final ContinuableScope active;
    private final Context context;

    ScopeContext(ScopeStack scopeStack) {
        this(scopeStack, scopeStack.top != null ? scopeStack.top.context : Context.root());
    }

    private ScopeContext(ScopeStack scopeStack, Context context) {
        this.scopeStack = scopeStack;
        this.parent = scopeStack.parent();
        this.active = scopeStack.active();
        this.context = context;
    }

    ScopeStack restore(ProfilingContextIntegration profilingContextIntegration) {
        if (Thread.currentThread() == this.originalThread) {
            return this.scopeStack;
        }
        return new ScopeStack(profilingContextIntegration, this.parent, this.active);
    }

    @Override
    @Nullable
    public <T> T get(ContextKey<T> key) {
        return this.context.get(key);
    }

    @Override
    public <T> Context with(ContextKey<T> key, @Nullable T value) {
        return this.context.with(key, value);
    }
}

