/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.propagation;

import datadog.trace.api.Config;
import ddtrot.dd.context.Context;
import ddtrot.dd.context.propagation.CarrierSetter;
import ddtrot.dd.context.propagation.CarrierVisitor;
import ddtrot.dd.context.propagation.Propagator;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpan;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpanContext;
import ddtrot.dd.trace.core.DDSpanContext;
import ddtrot.dd.trace.core.propagation.HttpCodec;
import ddtrot.dd.trace.core.propagation.XRayHttpCodec;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class XRayPropagator
implements Propagator {
    private final HttpCodec.Injector injector;

    public XRayPropagator(Config config) {
        this.injector = XRayHttpCodec.newInjector(config.getBaggageMapping());
    }

    @Override
    public <C> void inject(Context context, C carrier, CarrierSetter<C> setter) {
        AgentSpan span;
        if (context == null || carrier == null || setter == null || (span = AgentSpan.fromContext(context)) == null) {
            return;
        }
        AgentSpanContext spanContext = span.context();
        if (spanContext instanceof DDSpanContext) {
            DDSpanContext ddSpanContext = (DDSpanContext)spanContext;
            ddSpanContext.getTraceCollector().setSamplingPriorityIfNecessary();
            this.injector.inject(ddSpanContext, carrier, setter);
        }
    }

    @Override
    public <C> Context extract(Context context, C carrier, CarrierVisitor<C> visitor) {
        return context;
    }
}

