/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.propagation;

import ddtrot.dd.context.Context;
import ddtrot.dd.context.propagation.CarrierSetter;
import ddtrot.dd.context.propagation.CarrierVisitor;
import ddtrot.dd.context.propagation.Propagator;
import ddtrot.dd.trace.api.gateway.InferredProxySpan;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class InferredProxyPropagator
implements Propagator {
    private static final String INFERRED_PROXY_KEY_PREFIX = "x-dd-proxy";

    @Override
    public <C> void inject(Context context, C carrier, CarrierSetter<C> setter) {
    }

    @Override
    public <C> Context extract(Context context, C carrier, CarrierVisitor<C> visitor) {
        if (context == null || carrier == null || visitor == null) {
            return context;
        }
        InferredProxyContextExtractor extractor = new InferredProxyContextExtractor();
        visitor.forEachKeyValue(carrier, extractor);
        InferredProxySpan inferredProxySpan = extractor.inferredProxySpan();
        if (inferredProxySpan != null) {
            context = context.with(inferredProxySpan);
        }
        return context;
    }

    private static class InferredProxyContextExtractor
    implements BiConsumer<String, String> {
        private Map<String, String> values;

        private InferredProxyContextExtractor() {
        }

        @Override
        public void accept(String key, String value) {
            if (key == null || key.isEmpty() || !key.startsWith(InferredProxyPropagator.INFERRED_PROXY_KEY_PREFIX)) {
                return;
            }
            if (this.values == null) {
                this.values = new HashMap<String, String>();
            }
            this.values.put(key, value);
        }

        public InferredProxySpan inferredProxySpan() {
            if (this.values == null) {
                return null;
            }
            InferredProxySpan inferredProxySpan = InferredProxySpan.fromHeaders(this.values);
            return inferredProxySpan.isValid() ? inferredProxySpan : null;
        }
    }
}

