/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.common.writer.ddagent;

import ddtrot.dd.communication.serialization.EncodingCache;
import ddtrot.dd.trace.common.writer.ddagent.Caching;
import java.nio.charset.StandardCharsets;

public final class SimpleUtf8Cache
implements EncodingCache {
    static final int MAX_CAPACITY = 1024;
    private static final int MAX_PROBES = 4;
    private final int[] markers;
    private final CacheEntry[] entries;
    private static final double HIT_DECAY = 0.5;
    private static final double PURGE_THRESHOLD = 0.25;
    static final int MAX_ENTRY_LEN = 128;
    protected int hits = 0;
    protected int evictions = 0;

    public SimpleUtf8Cache(int capacity) {
        int size = Caching.cacheSizeFor(Math.min(capacity, 1024));
        this.markers = new int[size];
        this.entries = new CacheEntry[size];
    }

    public int capacity() {
        return this.entries.length;
    }

    public synchronized void recalibrate() {
        CacheEntry[] thisEntries = this.entries;
        for (int i = 0; i < thisEntries.length; ++i) {
            boolean purge;
            CacheEntry entry = thisEntries[i];
            if (entry == null || !(purge = entry.decay())) continue;
            thisEntries[i] = null;
        }
        Caching.reset(this.markers);
    }

    @Override
    public byte[] encode(CharSequence charSeq) {
        if (charSeq instanceof String) {
            String str = (String)charSeq;
            return this.getUtf8(str);
        }
        return null;
    }

    public final byte[] getUtf8(String value) {
        if (value.length() > 128) {
            return CacheEntry.utf8(value);
        }
        CacheEntry[] thisEntries = this.entries;
        int adjHash = Caching.adjHash(value);
        CacheEntry matchingEntry = SimpleUtf8Cache.lookupEntry(thisEntries, adjHash, value);
        if (matchingEntry != null) {
            matchingEntry.hit();
            ++this.hits;
            return matchingEntry.utf8();
        }
        boolean wasMarked = Caching.mark(this.markers, adjHash);
        if (!wasMarked) {
            return CacheEntry.utf8(value);
        }
        CacheEntry newEntry = new CacheEntry(adjHash, value);
        newEntry.hit();
        boolean evicted = SimpleUtf8Cache.lfuInsert(thisEntries, newEntry);
        if (evicted) {
            ++this.evictions;
        }
        return newEntry.utf8();
    }

    static final CacheEntry lookupEntry(CacheEntry[] entries, int adjHash, String value) {
        int initialBucketIndex = Caching.bucketIndex(entries, adjHash);
        int probe = 0;
        int index = initialBucketIndex;
        while (probe < 4) {
            CacheEntry entry;
            if (index >= entries.length) {
                index = 0;
            }
            if ((entry = entries[index]) != null && entry.matches(adjHash, value)) {
                return entry;
            }
            ++probe;
            ++index;
        }
        return null;
    }

    static final boolean lfuInsert(CacheEntry[] entries, CacheEntry newEntry) {
        int initialBucketIndex = Caching.bucketIndex(entries, newEntry.adjHash());
        double lowestHits = Double.MAX_VALUE;
        int lfuIndex = -1;
        int probe = 0;
        int index = initialBucketIndex;
        while (probe < 4) {
            CacheEntry entry;
            if (index >= entries.length) {
                index = 0;
            }
            if ((entry = entries[index]) == null || entry.isPurgeable()) {
                entries[index] = newEntry;
                return false;
            }
            double hits = entry.score();
            if (hits < lowestHits) {
                lowestHits = hits;
                lfuIndex = index;
            }
            ++probe;
            ++index;
        }
        entries[lfuIndex] = newEntry;
        return true;
    }

    static final class CacheEntry {
        final int adjHash;
        final String value;
        final byte[] valueUtf8;
        boolean promoted = false;
        double score = 0.0;

        public CacheEntry(int adjHash, String value) {
            this.adjHash = adjHash;
            this.value = value;
            this.valueUtf8 = CacheEntry.utf8(value);
        }

        boolean matches(CacheEntry thatEntry) {
            return this == thatEntry || this.matches(thatEntry.adjHash, thatEntry.value);
        }

        boolean matches(int adjHash, String value) {
            return this.adjHash == adjHash && value.equals(this.value);
        }

        int adjHash() {
            return this.adjHash;
        }

        double score() {
            return this.score;
        }

        byte[] utf8() {
            return this.valueUtf8;
        }

        double hit() {
            this.score += 1.0;
            return this.score;
        }

        boolean decay() {
            this.score *= 0.5;
            return this.isPurgeable();
        }

        boolean isPurgeable() {
            return this.score < 0.25;
        }

        static final byte[] utf8(String value) {
            return value.getBytes(StandardCharsets.UTF_8);
        }

        public String toString() {
            return this.value + " - score: " + this.score;
        }
    }
}

