/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.common.sampling;

import datadog.trace.api.sampling.SamplingRule;
import ddtrot.dd.trace.common.sampling.DeterministicSampler;
import ddtrot.dd.trace.common.sampling.PrioritySampler;
import ddtrot.dd.trace.common.sampling.RateByServiceTraceSampler;
import ddtrot.dd.trace.common.sampling.RateSamplingRule;
import ddtrot.dd.trace.common.sampling.Sampler;
import ddtrot.dd.trace.core.CoreSpan;
import ddtrot.dd.trace.core.util.SimpleRateLimiter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleBasedTraceSampler<T extends CoreSpan<T>>
implements Sampler,
PrioritySampler {
    private static final Logger log = LoggerFactory.getLogger(RuleBasedTraceSampler.class);
    private final List<RateSamplingRule> samplingRules;
    private final PrioritySampler fallbackSampler;
    private final SimpleRateLimiter rateLimiter;
    private final long rateLimit;
    public static final String SAMPLING_RULE_RATE = "_dd.rule_psr";
    public static final String SAMPLING_LIMIT_RATE = "_dd.limit_psr";

    public RuleBasedTraceSampler(List<RateSamplingRule> samplingRules, int rateLimit, PrioritySampler fallbackSampler) {
        this.samplingRules = samplingRules;
        this.fallbackSampler = fallbackSampler;
        this.rateLimiter = new SimpleRateLimiter(rateLimit);
        this.rateLimit = rateLimit;
    }

    public static RuleBasedTraceSampler build(List<? extends SamplingRule.TraceSamplingRule> traceSamplingRules, Double defaultRate, int rateLimit) {
        return RuleBasedTraceSampler.build(null, null, traceSamplingRules, defaultRate, rateLimit);
    }

    public static RuleBasedTraceSampler build(@Deprecated Map<String, String> serviceRules, @Deprecated Map<String, String> operationRules, List<? extends SamplingRule.TraceSamplingRule> traceSamplingRules, Double defaultRate, int rateLimit) {
        ArrayList<RateSamplingRule> samplingRules = new ArrayList<RateSamplingRule>();
        if (traceSamplingRules != null && !traceSamplingRules.isEmpty()) {
            if (!serviceRules.isEmpty() || !operationRules.isEmpty()) {
                log.warn("Both {} and/or {} as well as {} are defined. Only {} will be used for rule-based sampling", new Object[]{"trace.sampling.service.rules", "trace.sampling.operation.rules", "trace.sampling.rules", "trace.sampling.rules"});
            }
            for (SamplingRule.TraceSamplingRule traceSamplingRule : traceSamplingRules) {
                RateSamplingRule.TraceSamplingRule samplingRule = new RateSamplingRule.TraceSamplingRule(traceSamplingRule.getService(), traceSamplingRule.getName(), traceSamplingRule.getResource(), traceSamplingRule.getTags(), new DeterministicSampler.TraceSampler(traceSamplingRule.getSampleRate()), RuleBasedTraceSampler.samplingMechanism(traceSamplingRule.getProvenance()));
                samplingRules.add(samplingRule);
            }
        } else {
            RateSamplingRule.PatternMatchSamplingRule samplingRule;
            if (serviceRules != null) {
                for (Map.Entry<String, String> entry : serviceRules.entrySet()) {
                    try {
                        double rateForEntry = Double.parseDouble(entry.getValue());
                        samplingRule = new RateSamplingRule.ServiceSamplingRule(entry.getKey(), new DeterministicSampler.TraceSampler(rateForEntry));
                        samplingRules.add(samplingRule);
                    }
                    catch (NumberFormatException e) {
                        log.error("Unable to parse rate for service: {}", entry, (Object)e);
                    }
                }
            }
            if (operationRules != null) {
                for (Map.Entry entry : operationRules.entrySet()) {
                    try {
                        double rateForEntry = Double.parseDouble((String)entry.getValue());
                        samplingRule = new RateSamplingRule.OperationSamplingRule((String)entry.getKey(), new DeterministicSampler.TraceSampler(rateForEntry));
                        samplingRules.add(samplingRule);
                    }
                    catch (NumberFormatException e) {
                        log.error("Unable to parse rate for operation: {}", (Object)entry, (Object)e);
                    }
                }
            }
        }
        if (defaultRate != null) {
            RateSamplingRule.AlwaysMatchesSamplingRule samplingRule = new RateSamplingRule.AlwaysMatchesSamplingRule(new DeterministicSampler.TraceSampler(defaultRate), 3);
            samplingRules.add(samplingRule);
        }
        return new RuleBasedTraceSampler(samplingRules, rateLimit, new RateByServiceTraceSampler());
    }

    private static byte samplingMechanism(SamplingRule.Provenance provenance) {
        switch (provenance) {
            case DYNAMIC: {
                return 12;
            }
            case CUSTOMER: {
                return 11;
            }
        }
        return 3;
    }

    @Override
    public <T extends CoreSpan<T>> boolean sample(T span) {
        return true;
    }

    @Override
    public <T extends CoreSpan<T>> void setSamplingPriority(T span) {
        RateSamplingRule matchedRule = null;
        for (RateSamplingRule samplingRule : this.samplingRules) {
            if (!samplingRule.matches(span)) continue;
            matchedRule = samplingRule;
            break;
        }
        if (matchedRule == null) {
            this.fallbackSampler.setSamplingPriority(span);
        } else if (matchedRule.sample(span)) {
            if (this.rateLimiter.tryAcquire()) {
                span.setSamplingPriority(2, SAMPLING_RULE_RATE, matchedRule.getSampler().getSampleRate(), matchedRule.getMechanism());
            } else {
                span.setSamplingPriority(-1, SAMPLING_RULE_RATE, matchedRule.getSampler().getSampleRate(), matchedRule.getMechanism());
            }
            span.setMetric((CharSequence)SAMPLING_LIMIT_RATE, this.rateLimit);
        } else {
            span.setSamplingPriority(-1, SAMPLING_RULE_RATE, matchedRule.getSampler().getSampleRate(), matchedRule.getMechanism());
        }
    }
}

