/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.bootstrap.debugger;

import datadog.trace.api.Config;
import ddtrot.dd.trace.bootstrap.debugger.CapturedContext;
import ddtrot.dd.trace.bootstrap.debugger.CapturedContextProbe;
import ddtrot.dd.trace.bootstrap.debugger.DebuggerSpan;
import ddtrot.dd.trace.bootstrap.debugger.MethodLocation;
import ddtrot.dd.trace.bootstrap.debugger.ProbeImplementation;
import ddtrot.dd.trace.bootstrap.debugger.util.TimeoutChecker;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpan;
import java.lang.reflect.Method;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebuggerContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(DebuggerContext.class);
    private static final ThreadLocal<Boolean> IN_PROBE = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private static volatile ProbeResolver probeResolver;
    private static volatile ClassFilter classFilter;
    private static volatile ClassNameFilter classNameFilter;
    private static volatile MetricForwarder metricForwarder;
    private static volatile Tracer tracer;
    private static volatile ValueSerializer valueSerializer;
    private static volatile ExceptionDebugger exceptionDebugger;
    private static volatile CodeOriginRecorder codeOriginRecorder;

    public static void initProbeResolver(ProbeResolver probeResolver) {
        DebuggerContext.probeResolver = probeResolver;
    }

    public static void initMetricForwarder(MetricForwarder metricForwarder) {
        DebuggerContext.metricForwarder = metricForwarder;
    }

    public static void initTracer(Tracer tracer) {
        DebuggerContext.tracer = tracer;
    }

    public static void initClassFilter(ClassFilter classFilter) {
        DebuggerContext.classFilter = classFilter;
    }

    public static void initClassNameFilter(ClassNameFilter classNameFilter) {
        DebuggerContext.classNameFilter = classNameFilter;
    }

    public static void initValueSerializer(ValueSerializer valueSerializer) {
        DebuggerContext.valueSerializer = valueSerializer;
    }

    public static void initExceptionDebugger(ExceptionDebugger exceptionDebugger) {
        DebuggerContext.exceptionDebugger = exceptionDebugger;
    }

    public static void initCodeOrigin(CodeOriginRecorder codeOriginRecorder) {
        DebuggerContext.codeOriginRecorder = codeOriginRecorder;
    }

    public static ProbeImplementation resolveProbe(int probeIndex) {
        ProbeResolver resolver = probeResolver;
        if (resolver == null) {
            return null;
        }
        return resolver.resolve(probeIndex);
    }

    public static boolean isDenied(String fullyQualifiedClassName) {
        ClassFilter filter = classFilter;
        if (filter == null) {
            LOGGER.warn("no class filter => all classes are denied");
            return true;
        }
        return filter.isDenied(fullyQualifiedClassName);
    }

    public static void metric(String probeId, MetricKind kind, String name, long value, String[] tags) {
        try {
            MetricForwarder forwarder = metricForwarder;
            if (forwarder == null) {
                return;
            }
            switch (kind) {
                case COUNT: {
                    forwarder.count(probeId, name, value, tags);
                    break;
                }
                case GAUGE: {
                    forwarder.gauge(probeId, name, value, tags);
                    break;
                }
                case HISTOGRAM: {
                    forwarder.histogram(probeId, name, value, tags);
                    break;
                }
                case DISTRIBUTION: {
                    forwarder.distribution(probeId, name, value, tags);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported metric kind: " + (Object)((Object)kind));
                }
            }
        }
        catch (Exception ex) {
            LOGGER.debug("Error in metric method: ", (Throwable)ex);
        }
    }

    public static void metric(String probeId, MetricKind kind, String name, double value, String[] tags) {
        try {
            MetricForwarder forwarder = metricForwarder;
            if (forwarder == null) {
                return;
            }
            switch (kind) {
                case GAUGE: {
                    forwarder.gauge(probeId, name, value, tags);
                    break;
                }
                case HISTOGRAM: {
                    forwarder.histogram(probeId, name, value, tags);
                    break;
                }
                case DISTRIBUTION: {
                    forwarder.distribution(probeId, name, value, tags);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported metric kind: " + (Object)((Object)kind));
                }
            }
        }
        catch (Exception ex) {
            LOGGER.debug("Error in metric method: ", (Throwable)ex);
        }
    }

    public static String serializeValue(CapturedContext.CapturedValue value) {
        ValueSerializer serializer = valueSerializer;
        if (serializer == null) {
            LOGGER.warn("Cannot serialize value, no serializer set");
            return null;
        }
        return serializer.serializeValue(value);
    }

    public static DebuggerSpan createSpan(String probeId, String operationName, String[] tags) {
        try {
            Tracer localTracer = tracer;
            if (localTracer == null) {
                return DebuggerSpan.NOOP_SPAN;
            }
            return localTracer.createSpan(probeId, operationName, tags);
        }
        catch (Exception ex) {
            LOGGER.debug("Error in createSpan: ", (Throwable)ex);
            return DebuggerSpan.NOOP_SPAN;
        }
    }

    public static boolean isReadyToCapture(Class<?> callingClass, int ... probeIndices) {
        try {
            return DebuggerContext.checkAndSetInProbe();
        }
        catch (Exception ex) {
            LOGGER.debug("Error in isReadyToCapture: ", (Throwable)ex);
            return false;
        }
    }

    public static boolean isReadyToCapture(Class<?> callingClass, int probeIndex) {
        try {
            ProbeImplementation probeImplementation = DebuggerContext.resolveProbe(probeIndex);
            if (probeImplementation == null) {
                return false;
            }
            if (((CapturedContextProbe)((Object)probeImplementation)).isReadyToCapture()) {
                return DebuggerContext.checkAndSetInProbe();
            }
            return false;
        }
        catch (Exception ex) {
            LOGGER.debug("Error in isReadyToCapture: ", (Throwable)ex);
            return false;
        }
    }

    public static void disableInProbe() {
        IN_PROBE.set(Boolean.FALSE);
    }

    public static boolean isInProbe() {
        return IN_PROBE.get();
    }

    public static boolean checkAndSetInProbe() {
        if (IN_PROBE.get().booleanValue()) {
            LOGGER.debug("Instrumentation is reentered, skip it.");
            return false;
        }
        IN_PROBE.set(Boolean.TRUE);
        return true;
    }

    public static void evalContext(CapturedContext context, Class<?> callingClass, long startTimestamp, MethodLocation methodLocation, int ... probeIndices) {
        try {
            boolean needFreeze = false;
            for (int probeIndex : probeIndices) {
                ProbeImplementation probeImplementation = DebuggerContext.resolveProbe(probeIndex);
                if (probeImplementation == null) continue;
                CapturedContext.Status status = context.evaluate(probeImplementation, callingClass.getTypeName(), startTimestamp, methodLocation, false);
                needFreeze |= status.shouldFreezeContext();
            }
            if (needFreeze) {
                Duration timeout = Duration.of(Config.get().getDynamicInstrumentationCaptureTimeout(), ChronoUnit.MILLIS);
                context.freeze(new TimeoutChecker(timeout));
            }
        }
        catch (Exception ex) {
            LOGGER.debug("Error in evalContext: ", (Throwable)ex);
        }
    }

    public static void evalContext(CapturedContext context, Class<?> callingClass, long startTimestamp, MethodLocation methodLocation, int probeIndex) {
        try {
            ProbeImplementation probeImplementation = DebuggerContext.resolveProbe(probeIndex);
            if (probeImplementation == null) {
                return;
            }
            CapturedContext.Status status = context.evaluate(probeImplementation, callingClass.getTypeName(), startTimestamp, methodLocation, true);
            boolean needFreeze = status.shouldFreezeContext();
            if (needFreeze) {
                Duration timeout = Duration.of(Config.get().getDynamicInstrumentationCaptureTimeout(), ChronoUnit.MILLIS);
                context.freeze(new TimeoutChecker(timeout));
            }
        }
        catch (Exception ex) {
            LOGGER.debug("Error in evalContext: ", (Throwable)ex);
        }
    }

    public static void evalContextAndCommit(CapturedContext context, Class<?> callingClass, int line, int ... probeIndices) {
        try {
            ArrayList<ProbeImplementation> probeImplementations = new ArrayList<ProbeImplementation>();
            for (int probeIndex : probeIndices) {
                ProbeImplementation probeImplementation = DebuggerContext.resolveProbe(probeIndex);
                if (probeImplementation == null) continue;
                context.evaluate(probeImplementation, callingClass.getTypeName(), -1L, MethodLocation.DEFAULT, false);
                probeImplementations.add(probeImplementation);
            }
            Object object = probeImplementations.iterator();
            while (object.hasNext()) {
                ProbeImplementation probeImplementation = (ProbeImplementation)object.next();
                probeImplementation.commit(context, line);
            }
        }
        catch (Exception ex) {
            LOGGER.debug("Error in evalContextAndCommit: ", (Throwable)ex);
        }
    }

    public static void evalContextAndCommit(CapturedContext context, Class<?> callingClass, int line, int probeIndex) {
        try {
            ProbeImplementation probeImplementation = DebuggerContext.resolveProbe(probeIndex);
            if (probeImplementation == null) {
                return;
            }
            context.evaluate(probeImplementation, callingClass.getTypeName(), -1L, MethodLocation.DEFAULT, true);
            probeImplementation.commit(context, line);
        }
        catch (Exception ex) {
            LOGGER.debug("Error in evalContextAndCommit: ", (Throwable)ex);
        }
    }

    public static void codeOrigin(int probeIndex) {
        try {
            ProbeImplementation probe = probeResolver.resolve(probeIndex);
            if (probe != null) {
                probe.commit(CapturedContext.EMPTY_CONTEXT, CapturedContext.EMPTY_CONTEXT, Collections.emptyList());
            }
        }
        catch (Exception e) {
            LOGGER.debug("Error in codeOrigin: ", (Throwable)e);
        }
    }

    public static void commit(CapturedContext entryContext, CapturedContext exitContext, List<CapturedContext.CapturedThrowable> caughtExceptions, int ... probeIndices) {
        try {
            if (entryContext == CapturedContext.EMPTY_CONTEXT && exitContext == CapturedContext.EMPTY_CONTEXT) {
                return;
            }
            for (int probeIndex : probeIndices) {
                ProbeImplementation probeImplementation;
                CapturedContext.Status entryStatus = entryContext.getStatus(probeIndex);
                CapturedContext.Status exitStatus = exitContext.getStatus(probeIndex);
                if (entryStatus.probeImplementation != ProbeImplementation.UNKNOWN && (entryStatus.probeImplementation.getEvaluateAt() == MethodLocation.ENTRY || entryStatus.probeImplementation.getEvaluateAt() == MethodLocation.DEFAULT)) {
                    probeImplementation = entryStatus.probeImplementation;
                } else if (exitStatus.probeImplementation.getEvaluateAt() == MethodLocation.EXIT) {
                    probeImplementation = exitStatus.probeImplementation;
                } else {
                    throw new IllegalStateException("no probe details for " + probeIndex);
                }
                probeImplementation.commit(entryContext, exitContext, caughtExceptions);
            }
        }
        catch (Exception ex) {
            LOGGER.debug("Error in commit: ", (Throwable)ex);
        }
    }

    public static void commit(CapturedContext entryContext, CapturedContext exitContext, List<CapturedContext.CapturedThrowable> caughtExceptions, int probeIndex) {
        try {
            ProbeImplementation probeImplementation;
            if (entryContext == CapturedContext.EMPTY_CONTEXT && exitContext == CapturedContext.EMPTY_CONTEXT) {
                return;
            }
            CapturedContext.Status entryStatus = entryContext.getStatus(probeIndex);
            CapturedContext.Status exitStatus = exitContext.getStatus(probeIndex);
            if (entryStatus.probeImplementation != ProbeImplementation.UNKNOWN && (entryStatus.probeImplementation.getEvaluateAt() == MethodLocation.ENTRY || entryStatus.probeImplementation.getEvaluateAt() == MethodLocation.DEFAULT)) {
                probeImplementation = entryStatus.probeImplementation;
            } else if (exitStatus.probeImplementation.getEvaluateAt() == MethodLocation.EXIT) {
                probeImplementation = exitStatus.probeImplementation;
            } else {
                throw new IllegalStateException("no probe details for " + probeIndex);
            }
            probeImplementation.commit(entryContext, exitContext, caughtExceptions);
        }
        catch (Exception ex) {
            LOGGER.debug("Error in commit: ", (Throwable)ex);
        }
    }

    public static void marker() {
    }

    public static void captureCodeOrigin(boolean entry) {
        try {
            CodeOriginRecorder recorder = codeOriginRecorder;
            if (recorder != null) {
                recorder.captureCodeOrigin(entry);
            }
        }
        catch (Exception ex) {
            LOGGER.debug("Error in captureCodeOrigin: ", (Throwable)ex);
        }
    }

    public static void captureCodeOrigin(Method method, boolean entry) {
        try {
            CodeOriginRecorder recorder = codeOriginRecorder;
            if (recorder != null) {
                recorder.captureCodeOrigin(method, entry);
            }
        }
        catch (Exception ex) {
            LOGGER.debug("Error in captureCodeOrigin: ", (Throwable)ex);
        }
    }

    public static void handleException(Throwable t, AgentSpan span) {
        try {
            ExceptionDebugger exDebugger = exceptionDebugger;
            if (exDebugger == null) {
                return;
            }
            exDebugger.handleException(t, span);
        }
        catch (Exception ex) {
            LOGGER.debug("Error in handleException: ", (Throwable)ex);
        }
    }

    public static boolean isClassNameExcluded(String className) {
        try {
            return classNameFilter != null && classNameFilter.isExcluded(className);
        }
        catch (Exception ex) {
            LOGGER.debug("Error in isClassNameExcluded: ", (Throwable)ex);
            return false;
        }
    }

    public static interface CodeOriginRecorder {
        public String captureCodeOrigin(boolean var1);

        public String captureCodeOrigin(Method var1, boolean var2);
    }

    public static interface ExceptionDebugger {
        public void handleException(Throwable var1, AgentSpan var2);
    }

    public static interface ValueSerializer {
        public String serializeValue(CapturedContext.CapturedValue var1);
    }

    public static interface Tracer {
        public DebuggerSpan createSpan(String var1, String var2, String[] var3);
    }

    public static interface MetricForwarder {
        public void count(String var1, String var2, long var3, String[] var5);

        public void gauge(String var1, String var2, long var3, String[] var5);

        public void gauge(String var1, String var2, double var3, String[] var5);

        public void histogram(String var1, String var2, long var3, String[] var5);

        public void histogram(String var1, String var2, double var3, String[] var5);

        public void distribution(String var1, String var2, long var3, String[] var5);

        public void distribution(String var1, String var2, double var3, String[] var5);
    }

    public static enum MetricKind {
        COUNT,
        GAUGE,
        HISTOGRAM,
        DISTRIBUTION;

    }

    public static interface ClassNameFilter {
        public boolean isExcluded(String var1);
    }

    public static interface ClassFilter {
        public boolean isDenied(String var1);
    }

    public static interface ProbeResolver {
        public ProbeImplementation resolve(int var1);
    }

    public static enum SkipCause {
        RATE{

            @Override
            public String tag() {
                return "cause:rate";
            }
        }
        ,
        CONDITION{

            @Override
            public String tag() {
                return "cause:condition";
            }
        }
        ,
        DEBUG_SESSION_DISABLED{

            @Override
            public String tag() {
                return "cause:debug session disabled";
            }
        }
        ,
        BUDGET{

            @Override
            public String tag() {
                return "cause:budget_exceeded";
            }
        };


        public abstract String tag();
    }
}

