/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.bootstrap.config.provider.stableconfig;

import ddtrot.dd.trace.bootstrap.config.provider.stableconfig.Selector;
import ddtrot.dd.trace.bootstrap.config.provider.stableconfig.StableConfigMappingException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class Rule {
    private final List<Selector> selectors;
    private final Map<String, Object> configuration;

    public Rule() {
        this.selectors = Collections.emptyList();
        this.configuration = Collections.emptyMap();
    }

    public Rule(List<Selector> selectors, Map<String, Object> configuration) {
        this.selectors = selectors;
        this.configuration = configuration;
    }

    public static Rule from(Map<?, ?> map) {
        Object configObj;
        Object selectorsObj = map.get("selectors");
        if (selectorsObj == null) {
            StableConfigMappingException.throwStableConfigMappingException("Missing 'selectors' in rule:", map);
        }
        if (!(selectorsObj instanceof List)) {
            StableConfigMappingException.throwStableConfigMappingException("'selectors' must be a list, but got: " + selectorsObj.getClass().getSimpleName() + ": ", selectorsObj);
        }
        if ((configObj = map.get("configuration")) == null) {
            StableConfigMappingException.throwStableConfigMappingException("Missing 'configuration' in rule:", map);
        }
        if (!(configObj instanceof Map)) {
            StableConfigMappingException.throwStableConfigMappingException("'configuration' must be a map, but got: " + configObj.getClass().getSimpleName() + ": ", configObj);
        }
        List selectors = ((List)selectorsObj).stream().filter(Objects::nonNull).map(s -> {
            if (!(s instanceof Map)) {
                StableConfigMappingException.throwStableConfigMappingException("Each selector must be a map, but got: " + s.getClass().getSimpleName() + ": ", s);
            }
            return Selector.from((Map)s);
        }).collect(Collectors.toList());
        return new Rule(Collections.unmodifiableList(selectors), (Map)configObj);
    }

    public List<Selector> getSelectors() {
        return this.selectors;
    }

    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }
}

