/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.telemetry;

import javax.annotation.Nullable;

public enum RuleType {
    LFI(Type.LFI),
    SQL_INJECTION(Type.SQL_INJECTION),
    SSRF_REQUEST(Type.SSRF, Variant.REQUEST),
    SSRF_RESPONSE(Type.SSRF, Variant.RESPONSE),
    SHELL_INJECTION(Type.COMMAND_INJECTION, Variant.SHELL),
    COMMAND_INJECTION(Type.COMMAND_INJECTION, Variant.EXEC);

    public final Type type;
    @Nullable
    public final Variant variant;
    private static final int numValues;

    private RuleType(Type type) {
        this(type, null);
    }

    private RuleType(Type type, Variant variant) {
        this.type = type;
        this.variant = variant;
    }

    public static int getNumValues() {
        return numValues;
    }

    static {
        numValues = RuleType.values().length;
    }

    public static enum Variant {
        SHELL("shell"),
        EXEC("exec"),
        REQUEST("request"),
        RESPONSE("response");

        public final String name;

        private Variant(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum Type {
        LFI("lfi"),
        SQL_INJECTION("sql_injection"),
        SSRF("ssrf"),
        COMMAND_INJECTION("command_injection");

        public final String name;

        private Type(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

